/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class DefaultPortInfo
implements PortInfo {
    private final Map<ServiceType, Integer> ports = new HashMap<ServiceType, Integer>();
    private final Map<ServiceType, Integer> sslPorts = new HashMap<ServiceType, Integer>();

    @JsonCreator
    public DefaultPortInfo(@JsonProperty(value="services") Map<String, Integer> services) {
        for (Map.Entry<String, Integer> entry : services.entrySet()) {
            String service = entry.getKey();
            int port = entry.getValue();
            if (service.equals("mgmt")) {
                this.ports.put(ServiceType.CONFIG, port);
                continue;
            }
            if (service.equals("capi")) {
                this.ports.put(ServiceType.VIEW, port);
                continue;
            }
            if (service.equals("kv")) {
                this.ports.put(ServiceType.BINARY, port);
                continue;
            }
            if (service.equals("kvSSL")) {
                this.sslPorts.put(ServiceType.BINARY, port);
                continue;
            }
            if (service.equals("capiSSL")) {
                this.sslPorts.put(ServiceType.VIEW, port);
                continue;
            }
            if (!service.equals("mgmtSSL")) continue;
            this.sslPorts.put(ServiceType.CONFIG, port);
        }
    }

    @Override
    public Map<ServiceType, Integer> ports() {
        return this.ports;
    }

    @Override
    public Map<ServiceType, Integer> sslPorts() {
        return this.sslPorts;
    }

    public String toString() {
        return "DefaultPortInfo{ports=" + this.ports + ", sslPorts=" + this.sslPorts + '}';
    }
}

