/*
 * Decompiled with CFR 0.152.
 */
package com.imomo.momo.mediaencoder;

import com.imomo.momo.mediaencoder.FFMediaUtils;

public class FFBgChanger
extends FFMediaUtils {
    private long mHandler;
    private OnBgChangerListener mListener;
    private final int CALL_BACK_PROGRESS_TAG = 1;
    private final int CALL_BACK_ERROR_TAG = -1;

    private native long nativeInitBgChanger(Object var1);

    private native void nativeBgChangerSetMixModeAndRatio(long var1, int var3, int var4);

    private native int nativeBgChangerSetOutputFileName(long var1, String var3);

    private native int nativeBgChangerInitVideoSource(long var1, String var3);

    private native int nativeBgChangerInitAudioSource(long var1, String var3, long var4, long var6);

    private native void nativeBgChangerStartProcess(long var1);

    private native void nativeBgChangerRelease(long var1);

    public boolean initBgChanger() {
        this.mHandler = this.nativeInitBgChanger(this);
        return this.mHandler != 0L;
    }

    public void setBgChangerListener(OnBgChangerListener onBgChangerListener) {
        this.mListener = onBgChangerListener;
    }

    public void setMixModeAndRatio(Boolean bl, float f) {
        int n = bl != false ? 1 : 0;
        int n2 = (int)(f * 255.0f);
        if (n2 > 255) {
            n2 = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.nativeBgChangerSetMixModeAndRatio(this.mHandler, n, n2);
    }

    public boolean setOutputFileName(String string) {
        int n = this.nativeBgChangerSetOutputFileName(this.mHandler, string);
        return n >= 0;
    }

    public boolean initVideoSource(String string) {
        int n = this.nativeBgChangerInitVideoSource(this.mHandler, string);
        return n >= 0;
    }

    public boolean initAudioSource(String string, long l, long l2) {
        int n = this.nativeBgChangerInitAudioSource(this.mHandler, string, l, l2);
        return n >= 0;
    }

    public void startProcess() {
        this.nativeBgChangerStartProcess(this.mHandler);
    }

    public void release() {
        this.nativeBgChangerRelease(this.mHandler);
        this.mHandler = 0L;
    }

    public void onObtainMessage(int n, int n2, Object object) {
        if (n == 1 && this.mListener != null) {
            this.mListener.onProgress(n2);
        }
        if (n == -1 && this.mListener != null) {
            this.mListener.onError(n2);
        }
    }

    private static void postEventFromNative(FFBgChanger fFBgChanger, int n, int n2, int n3) {
        if (fFBgChanger == null) {
            return;
        }
        fFBgChanger.onObtainMessage(n, n2, n3);
    }

    public static interface OnBgChangerListener {
        public void onProgress(int var1);

        public void onError(int var1);
    }
}

