/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.motioncamera;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.mask.motioncamera.MotionCameraFilterAdapter;
import com.momo.mcamera.mask.motioncamera.MotionCameraInterpolator;

public class MotionMoveJob
extends AnimatorListenerAdapter
implements ValueAnimator.AnimatorUpdateListener {
    private ValueAnimator animationT;
    private ValueAnimator animationL;
    private ValueAnimator animationR;
    private ValueAnimator animationB;
    private AnimatorSet set;
    private Handler handler = new Handler(Looper.getMainLooper());
    private MotionCameraFilterAdapter.OnCropRegionChangedListener regionChangedListener;
    private RectF dstRectF = new RectF(-1.0f, -1.0f, -1.0f, -1.0f);

    MotionMoveJob() {
        this.set = new AnimatorSet();
    }

    boolean isRunning() {
        return this.set.isRunning();
    }

    /*
     * WARNING - void declaration
     */
    public void start(float duration, RectF rect, RectF dstRect) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.animationT = ValueAnimator.ofFloat((float[])new float[]{rect.top, dstRect.top});
        this.animationL = ValueAnimator.ofFloat((float[])new float[]{rect.left, dstRect.left});
        this.animationR = ValueAnimator.ofFloat((float[])new float[]{rect.right, dstRect.right});
        this.animationB = ValueAnimator.ofFloat((float[])new float[]{rect.bottom, dstRect.bottom});
        this.animationT.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.animationL.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.animationR.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.animationB.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.set.setDuration((long)(duration * 1000.0f));
        this.set.setInterpolator((TimeInterpolator)new MotionCameraInterpolator(0.5f, 0.0f, 0.5f, 1.0f));
        this.set.addListener((Animator.AnimatorListener)this);
        this.set.playTogether(new Animator[]{this.animationT, this.animationL, this.animationR, this.animationB});
        MDLog.d((String)"MotionFilter", (String)("MotionMoveJob start, duration=" + (float)(var1_1 * 1000.0f) + ", rect=" + var2_2.toShortString() + ", dstRect=" + var3_3.toShortString()));
        this.handler.post(new Runnable(this){
            final /* synthetic */ MotionMoveJob this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.set.start();
            }
        });
    }

    void cancel() {
        this.handler.post(new Runnable(this){
            final /* synthetic */ MotionMoveJob this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.set.cancel();
                this.this$0.handler.removeCallbacksAndMessages(null);
            }
        });
        this.regionChangedListener = null;
    }

    /*
     * WARNING - void declaration
     */
    void setCropRegionChangedListener(MotionCameraFilterAdapter.OnCropRegionChangedListener regionChangedListener) {
        void var1_1;
        this.regionChangedListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void onAnimationUpdate(ValueAnimator animation) {
        void var1_1;
        float f = ((Float)animation.getAnimatedValue()).floatValue();
        if (animation == this.animationT) {
            this.dstRectF.top = f;
        } else if (animation == this.animationL) {
            this.dstRectF.left = f;
        } else if (animation == this.animationR) {
            this.dstRectF.right = f;
        } else if (var1_1 == this.animationB) {
            this.dstRectF.bottom = f;
        }
        if (this.dstRectF.top != -1.0f && this.dstRectF.left != -1.0f && this.dstRectF.right != -1.0f && this.dstRectF.bottom != -1.0f) {
            MDLog.d((String)"MotionFilter", (String)("onAnimationUpdate \u56db\u4e2a\u503c\u90fd\u66f4\u65b0\u5b8c\uff0c\u53ef\u4ee5\u505a\u4e00\u6b21\u7ed8\u5236. rectF=" + this.dstRectF.toShortString()));
            if (this.regionChangedListener != null) {
                this.regionChangedListener.onCropRegionChanged(this.dstRectF.left, this.dstRectF.top, this.dstRectF.right, this.dstRectF.bottom);
            }
            this.dstRectF.set(-1.0f, -1.0f, -1.0f, -1.0f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onAnimationStart(Animator animation) {
        void var1_1;
        super.onAnimationStart((Animator)var1_1);
        MDLog.d((String)"MotionFilter", (String)"onAnimationStart.");
    }

    /*
     * WARNING - void declaration
     */
    public void onAnimationEnd(Animator animation) {
        void var1_1;
        super.onAnimationEnd((Animator)var1_1);
        MDLog.d((String)"MotionFilter", (String)"onAnimationEnd.");
        this.removeAnimAllListener();
    }

    /*
     * WARNING - void declaration
     */
    public void onAnimationCancel(Animator animation) {
        void var1_1;
        super.onAnimationCancel((Animator)var1_1);
        MDLog.d((String)"MotionFilter", (String)"onAnimationCancel.");
        this.removeAnimAllListener();
    }

    private void removeAnimAllListener() {
        if (this.animationT != null) {
            this.animationT.removeAllListeners();
        }
        if (this.animationL != null) {
            this.animationL.removeAllListeners();
        }
        if (this.animationR != null) {
            this.animationR.removeAllListeners();
        }
        if (this.animationB != null) {
            this.animationB.removeAllListeners();
        }
        if (this.set != null) {
            this.set.removeAllListeners();
        }
    }
}

