/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.motioncamera;

import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.core.glcore.cv.MMCVInfo;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.mask.motioncamera.MotionCameraFilterJob;
import com.momo.mcamera.mask.motioncamera.MotionMoveJob;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import project.android.imageprocessing.model.FilterOptions;

public class MotionCameraFilterAdapter
implements MotionCameraFilterJob.IMotionFilterJobListener {
    public static final String MotionFilterTAG = "MotionFilter";
    private int START_MOVE_WHAT = 4352;
    private LinkedList<MotionCameraFilterJob> jobQueue = new LinkedList();
    private MMCVInfo mmcvInfo;
    private MMCVInfo scaleMMCVInfo;
    private int width;
    private int height;
    private PointF lastCropCenterPoint = new PointF(0.5f, 0.5f);
    private OnCropRegionChangedListener listener;
    private float currentScale = 1.0f;
    private MotionCameraFilterJob currentJob;
    private boolean hasFace = false;
    private float moCamPushDuration = 1.0f;
    private float moCamPullDuration = 1.0f;
    private float moCamScale = 0.9f;
    private int moCam_T = 2;
    private int moCam_t0 = 2;
    private int moCam_CD = 0;
    private int moCam_Cnt = 8;
    private int moCam_moveT = 8;
    private int moveLoopInterval = this.moCam_moveT - this.moCam_CD;
    private boolean canMove = true;
    private int currentMoveCount = 0;
    private MotionMoveJob motionMoveJob = new MotionMoveJob();
    private Timer canMoveTimer = new Timer();
    private Timer whileLoopTimer = new Timer();
    private Handler handler = new Handler(this, Looper.getMainLooper()){
        final /* synthetic */ MotionCameraFilterAdapter this$0;
        {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((Looper)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void handleMessage(Message msg) {
            void var1_1;
            super.handleMessage(msg);
            if (var1_1.what == this.this$0.START_MOVE_WHAT) {
                MDLog.d((String)MotionCameraFilterAdapter.MotionFilterTAG, (String)("\u79fb\u52a8move Job , \u5904\u7406\u6d88\u606f, isJobMoveRunning=" + this.this$0.isJobMoveRunning()));
                if (this.this$0.mmcvInfo != null && this.this$0.mmcvInfo.getMaxFaceCnt() > 0 && !this.this$0.isJobMoveRunning() && this.this$0.currentMoveCount <= this.this$0.moCam_Cnt) {
                    MDLog.d((String)MotionCameraFilterAdapter.MotionFilterTAG, (String)("\u79fb\u52a8move Job , currentMoveCount=" + this.this$0.currentMoveCount + ", moCam_Cnt=" + this.this$0.moCam_Cnt));
                    MotionCameraFilterAdapter.access$500(this.this$0, this.this$0.mmcvInfo);
                }
            }
        }
    };

    /*
     * WARNING - void declaration
     */
    public MotionCameraFilterAdapter(OnCropRegionChangedListener listener) {
        void var1_1;
        this.listener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFilterOptions(FilterOptions options) {
        void var1_1;
        this.moCamPushDuration = options.getMoCamPushDuration();
        this.moCamPullDuration = options.getMoCamPullDuration();
        this.moCamScale = options.getMoCamScale();
        this.moCam_T = options.getMoCam_T();
        this.moCam_t0 = options.getMoCam_t0();
        this.moCam_CD = options.getMoCam_CD();
        this.moCam_Cnt = options.getMoCam_Cnt();
        this.moCam_moveT = var1_1.getMoCam_moveT();
        this.moveLoopInterval = this.moCam_moveT - this.moCam_CD;
        this.startTimer();
    }

    public void startTimer() {
        this.whileLoopTimer.schedule(new TimerTask(this){
            final /* synthetic */ MotionCameraFilterAdapter this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                MDLog.d((String)MotionCameraFilterAdapter.MotionFilterTAG, (String)("\u5927\u5468\u671f\u65f6\u95f4\u5230\u4e86\uff0c\u72b6\u6001\u91cd\u7f6e\uff0c\u5f00\u542f\u8fd0\u52a8. moveLoopInterval=" + this.this$0.moveLoopInterval + ", moCam_moveT=" + this.this$0.moCam_moveT));
                MotionCameraFilterAdapter.access$302(this.this$0, 0);
                MotionCameraFilterAdapter.access$802(this.this$0, true);
                if (this.this$0.moveLoopInterval < this.this$0.moCam_moveT) {
                    this.this$0.canMoveTimer.purge();
                    this.this$0.canMoveTimer.schedule(new TimerTask(this){
                        final /* synthetic */ 2 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void run() {
                            MDLog.d((String)MotionCameraFilterAdapter.MotionFilterTAG, (String)"\u8fd0\u52a8\u4e0a\u7ebf\u65f6\u95f4\u5230\u4e86\uff0c\u5173\u95ed\u8fd0\u52a8.");
                            MotionCameraFilterAdapter.access$802(this.this$1.this$0, false);
                            this.this$1.this$0.jobQueue.clear();
                            if (this.this$1.this$0.currentJob != null && this.this$1.this$0.currentJob.isRunning()) {
                                this.this$1.this$0.currentJob.cancel();
                            }
                            if (this.this$1.this$0.currentScale <= 0.99f) {
                                MDLog.d((String)MotionCameraFilterAdapter.MotionFilterTAG, (String)"\u8fd0\u52a8\u4e0a\u7ebf\u65f6\u95f4\u5230\u4e86\uff0c\u5173\u95ed\u8fd0\u52a8.\u5f3a\u5236\u505a\u4e00\u4e2a\u6536\u955c\u52a8\u4f5c");
                                MotionCameraFilterAdapter.access$1302(this.this$1.this$0, this.this$1.this$0.mmcvInfo);
                                MotionCameraFilterJob motionCameraFilterJob = new MotionCameraFilterJob(this.this$1.this$0.moCamPullDuration, this.this$1.this$0.moCamScale, 1.0f);
                                motionCameraFilterJob.setMotionFilterJobListener(this.this$1.this$0);
                                motionCameraFilterJob.start();
                                MotionCameraFilterAdapter.access$1602(this.this$1.this$0, false);
                            }
                        }
                    }, this.this$0.moveLoopInterval * 1000);
                }
            }
        }, this.moCam_moveT * 1000, (long)(this.moCam_moveT * 1000));
    }

    /*
     * WARNING - void declaration
     */
    public boolean addJob(MotionCameraFilterJob job) {
        void var1_1;
        if (this.currentJob != null && this.currentJob.isRunning()) {
            return false;
        }
        this.jobQueue.addLast((MotionCameraFilterJob)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateMMCVInfo(MMCVInfo mmcvInfo, int width, int height) {
        block7: {
            boolean bl;
            block8: {
                MotionCameraFilterAdapter motionCameraFilterAdapter;
                block6: {
                    void var3_3;
                    void var2_2;
                    this.mmcvInfo = mmcvInfo;
                    this.width = var2_2;
                    this.height = var3_3;
                    if (!this.canMove) {
                        MDLog.d((String)MotionFilterTAG, (String)"\u88ab\u7981\u6b62\u8fd0\u52a8\u4e86.return.");
                        return;
                    }
                    if (!(mmcvInfo.getMaxFaceCnt() > 0)) break block6;
                    if (this.hasFace || !this.jobQueue.isEmpty()) break block7;
                    MDLog.d((String)MotionFilterTAG, (String)"addJob ,\u6709\u4eba\u8138\uff0c\u4e14\u4e4b\u524d\u4e5f\u6ca1\u4eba\u8138\uff08\u4eba\u8138\u51fa\u73b0\u65f6\uff09");
                    MotionCameraFilterAdapter motionCameraFilterAdapter2 = this;
                    motionCameraFilterAdapter = motionCameraFilterAdapter2;
                    bl = motionCameraFilterAdapter2.addJob(new MotionCameraFilterJob(this.moCamPushDuration, 1.0f, this.moCamScale));
                    break block8;
                }
                if (!this.hasFace || !this.jobQueue.isEmpty()) break block7;
                MDLog.d((String)MotionFilterTAG, (String)"addJob ,\u6ca1\u4eba\u8138\uff0c\u4e14\u4e4b\u524d\u6709\u4eba\u8138\uff08\u4eba\u8138\u6d88\u5931\u65f6\uff09");
                MotionCameraFilterAdapter motionCameraFilterAdapter3 = this;
                motionCameraFilterAdapter = motionCameraFilterAdapter3;
                bl = !motionCameraFilterAdapter3.addJob(new MotionCameraFilterJob(this.moCamPullDuration, this.moCamScale, 1.0f));
            }
            motionCameraFilterAdapter.hasFace = bl;
        }
        MDLog.d((String)MotionFilterTAG, (String)("\u5141\u8bb8\u8fd0\u52a8, jobQueue.isEmpty()=" + this.jobQueue.isEmpty() + ", isJobMoveRunning()=" + this.isJobMoveRunning() + ", hasMessages=" + this.handler.hasMessages(this.START_MOVE_WHAT)));
        if (!this.jobQueue.isEmpty() && !this.isJobMoveRunning() && this.currentMoveCount <= this.moCam_Cnt) {
            void var1_1;
            this.scaleMMCVInfo = var1_1;
            this.currentJob = this.jobQueue.pop();
            this.currentJob.setMotionFilterJobListener(this);
            this.currentJob.start();
            MDLog.d((String)MotionFilterTAG, (String)("\u6267\u884c\u4f38\u7f29\u955c\u5934Job , currentMoveCount=" + this.currentMoveCount + ", limitMoveCount=" + this.moCam_Cnt));
            ++this.currentMoveCount;
        }
        if (!this.handler.hasMessages(this.START_MOVE_WHAT)) {
            this.handler.sendEmptyMessageDelayed(this.START_MOVE_WHAT, (long)(this.moCam_T * 1000));
        }
    }

    private void move(MMCVInfo mmcvInfo) {
        float[] fArray;
        MDLog.d((String)MotionFilterTAG, (String)("move,   currentScale=" + this.currentScale));
        fArray = fArray.getFaceAttributeInfo(0).getFaceRect();
        float f = (fArray[2] + fArray[0]) * 0.5f;
        float f2 = (fArray[3] + fArray[1]) * 0.5f;
        float f3 = (float)this.width * this.currentScale;
        float f4 = (float)this.height * this.currentScale;
        MotionCameraFilterAdapter motionCameraFilterAdapter = this;
        RectF rectF = motionCameraFilterAdapter.calculateCropRegion(motionCameraFilterAdapter.lastCropCenterPoint.x, this.lastCropCenterPoint.y, f3, f4);
        this.lastCropCenterPoint.x = f;
        this.lastCropCenterPoint.y = f2;
        RectF rectF2 = this.calculateCropRegion(f, f2, f3, f4);
        this.motionMoveJob.setCropRegionChangedListener(this.listener);
        this.motionMoveJob.start(this.moCam_t0, rectF, rectF2);
        ++this.currentMoveCount;
    }

    private RectF calculateCropRegion(float centerX, float centerY, float displayWidth, float displayHeight) {
        RectF rectF;
        float f;
        float f2;
        float f3;
        float f4 = centerX - displayWidth * 0.5f;
        f2 += f3 * 0.5f;
        f3 = centerY - displayHeight * 0.5f;
        f += displayHeight * 0.5f;
        if (f4 < 0.0f) {
            f2 += 0.0f - f4;
            f4 = 0.0f;
        } else if (f2 > (float)this.width) {
            f4 -= f2 - (float)this.width;
            f2 = this.width;
        }
        if (f3 < 0.0f) {
            f += 0.0f - f3;
            f3 = 0.0f;
        } else if (f > (float)this.height) {
            f3 -= f - (float)this.height;
            f = this.height;
        }
        RectF rectF2 = new RectF(f4 / (float)this.width, f3 / (float)this.height, f2 / (float)this.width, f / (float)this.height);
        if (rectF.left < 0.001f) {
            rectF2.left = 0.0f;
        }
        if (rectF2.top < 0.001f) {
            rectF2.top = 0.0f;
        }
        if (rectF2.right < 0.001f) {
            rectF2.right = 0.0f;
        }
        if (rectF2.bottom < 0.001f) {
            rectF2.bottom = 0.0f;
        }
        return rectF2;
    }

    @Override
    public void onScaleChanged(float scale) {
        float f;
        float f2;
        float f3;
        MDLog.d((String)MotionFilterTAG, (String)("onScaleChanged , \u955c\u5934\u6536\u7f29\u5f00\u59cb\u7684\u65f6\u5019\u56de\u8c03\uff0c scale=" + scale + ", width=" + this.width + ", height=" + this.height));
        this.currentScale = scale;
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (this.scaleMMCVInfo == null || this.scaleMMCVInfo.getMaxFaceCnt() <= 0) {
            f3 = this.lastCropCenterPoint.x;
            f2 = this.lastCropCenterPoint.y;
        } else {
            float[] fArray = this.scaleMMCVInfo.getFaceAttributeInfo(0).getFaceRect();
            f3 = (fArray[2] + fArray[0]) * 0.5f;
            f2 = (fArray[3] + fArray[1]) * 0.5f;
            this.lastCropCenterPoint.x = f3;
            this.lastCropCenterPoint.y = f2;
        }
        float f4 = (float)this.width * scale;
        f = (float)this.height * f;
        RectF rectF = this.calculateCropRegion(f3, f2, f4, f);
        if (this.listener != null) {
            this.listener.onCropRegionChanged(rectF.left, rectF.top, rectF.right, rectF.bottom);
        }
    }

    @Override
    public void onJobEnd() {
    }

    private boolean isJobMoveRunning() {
        return this.currentJob != null && this.currentJob.isRunning() || this.motionMoveJob.isRunning();
    }

    public void release() {
        this.cancelTimer();
        this.cancelJobs();
        this.releaseCallbacks();
    }

    private void cancelTimer() {
        this.canMoveTimer.purge();
        this.canMoveTimer.cancel();
        this.whileLoopTimer.purge();
        this.whileLoopTimer.cancel();
    }

    private void cancelJobs() {
        this.jobQueue.clear();
        this.motionMoveJob.cancel();
        if (this.currentJob != null && this.currentJob.isRunning()) {
            this.currentJob.cancel();
        }
    }

    private void releaseCallbacks() {
        this.listener = null;
        this.handler.removeCallbacksAndMessages(null);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(MotionCameraFilterAdapter x0, MMCVInfo x1) {
        void var1_1;
        x0.move((MMCVInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$302(MotionCameraFilterAdapter x0, int x1) {
        void var1_1;
        x0.currentMoveCount = var1_1;
        return x0.currentMoveCount;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$802(MotionCameraFilterAdapter x0, boolean x1) {
        void var1_1;
        x0.canMove = var1_1;
        return x0.canMove;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MMCVInfo access$1302(MotionCameraFilterAdapter x0, MMCVInfo x1) {
        void var1_1;
        x0.scaleMMCVInfo = var1_1;
        return x0.scaleMMCVInfo;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1602(MotionCameraFilterAdapter x0, boolean x1) {
        void var1_1;
        x0.hasFace = var1_1;
        return x0.hasFace;
    }

    public static interface OnCropRegionChangedListener {
        public void onCropRegionChanged(float var1, float var2, float var3, float var4);
    }
}

