/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.graphics.PointF;
import com.momo.mcamera.mask.StickerGameItem;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.mask.delegate.GameScoreListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StickerGameEngine {
    public List<StickerGameItem> stickerItemList = new ArrayList<StickerGameItem>();
    public List<Trajectory> trajectoryList = new ArrayList<Trajectory>();
    public int stickerNumbers = 5;
    public int columnNumber = 10;
    private int stickerGroupCount = 0;
    private int mCoreNumber = 0;
    float mousePosLeftTopX = 0.0f;
    float mousePosLeftTopY = 0.0f;
    float mousePosRightBottomY = 0.0f;
    float mousePosRightBottomX = 0.0f;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private float srcImageWidthScaleRatio = 0.0f;
    private float srcImageHeightScaleRatio = 0.0f;
    private float stickWidthScaleRatio = 0.8f;
    private float stickHeightScaleRatio = 0.8f;
    private List<Float> notUsedTrajectory;
    private List<Float> usedTrajectory;

    public StickerGameEngine() {
        for (int i = 0; i < this.stickerNumbers; ++i) {
            this.generateNewTrajectory(i);
        }
    }

    private void generateTrajectoryXPosition() {
        if (this.notUsedTrajectory == null) {
            this.notUsedTrajectory = new ArrayList<Float>();
            this.usedTrajectory = new ArrayList<Float>();
        } else {
            this.notUsedTrajectory.clear();
            this.usedTrajectory.clear();
        }
        if (this.notUsedTrajectory != null && (double)this.srcImageWidthScaleRatio > 0.0) {
            float f = (1.0f - this.srcImageWidthScaleRatio) / 2.0f + 0.15f;
            float f2 = (1.0f - f * 2.0f) / (float)this.columnNumber;
            for (int i = 0; i < this.columnNumber; ++i) {
                this.notUsedTrajectory.add(Float.valueOf(f += f2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addSticker(StickerGameItem item) {
        if (item.sticker.isGameSticker) {
            void var1_1;
            this.stickerItemList.add(item);
            if (var1_1.isGameLive) {
                ++this.stickerGroupCount;
            }
        }
    }

    public float getAdjustHeightScale() {
        if ((float)this.imageHeight == 640.0f) {
            return 1.0f;
        }
        return (float)this.imageHeight / 640.0f;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setTimeStamp(long ms) {
        void var1_1;
        if (this.notUsedTrajectory == null || this.imageWidth == 0) {
            return;
        }
        this.updateTrajectory((long)var1_1);
        for (Trajectory trajectory : this.trajectoryList) {
            for (StickerGameItem stickerGameItem : this.stickerItemList) {
                if (stickerGameItem.sticker.groupNumber != trajectory.bindStickerGroup || (!trajectory.isFixed || stickerGameItem.isGameLive) && (trajectory.isFixed || !stickerGameItem.isGameLive)) continue;
                if (!trajectory.isTriggered) {
                    this.isTriggerRegionMatches(stickerGameItem, trajectory);
                }
                float f = this.getAdjustHeightScale() * 2.0f;
                this.stickWidthScaleRatio = 0.1f;
                stickerGameItem.setParamForMatrix(f * this.stickWidthScaleRatio, f * this.stickWidthScaleRatio, new PointF(trajectory.xPosition, trajectory.yPosition), 0.0f);
            }
        }
        this.mousePosLeftTopX = 0.0f;
        this.mousePosLeftTopY = 0.0f;
        this.mousePosRightBottomY = 0.0f;
        this.mousePosRightBottomX = 0.0f;
    }

    public void updateTrajectory(long ms) {
        for (Trajectory trajectory : this.trajectoryList) {
            if (trajectory.startTime == 0L) {
                trajectory.startTime = ms;
            }
            if (trajectory.fixedFrames == trajectory.maxFixFrames) {
                if (this.stickerItemList.size() > trajectory.bindStickerGroup << 1) {
                    this.stickerItemList.get((int)((trajectory.bindStickerGroup << 1) + 1)).sticker.curIndex = 0;
                    trajectory.reset();
                } else {
                    trajectory.needRandomStickerGroup = true;
                    trajectory.reset();
                }
            }
            trajectory.duration = (float)(ms - trajectory.startTime) / 1000.0f;
            if (!trajectory.isFixed) {
                if (trajectory.duration > 0.0f) {
                    trajectory.yPosition = trajectory.yPositionOffset + trajectory.velocity * trajectory.duration;
                }
                if (!((double)trajectory.yPosition > 1.1)) continue;
                for (int i = 0; i < this.usedTrajectory.size(); ++i) {
                    Float f = this.usedTrajectory.get(i);
                    if (f.floatValue() != trajectory.xPosition) continue;
                    this.usedTrajectory.remove(i);
                    this.notUsedTrajectory.add(f);
                    break;
                }
                trajectory.reset();
                continue;
            }
            ++trajectory.fixedFrames;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateNewTrajectory(int index) {
        void var1_1;
        Trajectory trajectory = new Trajectory();
        new Trajectory().bindStickerGroup = var1_1;
        this.trajectoryList.add(trajectory);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void updateTriggerStatus(float mousePosLeftTopX, float mousePosLeftTopY, float mousePosRightBottomX, float mousePosRightBottomY) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mousePosLeftTopX = var1_1;
        this.mousePosLeftTopY = var2_2;
        this.mousePosRightBottomX = var3_3;
        this.mousePosRightBottomY = mousePosRightBottomY;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTriggerRegionMatches(StickerGameItem stickerItem, Trajectory trajectory) {
        float f = trajectory.xPosition * (float)this.imageWidth;
        float f2 = trajectory.yPosition * (float)this.imageHeight;
        if (this.mousePosLeftTopX < f && this.mousePosRightBottomX > f && this.mousePosRightBottomY > f2 && this.mousePosLeftTopY < f2) {
            if (!stickerItem.isGameLive) {
                trajectory.isTriggered = true;
                stickerItem.startPlay();
                if (stickerItem.gameScoreListener != null && !stickerItem.isGameLive) {
                    void var1_1;
                    stickerItem.gameScoreListener.onItemTriggered(var1_1.sticker.getAdditionalInfo().getGameScore());
                }
            }
            trajectory.isFixed = true;
            for (int i = 0; i < this.usedTrajectory.size(); ++i) {
                Float f3 = this.usedTrajectory.get(i);
                if (f3.floatValue() != trajectory.xPosition) continue;
                this.usedTrajectory.remove(i);
                this.notUsedTrajectory.add(f3);
                break;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setImageWidth(int imageWidth) {
        void var1_1;
        this.imageWidth = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setImageHeight(int imageHeight) {
        void var1_1;
        this.imageHeight = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSrcImageWidthScaleRatio(float srcImageWidthScaleRatio) {
        if (this.srcImageWidthScaleRatio != srcImageWidthScaleRatio) {
            void var1_1;
            this.srcImageWidthScaleRatio = var1_1;
            this.generateTrajectoryXPosition();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSrcImageHeightScaleRatio(float srcImageHeightScaleRatio) {
        void var1_1;
        this.srcImageHeightScaleRatio = var1_1;
    }

    public void setGameScoreListener(GameScoreListener listener) {
        Iterator<StickerGameItem> iterator = this.stickerItemList.iterator();
        while (iterator.hasNext()) {
            ((StickerGameItem)((StickerItem)iterator.next())).setGameScoreListener(listener);
        }
    }

    class Trajectory {
        int bindStickerGroup;
        float duration;
        float xPosition;
        float yPositionOffset;
        float yPosition;
        float velocity;
        long startTime;
        boolean isFixed = false;
        int fixedFrames = 0;
        int maxFixFrames = 0;
        int coreNumber;
        boolean needRandomStickerGroup = false;
        boolean isTriggered = false;

        /*
         * WARNING - void declaration
         */
        Trajectory() {
            void var1_1;
            StickerGameEngine.this.mCoreNumber++;
            this.coreNumber = ((StickerGameEngine)var1_1).mCoreNumber;
            this.yPositionOffset = -0.15f * (float)this.coreNumber;
        }

        void reset() {
            if (this.needRandomStickerGroup) {
                this.bindStickerGroup = (int)(Math.random() * 10.0 % (double)StickerGameEngine.this.stickerGroupCount);
            }
            ++this.coreNumber;
            if (this.coreNumber > 5) {
                this.coreNumber = 1;
            }
            this.maxFixFrames = StickerGameEngine.this.stickerItemList.get((int)((this.bindStickerGroup << 1) + 1)).sticker.getFrameNumber();
            this.fixedFrames = 0;
            this.isFixed = false;
            this.duration = 0.0f;
            this.xPosition = (float)Math.random();
            if (StickerGameEngine.this.notUsedTrajectory.size() > 0) {
                int n = (int)(Math.random() * 10.0) % StickerGameEngine.this.notUsedTrajectory.size();
                Float f = (Float)StickerGameEngine.this.notUsedTrajectory.get(n);
                this.xPosition = f.floatValue();
                StickerGameEngine.this.notUsedTrajectory.remove(f);
                StickerGameEngine.this.usedTrajectory.add(f);
            }
            this.velocity = StickerGameEngine.this.stickerItemList.get((int)(this.bindStickerGroup << 1)).downVelocity;
            if (this.isTriggered) {
                this.yPositionOffset = -0.1f * (float)(this.coreNumber + 1) / 2.0f;
                this.velocity = (float)((double)this.velocity - 0.05 * (double)this.coreNumber);
            }
            this.isTriggered = false;
            this.yPosition = this.yPositionOffset;
            this.startTime = 0L;
        }
    }
}

