/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.os.SystemClock;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.core.glcore.util.SegmentHelper;
import com.core.glcore.util.TextureHelper;
import com.cosmos.mdlog.MDLog;
import com.immomo.medialog.MediaStatisticModel;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class SegmentFilter
extends FaceDetectFilter {
    private static final String UNIFORM_TEXTURE_ALPHA = "inputImageTexture2";
    protected MMCVInfo mmcvInfo;
    protected int alphaTexture = 0;
    protected int alphaHandler;
    protected MMFrameInfo mmcvFrame = new MMFrameInfo();
    protected MMParamsInfo params = new MMParamsInfo(4);

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        void var1_1;
        this.mmcvInfo = var1_1;
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.setWidth(source.getWidth());
        this.setHeight(var2_2.getHeight());
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)this, (boolean)var3_3);
    }

    public void drawSub() {
        super.drawSub();
    }

    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture2;\nvarying vec2 textureCoordinate;\nvoid main(){\n   vec4 colorAlpha = texture2D(inputImageTexture2, vec2(textureCoordinate.x, 1.0 - textureCoordinate.y));\n   gl_FragColor = colorAlpha;\n}\n";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.alphaHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXTURE_ALPHA);
    }

    protected void passShaderValues() {
        super.passShaderValues();
        SegmentFilter segmentFilter = this;
        segmentFilter.processSegment(segmentFilter.getWidth(), this.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    protected void processSegment(int width, int height) {
        if (this.mmcvInfo == null || this.mmcvInfo.frameData == null) {
            MDLog.e((String)"lclc", (String)"mmcv is null or mmcv.frameInfo is null");
            return;
        }
        if (this.mmcvInfo.isVideoMode()) {
            this.mmcvFrame.setFormat(17);
        } else {
            this.mmcvFrame.setFormat(4);
            this.params.setSegmentParamsType(false);
        }
        this.mmcvFrame.setDataPtr(this.mmcvInfo.frameData);
        this.mmcvFrame.setDataLen(this.mmcvInfo.frameData.length);
        this.mmcvFrame.setWidth(this.mmcvInfo.getWidth());
        this.mmcvFrame.setHeight(this.mmcvInfo.getHeight());
        this.mmcvFrame.setStep_(this.mmcvInfo.getWidth());
        this.params.setFlipedShow(SegmentHelper.isFrontCamera());
        this.params.setRotateDegree(SegmentHelper.getRotateDegree());
        this.params.setRestoreDegree(SegmentHelper.getRestoreDegree());
        long l = SystemClock.elapsedRealtime();
        byte[] byArray = SegmentHelper.process((MMFrameInfo)this.mmcvFrame, (MMParamsInfo)this.params, (!this.mmcvInfo.isVideoMode() ? 1 : 0) != 0);
        long l2 = SystemClock.elapsedRealtime() - l;
        MediaStatisticModel.getInstance().setImageDetect(l2);
        GLES20.glActiveTexture((int)33987);
        if (this.alphaTexture == 0) {
            this.alphaTexture = TextureHelper.byteToLuminanceTexture((byte[])byArray, (int)width, (int)height);
        } else {
            void var2_2;
            void var1_1;
            TextureHelper.byteToLuminanceTextureBytextureId((int)this.alphaTexture, (byte[])byArray, (int)var1_1, (int)var2_2);
        }
        GLES20.glUniform1i((int)this.alphaHandler, (int)3);
    }

    protected void handleSizeChange() {
        super.handleSizeChange();
        if (this.alphaTexture != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.alphaTexture;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.alphaTexture = 0;
        }
    }

    public void destroy() {
        if (this.alphaTexture != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.alphaTexture;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.alphaTexture = 0;
        }
        super.destroy();
    }
}

