/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public abstract class GLProgram {
    public static final String ATTRIBUTE_POSITION = "position";
    public static final String ATTRIBUTE_TEXCOORD = "inputTextureCoordinate";
    public static final String VARYING_TEXCOORD = "textureCoordinate";
    public static final String UNIFORM_TEXTUREBASE = "inputImageTexture";
    protected boolean initialized = false;
    protected int vertexShaderHandle = 0;
    protected int fragmentShaderHandle = 0;
    protected int programHandle = 0;
    protected int[] textureHandles = null;
    protected int positionHandle = 0;
    protected int[] texCoordHandles = null;
    protected int width = 0;
    protected int height = 0;
    protected int mNumTexture = 0;
    protected int mNumCoord = 0;
    private int type = 4;
    private ByteBuffer mByteBufferVex = null;
    private FloatBuffer mBufferVex = null;
    private ByteBuffer[] mByteBufferTex = null;
    private FloatBuffer[] mBufferTex = null;

    /*
     * WARNING - void declaration
     */
    public GLProgram(int numTexture, int numCoord) {
        void var2_2;
        void var1_1;
        this.mNumTexture = numTexture;
        this.mNumCoord = numCoord;
        this.textureHandles = new int[var1_1];
        this.texCoordHandles = new int[numCoord];
        this.mByteBufferTex = new ByteBuffer[numCoord];
        this.mBufferTex = new FloatBuffer[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public void setDrawType(int type) {
        void var1_1;
        this.type = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRenderSize(int width, int height) {
        void var2_2;
        void var1_1;
        this.width = var1_1;
        this.height = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void drawFrame(float[][] triArray, int[] textures) {
        void var2_2;
        void var1_1;
        if (!this.initialized) {
            this.initWithGLContext();
            this.initialized = true;
        }
        this.subDrawSub((float[][])var1_1, (int[])var2_2);
    }

    public void destroy() {
        if (this.programHandle != 0) {
            GLES20.glDeleteProgram((int)this.programHandle);
            this.programHandle = 0;
        }
        if (this.vertexShaderHandle != 0) {
            GLES20.glDeleteShader((int)this.vertexShaderHandle);
            this.vertexShaderHandle = 0;
        }
        if (this.fragmentShaderHandle != 0) {
            GLES20.glDeleteShader((int)this.fragmentShaderHandle);
            this.fragmentShaderHandle = 0;
        }
        this.initialized = false;
    }

    private String attributeCoord() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.texCoordHandles.length; ++i) {
            stringBuilder.append("attribute vec2 inputTextureCoordinate" + i + ";\n");
            stringBuilder.append("varying vec2 textureCoordinate" + i + ";\n");
        }
        return stringBuilder.toString();
    }

    private String setVaryCoord() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.texCoordHandles.length; ++i) {
            stringBuilder.append(" textureCoordinate" + i + " =  inputTextureCoordinate" + i + ";\n");
        }
        return stringBuilder.toString();
    }

    protected String getSubVertexShader() {
        return "attribute vec4 position;\n" + this.attributeCoord() + "void main() {\n" + this.setVaryCoord() + "   gl_Position = position;\n}\n";
    }

    protected abstract String getSubFrameShader();

    protected void bindShaderAttributes() {
        GLES20.glBindAttribLocation((int)this.programHandle, (int)0, (String)ATTRIBUTE_POSITION);
        for (int i = 0; i < this.texCoordHandles.length; ++i) {
            GLES20.glBindAttribLocation((int)this.programHandle, (int)(i + 1), (String)ATTRIBUTE_TEXCOORD.concat(String.valueOf(i)));
        }
    }

    protected void initShaderHandles() {
        int n;
        this.positionHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION);
        for (n = 0; n < this.textureHandles.length; ++n) {
            this.textureHandles[n] = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXTUREBASE.concat(String.valueOf(n)));
        }
        for (n = 0; n < this.textureHandles.length; ++n) {
            this.texCoordHandles[n] = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_TEXCOORD.concat(String.valueOf(n)));
        }
    }

    protected void initWithGLContext() {
        Object object = this.getSubVertexShader();
        String string = this.getSubFrameShader();
        this.vertexShaderHandle = GLES20.glCreateShader((int)35633);
        String string2 = "none";
        if (this.vertexShaderHandle != 0) {
            GLES20.glShaderSource((int)this.vertexShaderHandle, (String)object);
            GLES20.glCompileShader((int)this.vertexShaderHandle);
            object = new int[1];
            GLES20.glGetShaderiv((int)this.vertexShaderHandle, (int)35713, (int[])object, (int)0);
            if (object[0] == false) {
                string2 = GLES20.glGetShaderInfoLog((int)this.vertexShaderHandle);
                GLES20.glDeleteShader((int)this.vertexShaderHandle);
                this.vertexShaderHandle = 0;
            }
        }
        if (this.vertexShaderHandle == 0) {
            throw new RuntimeException(this.toString() + ": Could not create vertex shader. Reason: " + string2);
        }
        this.fragmentShaderHandle = GLES20.glCreateShader((int)35632);
        if (this.fragmentShaderHandle != 0) {
            GLES20.glShaderSource((int)this.fragmentShaderHandle, (String)string);
            GLES20.glCompileShader((int)this.fragmentShaderHandle);
            object = new int[1];
            GLES20.glGetShaderiv((int)this.fragmentShaderHandle, (int)35713, (int[])object, (int)0);
            if (object[0] == false) {
                string2 = GLES20.glGetShaderInfoLog((int)this.fragmentShaderHandle);
                GLES20.glDeleteShader((int)this.fragmentShaderHandle);
                this.fragmentShaderHandle = 0;
            }
        }
        if (this.fragmentShaderHandle == 0) {
            throw new RuntimeException(this.toString() + ": Could not create fragment shader. Reason: " + string2);
        }
        this.programHandle = GLES20.glCreateProgram();
        if (this.programHandle != 0) {
            GLES20.glAttachShader((int)this.programHandle, (int)this.vertexShaderHandle);
            GLES20.glAttachShader((int)this.programHandle, (int)this.fragmentShaderHandle);
            this.bindShaderAttributes();
            GLES20.glLinkProgram((int)this.programHandle);
            object = new int[1];
            GLES20.glGetProgramiv((int)this.programHandle, (int)35714, (int[])object, (int)0);
            if (object[0] == false) {
                GLES20.glDeleteProgram((int)this.programHandle);
                this.programHandle = 0;
            }
        }
        if (this.programHandle == 0) {
            throw new RuntimeException("Could not create program.");
        }
        GLES20.glDeleteShader((int)this.vertexShaderHandle);
        GLES20.glDeleteShader((int)this.fragmentShaderHandle);
        this.vertexShaderHandle = 0;
        this.fragmentShaderHandle = 0;
        this.initShaderHandles();
    }

    /*
     * WARNING - void declaration
     */
    protected void subDrawSub(float[][] triArray, int[] textures) {
        void var2_2;
        void var1_1;
        GLES20.glUseProgram((int)this.programHandle);
        int n = 0;
        if (triArray != null && triArray.length > 0) {
            n = triArray[0].length / 6;
        }
        this.passShaderValues((float[][])var1_1, (int[])var2_2);
        GLES20.glDrawArrays((int)this.type, (int)0, (int)(n * 3));
        this.disableDrawArray();
    }

    protected void initCoord(float[][] triArray) {
        float[] fArray = triArray[0];
        if (this.mByteBufferVex == null || this.mByteBufferVex.capacity() != fArray.length << 2) {
            this.mByteBufferVex = ByteBuffer.allocateDirect(fArray.length << 2);
            this.mByteBufferVex.order(ByteOrder.nativeOrder());
        }
        if (this.mBufferVex == null) {
            this.mBufferVex = this.mByteBufferVex.asFloatBuffer();
        }
        this.mBufferVex.clear();
        this.mBufferVex.put(fArray);
        this.mBufferVex.flip();
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mBufferVex);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        for (int i = 0; i < this.mByteBufferTex.length; ++i) {
            float[] fArray2 = triArray[i + 1];
            if (this.mByteBufferTex[i] == null) {
                this.mByteBufferTex[i] = ByteBuffer.allocateDirect(fArray2.length << 2);
                this.mByteBufferTex[i].order(ByteOrder.nativeOrder());
            }
            if (this.mBufferTex[i] == null) {
                this.mBufferTex[i] = this.mByteBufferTex[i].asFloatBuffer();
            }
            this.mBufferTex[i].clear();
            this.mBufferTex[i].put(fArray2);
            this.mBufferTex[i].flip();
            GLES20.glVertexAttribPointer((int)this.texCoordHandles[i], (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mBufferTex[i]);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandles[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void passShaderValues(float[][] triArray, int[] textures) {
        if (triArray != null && triArray.length > 0) {
            void var1_1;
            this.initCoord((float[][])var1_1);
        }
        int n = 0;
        for (int i = 0; i < textures.length; ++i) {
            switch (i) {
                case 0: {
                    n = 33985;
                    break;
                }
                case 1: {
                    n = 33986;
                    break;
                }
                case 2: {
                    n = 33987;
                    break;
                }
                case 3: {
                    n = 33988;
                    break;
                }
                case 4: {
                    n = 33989;
                    break;
                }
                case 5: {
                    n = 33990;
                    break;
                }
                case 6: {
                    n = 33991;
                    break;
                }
                case 7: {
                    n = 33992;
                    break;
                }
                case 8: {
                    n = 33993;
                }
            }
            GLES20.glActiveTexture((int)n);
            GLES20.glBindTexture((int)3553, (int)textures[i]);
            GLES20.glUniform1i((int)this.textureHandles[i], (int)(i + 1));
        }
    }

    protected void disableDrawArray() {
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        for (int i = 0; i < this.texCoordHandles.length; ++i) {
            GLES20.glDisableVertexAttribArray((int)this.texCoordHandles[i]);
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }
}

