/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.ThirdPartEffect.Pott.program.programgroup;

import android.graphics.PointF;
import android.opengl.GLES20;
import com.cosmos.mdlog.MDLog;
import com.immomo.baseutil.ContextHolder;
import com.mm.mmutil.app.AppContext;
import com.momo.mcamera.ThirdPartEffect.Pott.attrInfo.LottieMMFrameGeomeAttrInfo;
import com.momo.mcamera.ThirdPartEffect.Pott.attrInfo.MMFrameGeomeAttrInfo;
import com.momo.mcamera.ThirdPartEffect.Pott.attrInfo.StickerItemGeomeAttrInfo;
import com.momo.mcamera.ThirdPartEffect.Pott.attrInfo.TextureLottieGeomeAttrInfo;
import com.momo.mcamera.ThirdPartEffect.Pott.config.lottecfg.AssetValue;
import com.momo.mcamera.ThirdPartEffect.Pott.config.lottecfg.Layers;
import com.momo.mcamera.ThirdPartEffect.Pott.config.lottecfg.LottieConfig;
import com.momo.mcamera.ThirdPartEffect.Pott.program.programgroup.EsTemplateProgramGroup;
import com.momo.mcamera.ThirdPartEffect.Pott.program.programgroup.RenderRunner;
import com.momo.mcamera.mask.MaskModel;
import com.momo.mcamera.mask.MaskStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import project.android.imageprocessing.GLFrameBuffer;

public class PottMVMapProgramGroup
extends EsTemplateProgramGroup {
    TextureLottieGeomeAttrInfo nomralForCountry;
    MMFrameGeomeAttrInfo countryGInfo;
    List<LottieMMFrameGeomeAttrInfo> flagsInfo = new ArrayList<LottieMMFrameGeomeAttrInfo>();
    int mapWidth = 1124;
    int mapHeight = 743;
    String mapType = "world";
    List<PointF> travelList;
    GLFrameBuffer mapBuffer;

    /*
     * WARNING - void declaration
     */
    public PottMVMapProgramGroup(String folderPath) {
        super((String)var1_1);
        void var1_1;
    }

    public PottMVMapProgramGroup() {
        super("tailer/map/");
    }

    /*
     * WARNING - void declaration
     */
    public void setTravelList(List<PointF> travelList) {
        void var1_1;
        this.travelList = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMapType(String mapType) {
        void var1_1;
        this.mapType = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onParseLayers(LottieConfig lottieConfig, Layers curLayer, AssetValue assetValue) {
        Object object = curLayer.getLayerName();
        if (((String)object).equalsIgnoreCase("flags")) {
            object = this.baseFolder + "/" + assetValue.getFolderPath() + "/";
            object = (String)object + assetValue.getSourceName();
            Random random = new Random();
            if (this.travelList == null) {
                MDLog.w((String)"FilterProcess", (String)"Do not set Location list !");
                return true;
            }
            Iterator<PointF> iterator = this.travelList.iterator();
            while (iterator.hasNext()) {
                PointF pointF = iterator.next();
                int n = assetValue.getFrameCount();
                Object object2 = object;
                if (n > 0) {
                    object2 = (String)object + String.format("_%03d", random.nextInt(n)) + ".png";
                }
                LottieMMFrameGeomeAttrInfo lottieMMFrameGeomeAttrInfo = new LottieMMFrameGeomeAttrInfo((String)object2);
                lottieMMFrameGeomeAttrInfo.setAlphaValue(0.0f);
                lottieMMFrameGeomeAttrInfo.setLottieConfig(curLayer);
                float f = pointF.x * 2.0f - 1.0f;
                float f2 = pointF.y * 2.0f - 1.0f;
                lottieMMFrameGeomeAttrInfo.setTraslate(f, f2);
                this.flagsInfo.add(lottieMMFrameGeomeAttrInfo);
            }
            return true;
        }
        if (((String)object).equalsIgnoreCase("map")) {
            object = this.mapType.equalsIgnoreCase("world") ? this.baseFolder + "/" + assetValue.getFolderPath() + "/" + assetValue.getSourceName() + "_world.png" : this.baseFolder + "/" + assetValue.getFolderPath() + "/" + assetValue.getSourceName() + "_china.png";
            this.countryGInfo = new MMFrameGeomeAttrInfo((String)object);
            this.nomralForCountry = new TextureLottieGeomeAttrInfo();
            this.nomralForCountry.setLottieConfig(curLayer);
            this.mapWidth = assetValue.getWidth();
            this.mapHeight = assetValue.getHeight();
            PottMVMapProgramGroup pottMVMapProgramGroup = this;
            pottMVMapProgramGroup.addRunerTask(pottMVMapProgramGroup.normal, this.nomralForCountry);
            return true;
        }
        if (!((String)object).equalsIgnoreCase("maptextsticker")) {
            void var2_2;
            void var3_3;
            object = this.baseFolder + "/" + assetValue.getFolderPath() + "/" + var3_3.getSourceName();
            object = new LottieMMFrameGeomeAttrInfo((String)object);
            ((LottieMMFrameGeomeAttrInfo)object).setLottieConfig((Layers)var2_2);
            PottMVMapProgramGroup pottMVMapProgramGroup = this;
            pottMVMapProgramGroup.addRunerTask(pottMVMapProgramGroup.normal, (MMFrameGeomeAttrInfo)object);
            return true;
        }
        object = this.baseFolder + "/" + assetValue.getFolderPath();
        object = MaskStore.getInstance().getMask(AppContext.getContext(), (String)object);
        if (object != null && ((MaskModel)object).getStickers() != null && ((MaskModel)object).getStickers().size() > 0) {
            StickerItemGeomeAttrInfo stickerItemGeomeAttrInfo = new StickerItemGeomeAttrInfo(((MaskModel)object).getStickers().get(0), ContextHolder.sContext);
            PottMVMapProgramGroup pottMVMapProgramGroup = this;
            pottMVMapProgramGroup.addRunerTask(pottMVMapProgramGroup.normal, stickerItemGeomeAttrInfo);
            return true;
        }
        MDLog.e((String)"FilterProcess", (String)"Parse config error !! the param.txt of cover sticker is wrong !!");
        this.recycleAllData();
        return false;
    }

    @Override
    public synchronized void drawGroup() {
        if (this.nomralForCountry == null || this.countryGInfo == null) {
            MDLog.e((String)"FilterProcess", (String)"Parse Config error !! do not render ");
            return;
        }
        if (this.mapBuffer == null) {
            this.mapBuffer = new GLFrameBuffer(this.mapWidth, this.mapHeight);
            this.mapBuffer.activityFrameBuffer(this.mapWidth, this.mapHeight);
            this.nomralForCountry.updateInputeTexture(new int[]{this.mapBuffer.getTexture_out()[0]});
        }
        this.nomralForCountry.setTimeStamp(this.curTimeStamp);
        this.nomralForCountry.updateBitmapInfo(this.mapWidth, this.mapHeight);
        if (this.nomralForCountry.getFrameTexture() != null && this.nomralForCountry.getAlphaValue() > 0.0f) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[4];
            GLES20.glGetIntegerv((int)36006, (int[])nArray, (int)0);
            GLES20.glGetIntegerv((int)2978, (int[])nArray2, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)this.mapBuffer.getFrameBuffer()[0]);
            GLES20.glViewport((int)0, (int)0, (int)this.mapWidth, (int)this.mapHeight);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16640);
            this.countryGInfo.setBaseRenderSize(this.mapWidth, this.mapHeight);
            this.countryGInfo.setRotate(180.0f, 0.0f, 0.0f);
            RenderRunner.drawTexture(this.normal, this.countryGInfo);
            for (MMFrameGeomeAttrInfo mMFrameGeomeAttrInfo : this.flagsInfo) {
                mMFrameGeomeAttrInfo.setTimeStamp(this.curTimeStamp);
                mMFrameGeomeAttrInfo.setBaseRenderSize(this.mapWidth, this.mapHeight);
                mMFrameGeomeAttrInfo.setRotate(180.0f, 0.0f, 0.0f);
                RenderRunner.drawTexture(this.normal, mMFrameGeomeAttrInfo);
            }
            GLES20.glBindFramebuffer((int)36160, (int)nArray[0]);
            GLES20.glViewport((int)nArray2[0], (int)nArray2[1], (int)nArray2[2], (int)nArray2[3]);
        }
        super.drawGroup();
    }

    @Override
    public void recycleAllData() {
        super.recycleAllData();
        if (this.nomralForCountry != null) {
            this.nomralForCountry.recycleResourceInGlThread();
            this.nomralForCountry = null;
        }
        if (this.countryGInfo != null) {
            this.countryGInfo.recycleResourceInGlThread();
            this.countryGInfo = null;
        }
        Iterator<LottieMMFrameGeomeAttrInfo> iterator = this.flagsInfo.iterator();
        while (iterator.hasNext()) {
            iterator.next().recycleResourceInGlThread();
        }
        this.flagsInfo.clear();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.travelList != null) {
            this.travelList = null;
        }
    }

    @Override
    public synchronized void resetStatus() {
        super.resetStatus();
        if (this.nomralForCountry != null) {
            this.nomralForCountry.resetStatus();
        }
        if (this.countryGInfo != null) {
            this.countryGInfo.resetStatus();
        }
        for (LottieMMFrameGeomeAttrInfo lottieMMFrameGeomeAttrInfo : this.flagsInfo) {
            lottieMMFrameGeomeAttrInfo.resetStatus();
            lottieMMFrameGeomeAttrInfo.setAlphaValue(0.0f);
        }
    }
}

