/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.ThirdPartEffect.Pott.program.programgroup;

import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.ThirdPartEffect.Pott.attrInfo.MMFrameGeomeAttrInfo;
import com.momo.mcamera.ThirdPartEffect.Pott.config.ProgramGroupRenderInterface;
import com.momo.mcamera.ThirdPartEffect.Pott.config.lottecfg.AssetValue;
import com.momo.mcamera.ThirdPartEffect.Pott.config.lottecfg.Layers;
import com.momo.mcamera.ThirdPartEffect.Pott.config.lottecfg.LottieConfig;
import com.momo.mcamera.ThirdPartEffect.Pott.program.esprogram.MMFramRenderProgram;
import com.momo.mcamera.ThirdPartEffect.Pott.program.programgroup.RenderRunner;
import com.momo.mcamera.util.JsonConfigParseHelpler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import project.android.imageprocessing.filter.program.BitmapRenderProgram;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.inter.ProcessErrorListener;

public abstract class EsTemplateProgramGroup
implements ProgramGroupRenderInterface,
IVideoTrackTime {
    List<RenderRunner> renderRunners = new ArrayList<RenderRunner>();
    ProcessErrorListener errorListener;
    private static final int ErrorCode = -1;
    long curTimeStamp = 0L;
    long firstRenderTime = -1L;
    public long templateTotalTimeInMs = 50000L;
    public long templateTailerTimeInMs = 60000L;
    int renderWidth;
    int renderHeight;
    boolean initialized = false;
    public static final int RENDERING_READY = 0;
    public static final int RENDER_RUNNING = 1;
    public static final int RENDER_TAIL = 2;
    public static final int RENDER_END = 3;
    int rendingStatus = 0;
    LottieConfig lottieConfig = null;
    String templateFolder = "";
    MMFramRenderProgram normal;
    protected String baseFolder = "";

    /*
     * WARNING - void declaration
     */
    public EsTemplateProgramGroup(String folderPath) {
        void var1_1;
        this.templateFolder = var1_1;
    }

    public boolean initAllInfo() {
        if (!this.initProgram()) {
            MDLog.e((String)"FilterProcess", (String)"Init all program error !!");
            if (this.errorListener != null) {
                this.errorListener.onProcessingError(-1, "\u521b\u5efa\u672c\u5730\u7684\u6e32\u67d3program\u5931\u8d25");
            }
            return false;
        }
        if (!this.parseConfig()) {
            MDLog.e((String)"FilterProcess", (String)"Parse config  error !!");
            if (this.errorListener != null) {
                this.errorListener.onProcessingError(-1, "\u89e3\u6790\u914d\u7f6e\u811a\u672c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u672c\u5730\u7d20\u6750\u6587\u4ef6\u662f\u5426\u5b8c\u6574\u6216\u8005\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01");
            }
            return false;
        }
        return true;
    }

    @Override
    public void updateRenderSize(int width, int height) {
        this.renderWidth = width;
        this.renderHeight = height;
        for (int i = this.renderRunners.size() - 1; i >= 0; --i) {
            this.renderRunners.get(i).updateRnederSize(width, height);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addRunerTask(BitmapRenderProgram program, MMFrameGeomeAttrInfo info) {
        RenderRunner renderRunner;
        void var2_2;
        renderRunner = new RenderRunner((MMFrameGeomeAttrInfo)var2_2, (BitmapRenderProgram)renderRunner);
        this.renderRunners.add(renderRunner);
    }

    @Override
    public synchronized void drawGroup() {
        if (!this.initialized) {
            MDLog.w((String)"FilterProcess", (String)"Current render group is not initilaized !! Error !!");
            return;
        }
        if (this.firstRenderTime < 0L) {
            this.firstRenderTime = this.curTimeStamp;
        }
        EsTemplateProgramGroup esTemplateProgramGroup = this;
        esTemplateProgramGroup.updateRunningStatus(esTemplateProgramGroup.curTimeStamp - this.firstRenderTime);
        if (this.rendingStatus == 3) {
            return;
        }
        for (int i = this.renderRunners.size() - 1; i >= 0; --i) {
            this.renderRunners.get(i).renderRunning(this.curTimeStamp);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateRunningStatus(long passedTime) {
        void var1_1;
        if (passedTime >= 0L && passedTime <= this.templateTailerTimeInMs) {
            this.rendingStatus = 1;
            return;
        }
        if (passedTime > this.templateTailerTimeInMs && passedTime <= this.templateTotalTimeInMs) {
            this.rendingStatus = 2;
            return;
        }
        if (var1_1 > this.templateTotalTimeInMs) {
            this.rendingStatus = 3;
            return;
        }
    }

    public int getRendingStatus() {
        return this.rendingStatus;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setTimeStamp(long ms) {
        void var1_1;
        this.curTimeStamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTemplateTotalTimeInMs(long templateTotalTimeInMs) {
        void var1_1;
        this.templateTotalTimeInMs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTemplateTailerTimeInMs(long templateTailerTimeInMs) {
        void var1_1;
        this.templateTailerTimeInMs = var1_1;
    }

    public void recycleAllData() {
    }

    public void destroy() {
        this.recycleAllData();
        if (this.normal != null) {
            this.normal.destroy();
            this.normal = null;
        }
        this.rendingStatus = 0;
        Iterator<RenderRunner> iterator = this.renderRunners.iterator();
        while (iterator.hasNext()) {
            iterator.next().recycleData();
        }
        this.renderRunners.clear();
        this.baseFolder = null;
        this.templateFolder = null;
        this.errorListener = null;
    }

    public void recycleImageBuffers() {
        Iterator<RenderRunner> iterator = this.renderRunners.iterator();
        while (iterator.hasNext()) {
            iterator.next().info.recycleImageBuffers();
        }
    }

    public long getFadeOutDurationInMs() {
        return this.templateTotalTimeInMs - this.templateTailerTimeInMs;
    }

    /*
     * WARNING - void declaration
     */
    public void setBaseFolder(String baseFolder) {
        void var1_1;
        this.baseFolder = var1_1;
    }

    protected boolean parseConfig() {
        if (this.baseFolder != null && !this.initialized) {
            Object object = this.baseFolder + "/config.json";
            this.lottieConfig = JsonConfigParseHelpler.a((String)object);
            if (this.lottieConfig == null || this.lottieConfig.getAssetValues() == null || this.lottieConfig.getLayers() == null) {
                MDLog.e((String)"FilterProcess", (String)"Parse config error !");
                this.recycleAllData();
                return false;
            }
            object = new HashMap();
            for (AssetValue object2 : this.lottieConfig.getAssetValues()) {
                object.put(object2.getImageId(), object2);
            }
            for (Layers layers : this.lottieConfig.getLayers()) {
                layers.getLayerName();
                AssetValue assetValue = (AssetValue)object.get(layers.getRefImageId());
                EsTemplateProgramGroup esTemplateProgramGroup = this;
                if (esTemplateProgramGroup.onParseLayers(esTemplateProgramGroup.lottieConfig, layers, assetValue)) continue;
                MDLog.e((String)"FilterProcess", (String)"Parse lottie layers failed !! return !");
                this.recycleAllData();
                return false;
            }
        } else {
            return this.initialized;
        }
        this.initialized = true;
        return this.initialized;
    }

    protected abstract boolean onParseLayers(LottieConfig var1, Layers var2, AssetValue var3);

    protected boolean initProgram() {
        this.normal = new MMFramRenderProgram();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorListener(ProcessErrorListener errorListener) {
        void var1_1;
        this.errorListener = var1_1;
    }

    public synchronized void resetStatus() {
        this.rendingStatus = 0;
        this.curTimeStamp = 0L;
        this.firstRenderTime = -1L;
        Iterator<RenderRunner> iterator = this.renderRunners.iterator();
        while (iterator.hasNext()) {
            iterator.next().info.resetStatus();
        }
    }
}

