/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.ThirdPartEffect.Pott.attrInfo;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.ThirdPartEffect.Pott.attrInfo.LottieMMFrameGeomeAttrInfo;
import com.momo.mcamera.ThirdPartEffect.Pott.config.lottecfg.Layers;

public class LottieBitmapGeomeAttrInfo
extends LottieMMFrameGeomeAttrInfo {
    Bitmap bitmap;
    String bitmapPath;
    boolean bitmapFromeOutter = false;
    int maxWidth = 1080;
    int maxHeight = 1920;

    /*
     * WARNING - void declaration
     */
    public LottieBitmapGeomeAttrInfo(String path) {
        super(null);
        void var1_1;
        this.bitmapPath = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLottieConfig(Layers layer) {
        void var1_1;
        super.setLottieConfig((Layers)var1_1);
        if (this.bitmapPath != null) {
            this.decodeOneImage();
        }
    }

    private void decodeOneImage() {
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)this.bitmapPath, (BitmapFactory.Options)options);
        int n = options.outWidth;
        int n2 = options.outHeight;
        this.bitmap = BitmapFactory.decodeFile((String)this.bitmapPath);
        int n3 = 1;
        int n4 = this.maxWidth;
        int n5 = this.maxHeight;
        if (this.targetWidth != 0 && this.targetHeight != 0) {
            n4 = this.targetWidth;
            n5 = this.targetHeight;
        }
        if (n2 > n4 || n2 > n5) {
            n3 = n > n4 ? Math.round(n / n4) : Math.round(n2 / n5);
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = n3;
        n = ImageUtils.getBitmapDegree((String)this.bitmapPath);
        this.bitmap = BitmapFactory.decodeFile((String)this.bitmapPath, (BitmapFactory.Options)options);
        if (this.bitmap != null && n != 0) {
            options = new Matrix();
            options.postRotate((float)n);
            this.bitmap = Bitmap.createBitmap((Bitmap)this.bitmap, (int)0, (int)0, (int)this.bitmap.getWidth(), (int)this.bitmap.getHeight(), (Matrix)options, (boolean)true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setBitmap(Bitmap bitmap) {
        void var1_1;
        this.bitmapFromeOutter = true;
        this.bitmap = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setBitmapWithTarget(Bitmap bitmap, int targetW, int targetH) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.bitmap = var1_1;
        this.targetWidth = var2_2;
        this.targetHeight = var3_3;
        this.bitmapFromeOutter = true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateBitmapInfo(int width, int height) {
        if (this.targetWidth == 0 || this.targetHeight == 0) {
            float f = (float)this.baseRenderWidth / (float)this.baseRenderHeight;
            float f2 = (float)width / (float)height;
            if (f > f2) {
                this.bitmapWidth = (int)((float)this.baseRenderHeight * f2);
                this.bitmapHeight = this.baseRenderHeight;
            } else {
                this.bitmapWidth = this.baseRenderWidth;
                this.bitmapHeight = (int)((float)this.baseRenderHeight / f2);
            }
            LottieBitmapGeomeAttrInfo lottieBitmapGeomeAttrInfo = this;
            super.updateBitmapInfo(lottieBitmapGeomeAttrInfo.bitmapWidth, this.bitmapHeight);
            return;
        }
        float f = (float)this.targetWidth / (float)this.targetHeight;
        float f3 = (float)width / (float)height;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (f > f3) {
            f3 = (float)width / f;
            f4 = ((float)height - f3) / (float)height / 2.0f;
        } else {
            void var1_1;
            void var2_2;
            f3 = (float)var2_2 * f;
            f5 = ((float)width - f3) / (float)var1_1 / 2.0f;
        }
        if (f5 != 1.0f && f4 != 1.0f) {
            this.cropWidthAndHeightInNormalTextureCoord(f5, f4);
        }
        LottieBitmapGeomeAttrInfo lottieBitmapGeomeAttrInfo = this;
        super.updateBitmapInfo(lottieBitmapGeomeAttrInfo.targetWidth, this.targetHeight);
    }

    @Override
    public int[] getFrameTexture() {
        if (this.bitmap == null && !this.bitmapFromeOutter) {
            this.decodeOneImage();
        }
        LottieBitmapGeomeAttrInfo lottieBitmapGeomeAttrInfo = this;
        lottieBitmapGeomeAttrInfo.updateBitmapInfo(lottieBitmapGeomeAttrInfo.bitmap.getWidth(), this.bitmap.getHeight());
        if (this.frameTexture == 0) {
            this.frameTexture = TextureHelper.bitmapToTexture((Bitmap)this.bitmap);
        }
        super.getFrameTexture();
        if (this.getAlphaValue() < 0.0f || this.frameTexture == 0) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = this.frameTexture;
        return nArray2;
    }

    @Override
    public void recycleResourceInGlThread() {
        super.recycleResourceInGlThread();
        if (this.bitmap != null) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
        this.bitmapPath = null;
    }

    @Override
    public void recycleImageBuffers() {
        super.recycleImageBuffers();
        if (!this.bitmapFromeOutter && this.bitmap != null) {
            this.bitmap.recycle();
            this.bitmap = null;
            MDLog.e((String)"FilterProcess", (String)"Recycle bitmap lottie info !");
        }
    }
}

