/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.opengl.GLES20;
import android.text.TextUtils;
import android.view.Display;
import com.core.glcore.config.Size;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.core.glcore.util.FacerigHelper;
import com.core.glcore.util.SegmentHelper;
import com.core.glcore.util.XEEngineHelper;
import com.core.glcore.util.XEFaceInfoHelper;
import com.cosmos.mdlog.MDLog;
import com.mm.mmutil.task.ThreadUtils;
import com.momo.mcamera.mask.AdditionalInfo;
import com.momo.mcamera.mask.Capture3DImageListener;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.util.ArCoreHelper;
import com.momo.xeengine.cv.bean.CVSegmentInfo;
import com.momo.xeengine.xnative.XEARCore;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class Face3DMaskFilter
extends FaceDetectFilter {
    private String rendertaskName;
    private String sceneId;
    private Sticker sticker;
    MMCVInfo mmcvInfo;
    private boolean inited = false;
    private boolean needFaceDetect = true;
    private int antialias = 1;
    private int frameCounter = 0;
    private boolean isCameraFront = false;
    private static boolean forbiddenRender = false;
    private WeakReference<Context> mContext = null;
    static boolean autoRender = false;
    private boolean isCapture = false;
    private boolean isDrawBackGround = true;
    private Capture3DImageListener mCapture3DImageListener = null;
    private Rect mCaptureRect = null;
    private Display mDisplay;
    private int w;
    private int h;
    private AdditionalInfo mAdditionalInfo = null;
    MMFrameInfo mmcvFrame = new MMFrameInfo();
    MMParamsInfo params = new MMParamsInfo(4);

    public static void SetAutoRender(boolean enable) {
        autoRender = enable;
    }

    /*
     * WARNING - void declaration
     */
    public Face3DMaskFilter(Sticker sticker, boolean isCameraFront, Context context) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.isCameraFront = var2_2;
        this.mContext = new WeakReference<void>(var3_3);
        this.sticker = sticker;
        this.loadScene((Sticker)var1_1);
        this.rendertaskName = ((Object)((Object)this)).toString();
    }

    /*
     * WARNING - void declaration
     */
    public void setCamera(boolean isFront) {
        if (this.isCameraFront != isFront) {
            void var1_1;
            this.isCameraFront = var1_1;
            this.frameCounter = 0;
        }
    }

    public boolean needFaceDetect() {
        return this.needFaceDetect || FacerigHelper.isUseFacerig();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (this.needFaceDetect()) {
            void var1_1;
            this.mmcvInfo = var1_1;
            XEFaceInfoHelper.setFaceInfo((MMCVInfo)this.mmcvInfo);
        }
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }

    public void destroy() {
        super.destroy();
        if (ArCoreHelper.a().d) {
            ArCoreHelper.a().c();
        }
        if (!TextUtils.isEmpty((CharSequence)this.sceneId)) {
            XEEngineHelper.unloadScene((String)this.sceneId);
            this.sceneId = null;
        }
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        this.inited = false;
        this.isCameraFront = false;
        this.mmcvInfo = null;
        this.antialias = 1;
        this.frameCounter = 0;
        if (ArCoreHelper.a().d) {
            ArCoreHelper.a().c();
        }
        this.loadScene(this.sticker);
    }

    public void resetArInfo() {
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.setWidth(source.getWidth());
        this.setHeight(var2_2.getHeight());
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)this, (boolean)var3_3);
    }

    protected void initFBO() {
        if (this.glFrameBuffer != null) {
            this.glFrameBuffer.destoryBuffer();
        }
        this.glFrameBuffer = new GLFrameBuffer(this.getWidth() * this.antialias, this.getHeight() * this.antialias);
        this.glFrameBuffer.activityFrameBuffer(this.getWidth() * this.antialias, this.getHeight() * this.antialias);
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException((Object)((Object)this) + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
    }

    public static boolean is3DRenderReady() {
        return true;
    }

    protected void drawBgFrame() {
        GLES20.glViewport((int)0, (int)0, (int)(this.width * this.antialias), (int)(this.height * this.antialias));
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.programHandle);
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.texCoordHandle);
    }

    public void drawSub() {
        this.isDrawBackGround = !this.isCapture;
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GLES20.glEnable((int)3089);
        GLES20.glFinish();
        long l = System.currentTimeMillis();
        int n = this.getWidth() * this.antialias;
        int n2 = this.getHeight() * this.antialias;
        if (!this.inited) {
            this.inited = true;
            XEEngineHelper.runEngine((int)n, (int)n2);
            if (!autoRender) {
                XEEngineHelper.loadScene((String)this.sticker.getXengineResRelativePath(), (String)this.sceneId);
            }
        }
        if (ArCoreHelper.a().a != null && ArCoreHelper.a().b != null) {
            ArCoreHelper.a();
            ArCoreHelper.b();
        }
        if (this.isDrawBackGround) {
            this.drawBgFrame();
        }
        if (autoRender) {
            XEEngineHelper.render((int)n, (int)n2);
        } else {
            XEEngineHelper.render((int)n, (int)n2, (String)this.sceneId);
        }
        GLES20.glDisable((int)2884);
        GLES20.glDisable((int)3089);
        if (this.isCapture && !this.isDrawBackGround) {
            this.get3DRenderImage();
        }
        MDLog.v((String)"FaceRig", (String)("draw : " + (System.currentTimeMillis() - l)));
        if (this.mAdditionalInfo != null && this.mAdditionalInfo.isBodySegmentDetectEnable()) {
            this.processSegment();
        }
    }

    private void drawEngineFrame() {
        GLES20.glViewport((int)0, (int)0, (int)(this.width * this.antialias), (int)(this.height * this.antialias));
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.programHandle);
        this.passEngineFrameValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.texCoordHandle);
    }

    private void passEngineFrameValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        if (this.mAdditionalInfo != null && this.mAdditionalInfo.isBodySegmentDetectEnable()) {
            this.processSegment();
        }
    }

    void loadScene(Sticker sticker) {
        ArCoreHelper arCoreHelper;
        int n = this.antialias = sticker.isEnable3DAntialiasing() ? 2 : 1;
        if (this.sceneId == null) {
            this.sceneId = ((Sticker)((Object)arCoreHelper)).getXengineResRelativePath() + "_" + System.currentTimeMillis();
        }
        if (ArCoreHelper.a().d) {
            arCoreHelper = ArCoreHelper.a();
            ArCoreHelper.a().c = new XEARCore.IARCoreListener(arCoreHelper){
                final /* synthetic */ ArCoreHelper a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Map<Double, float[]> onHitPose(float x, float y) {
                    void var2_2;
                    void var1_1;
                    return ArCoreHelper.a().a((float)var1_1, (float)var2_2);
                }
            };
            XEEngineHelper.get().getARCore().addListener(arCoreHelper.c);
            XEEngineHelper.queueEvent((Runnable)new Runnable(arCoreHelper){
                final /* synthetic */ ArCoreHelper a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                @Override
                public void run() {
                    XEEngineHelper.get().getARCore().setARHitTestListener();
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCapture(boolean isCapture, Rect rect) {
        void var2_2;
        void var1_1;
        this.isCapture = var1_1;
        this.mCaptureRect = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setCapture3DImageListener(Capture3DImageListener capture3DImageListener) {
        void var1_1;
        this.mCapture3DImageListener = var1_1;
    }

    private void get3DRenderImage() {
        ByteBuffer byteBuffer;
        if (this.mCaptureRect != null) {
            this.w = this.mCaptureRect.right - this.mCaptureRect.left;
            this.h = this.mCaptureRect.bottom - this.mCaptureRect.top;
            int n = this.mCaptureRect.left;
            int n2 = this.height - this.mCaptureRect.top - this.h;
            byteBuffer = ByteBuffer.allocate(this.w * this.h << 2);
            byteBuffer.position(0);
            GLES20.glReadPixels((int)n, (int)n2, (int)this.w, (int)this.h, (int)6408, (int)5121, (Buffer)byteBuffer);
        } else {
            byteBuffer = ByteBuffer.allocate(this.getWidth() * this.getHeight() << 2);
            byteBuffer.position(0);
            GLES20.glReadPixels((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)6408, (int)5121, (Buffer)byteBuffer);
        }
        byteBuffer.position(0);
        this.isCapture = false;
        ThreadUtils.execute((int)2, (Runnable)new Runnable(this, byteBuffer){
            final /* synthetic */ ByteBuffer val$PixelBuffer;
            final /* synthetic */ Face3DMaskFilter this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$PixelBuffer = byteBuffer;
            }

            @Override
            public void run() {
                Bitmap bitmap = this.this$0.mCaptureRect != null ? Bitmap.createBitmap((int)this.this$0.w, (int)this.this$0.h, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)this.this$0.width, (int)this.this$0.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.copyPixelsFromBuffer((Buffer)this.val$PixelBuffer);
                if (this.this$0.mCapture3DImageListener != null) {
                    Matrix matrix = new Matrix();
                    matrix.postScale(1.0f, -1.0f);
                    matrix.postRotate(0.0f);
                    bitmap = this.this$0.mCaptureRect != null ? Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)this.this$0.w, (int)this.this$0.h, (Matrix)matrix, (boolean)true) : Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)this.this$0.width, (int)this.this$0.height, (Matrix)matrix, (boolean)true);
                    this.this$0.mCapture3DImageListener.get3DRenderImage(bitmap);
                }
            }
        });
    }

    public Size getViewPortSize() {
        return new Size(this.getWidth() * this.antialias, this.getHeight() * this.antialias);
    }

    public Bitmap flushPicture(int degress) {
        IntBuffer intBuffer = IntBuffer.allocate(1);
        GLES20.glReadPixels((int)0, (int)0, (int)1, (int)1, (int)6408, (int)5121, (Buffer)intBuffer);
        return null;
    }

    private void processSegment() {
        if (this.mmcvInfo == null || this.mmcvInfo.frameData == null) {
            MDLog.e((String)"lclc", (String)"mmcv is null or mmcv.frameInfo is null");
            return;
        }
        this.mmcvFrame.setFormat(17);
        this.mmcvFrame.setDataPtr(this.mmcvInfo.frameData);
        this.mmcvFrame.setDataLen(this.mmcvInfo.frameData.length);
        this.mmcvFrame.setWidth(this.mmcvInfo.getWidth());
        this.mmcvFrame.setHeight(this.mmcvInfo.getHeight());
        this.mmcvFrame.setStep_(this.mmcvInfo.getWidth());
        this.params.setFlipedShow(SegmentHelper.isFrontCamera());
        this.params.setRotateDegree(SegmentHelper.getRotateDegree());
        this.params.setRestoreDegree(SegmentHelper.getRestoreDegree());
        byte[] byArray = SegmentHelper.process((MMFrameInfo)this.mmcvFrame, (MMParamsInfo)this.params);
        CVSegmentInfo cVSegmentInfo = new CVSegmentInfo();
        cVSegmentInfo.setDatas(byArray);
        cVSegmentInfo.setHeight(this.mmcvFrame.getWidth());
        cVSegmentInfo.setWidth(this.mmcvFrame.getHeight());
        cVSegmentInfo.setLength(byArray.length);
        XEEngineHelper.setSegmentInfo((CVSegmentInfo)cVSegmentInfo);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdditionalInfo(AdditionalInfo additionalInfo) {
        void var1_1;
        this.mAdditionalInfo = var1_1;
    }
}

