/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util.fft;

import com.momo.mcamera.util.fft.FourierTransform;

public class FFT
extends FourierTransform {
    public static final int ACCURACY_LOWEST = 256;
    public static final int ACCURACY_LOW = 512;
    public static final int ACCURACY_MIDEUM = 1024;
    public static final int ACCURACY_HIGH = 2048;
    public static final int ACCURACY_HIGHEST = 4096;
    private int[] reverse;
    private float[] sinlookup;
    private float[] coslookup;

    /*
     * WARNING - void declaration
     */
    public FFT(int timeSize, float sampleRate) {
        super(timeSize, (float)var2_2);
        void var1_1;
        void var2_2;
        if ((timeSize & var1_1 - true) != 0) {
            throw new IllegalArgumentException("FFT: timeSize must be a power of two.");
        }
        this.buildReverseTable();
        this.buildTrigTables();
    }

    @Override
    protected void allocateArrays() {
        this.spectrum = new float[this.timeSize / 2 + 1];
        this.real = new float[this.timeSize];
        this.imag = new float[this.timeSize];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void scaleBand(int i, float s) {
        void var2_2;
        if (s < 0.0f) {
            return;
        }
        int n = i;
        this.real[n] = this.real[n] * s;
        int n2 = i;
        this.imag[n2] = this.imag[n2] * s;
        int n3 = i;
        this.spectrum[n3] = this.spectrum[n3] * var2_2;
        if (i != 0 && i != this.timeSize / 2) {
            void var1_1;
            this.real[this.timeSize - i] = this.real[i];
            this.imag[this.timeSize - i] = -this.imag[var1_1];
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBand(int i, float a2) {
        if (a2 < 0.0f) {
            return;
        }
        if (this.real[i] == 0.0f && this.imag[i] == 0.0f) {
            this.real[i] = a2;
            this.spectrum[i] = a2;
        } else {
            void var2_2;
            int n = i;
            this.real[n] = this.real[n] / this.spectrum[i];
            int n2 = i;
            this.imag[n2] = this.imag[n2] / this.spectrum[i];
            this.spectrum[i] = var2_2;
            int n3 = i;
            this.real[n3] = this.real[n3] * this.spectrum[i];
            int n4 = i;
            this.imag[n4] = this.imag[n4] * this.spectrum[i];
        }
        if (i != 0 && i != this.timeSize / 2) {
            void var1_1;
            this.real[this.timeSize - i] = this.real[i];
            this.imag[this.timeSize - i] = -this.imag[var1_1];
        }
    }

    private void fft() {
        for (int i = 1; i < this.real.length; i <<= 1) {
            float f = this.cos(i);
            float f2 = this.sin(i);
            float f3 = 1.0f;
            float f4 = 0.0f;
            for (int j = 0; j < i; ++j) {
                for (int k = j; k < this.real.length; k += 2 * i) {
                    int n = k + i;
                    float f5 = f3 * this.real[n] - f4 * this.imag[n];
                    float f6 = f3 * this.imag[n] + f4 * this.real[n];
                    this.real[n] = this.real[k] - f5;
                    this.imag[n] = this.imag[k] - f6;
                    int n2 = k;
                    this.real[n2] = this.real[n2] + f5;
                    int n3 = k;
                    this.imag[n3] = this.imag[n3] + f6;
                }
                float f7 = f3;
                f3 = f7 * f - f4 * f2;
                f4 = f7 * f2 + f4 * f;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forward(float[] buffer) {
        void var1_1;
        if (buffer.length != this.timeSize) {
            return;
        }
        this.bitReverseSamples((float[])var1_1, 0);
        this.fft();
        this.fillSpectrum();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forward(float[] buffer, int startAt) {
        void var2_2;
        void var1_1;
        if (buffer.length - startAt < this.timeSize) {
            return;
        }
        this.bitReverseSamples((float[])var1_1, (int)var2_2);
        this.fft();
        this.fillSpectrum();
    }

    /*
     * WARNING - void declaration
     */
    public void forward(float[] buffReal, float[] buffImag) {
        void var2_2;
        void var1_1;
        if (buffReal.length != this.timeSize || buffImag.length != this.timeSize) {
            return;
        }
        this.setComplex((float[])var1_1, (float[])var2_2);
        this.bitReverseComplex();
        this.fft();
        this.fillSpectrum();
    }

    @Override
    public void inverse(float[] buffer) {
        if (buffer.length > this.real.length) {
            return;
        }
        int n = 0;
        while (n < this.timeSize) {
            int n2 = n++;
            this.imag[n2] = -this.imag[n2];
        }
        this.bitReverseComplex();
        this.fft();
        for (n = 0; n < buffer.length; ++n) {
            buffer[n] = this.real[n] / (float)this.real.length;
        }
    }

    private void buildReverseTable() {
        int n = this.timeSize;
        this.reverse = new int[n];
        this.reverse[0] = 0;
        int n2 = 1;
        int n3 = n / 2;
        while (n2 < n) {
            for (int i = 0; i < n2; ++i) {
                this.reverse[i + n2] = this.reverse[i] + n3;
            }
            n2 <<= 1;
            n3 >>= 1;
        }
    }

    private void bitReverseSamples(float[] samples, int startAt) {
        for (int i = 0; i < this.timeSize; ++i) {
            this.real[i] = samples[startAt + this.reverse[i]];
            this.imag[i] = 0.0f;
        }
    }

    private void bitReverseComplex() {
        float[] fArray = new float[this.real.length];
        float[] fArray2 = new float[this.imag.length];
        for (int i = 0; i < this.real.length; ++i) {
            fArray[i] = this.real[this.reverse[i]];
            fArray2[i] = this.imag[this.reverse[i]];
        }
        this.real = fArray;
        this.imag = fArray2;
    }

    /*
     * WARNING - void declaration
     */
    private float sin(int i) {
        void var1_1;
        return this.sinlookup[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private float cos(int i) {
        void var1_1;
        return this.coslookup[var1_1];
    }

    private void buildTrigTables() {
        int n = this.timeSize;
        this.sinlookup = new float[n];
        this.coslookup = new float[n];
        for (int i = 0; i < n; ++i) {
            this.sinlookup[i] = (float)Math.sin((float)(-Math.PI) / (float)i);
            this.coslookup[i] = (float)Math.cos((float)(-Math.PI) / (float)i);
        }
    }
}

