/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util.fft;

import android.content.Context;
import android.os.Handler;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.mask.SoundInputFilter;
import com.momo.mcamera.util.fft.AudioRecorder;
import com.momo.mcamera.util.fft.FFT;
import com.momo.mcamera.util.fft.Spectrum;

public class AudioRecordThread
extends Thread {
    private Context mContext;
    private Handler mHandler;
    private boolean thread_running = true;
    private AudioRecorder mAudioRecorder = new AudioRecorder();
    private Spectrum mSpectrum = new Spectrum();
    private int mAccuracy;
    private SoundInputFilter mSoundInputFilter;
    private int index = 0;

    /*
     * WARNING - void declaration
     */
    public AudioRecordThread(Context context, Handler handler, int accuracy) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mContext = var1_1;
        this.mHandler = var2_2;
        this.mAccuracy = var3_3;
    }

    private void getFreqByFFT(FFT fft_samples, short[] buffer_samples) {
        int n;
        float[] fArray = new float[this.mAccuracy];
        for (n = this.index; n < this.mAudioRecorder.d + this.index; ++n) {
            fArray[n - this.index] = (float)buffer_samples[n - this.index] / 32767.0f;
        }
        this.index += this.mAudioRecorder.d;
        if (this.index >= this.mAccuracy) {
            this.index = 0;
            for (n = 0; n < this.mAccuracy / 2; ++n) {
                float f = (float)(0.5 + 0.5 * Math.cos(Math.PI * (double)n / (double)(this.mAccuracy / 2)));
                if (n > this.mAccuracy / 2) {
                    f = 0.0f;
                }
                int n2 = this.mAccuracy / 2 + n;
                fArray[n2] = fArray[n2] * f;
                int n3 = this.mAccuracy / 2 - n;
                fArray[n3] = fArray[n3] * f;
            }
            fArray[0] = 0.0f;
            fft_samples.forward(fArray);
            float[] fArray2 = new float[fft_samples.specSize()];
            int[] nArray = new int[fft_samples.specSize()];
            float f = 0.0f;
            int n4 = 0;
            for (int i = 0; i < fft_samples.specSize(); ++i) {
                float f2 = fft_samples.getBand(i);
                fArray2[i] = (float)Math.log10(f2 + 1.0f);
                nArray[i] = Math.round((float)i * (44100.0f / (float)this.mAccuracy));
                if (!(fft_samples.getBand(i) > f)) continue;
                f = fft_samples.getBand(i);
                n4 = i;
            }
            Math.round((float)n4 * (44100.0f / (float)this.mAccuracy));
            try {
                byte[] byArray = new byte[2048];
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 256; ++j) {
                        float f3;
                        float f4 = fArray2[(i << 8) + j] * 128.0f;
                        int n5 = f3 > 255.0f ? 255 : (int)f4;
                        byArray[(i << 8 << 2) + (j << 2)] = (byte)n5;
                        byArray[(i << 8 << 2) + (j << 2) + 1] = (byte)(n5 >> 8);
                        byArray[(i << 8 << 2) + (j << 2) + 2] = (byte)(n5 >> 16);
                        byArray[(i << 8 << 2) + (j << 2) + 3] = n5 >> 24;
                    }
                }
                if (this.mSoundInputFilter != null) {
                    this.mSoundInputFilter.setSoundBytes(byArray);
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void stopThread() {
        AudioRecorder audioRecorder = this.mAudioRecorder;
        try {
            audioRecorder.a.stop();
            audioRecorder.a.release();
        }
        catch (IllegalStateException illegalStateException) {
            MDLog.e((String)"Stop failed", (String)illegalStateException.toString());
        }
        this.thread_running = false;
        if (this != null && this.isAlive() && !this.isInterrupted()) {
            this.interrupt();
        }
    }

    public void restartThread() {
        this.mAudioRecorder.a();
        this.thread_running = true;
        if (this != null && !this.isAlive() && this.isInterrupted()) {
            this.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSoundInputFilter(SoundInputFilter mSoundInputFilter) {
        void var1_1;
        this.mSoundInputFilter = var1_1;
    }

    @Override
    public void run() {
        while (this.thread_running) {
            this.mAudioRecorder.b = this.mAccuracy;
            this.mAudioRecorder.a();
            Object object = this.mAudioRecorder;
            ((AudioRecorder)object).c = new short[((AudioRecorder)object).b];
            ((AudioRecorder)object).d = ((AudioRecorder)object).a.read(((AudioRecorder)object).c, 0, ((AudioRecorder)object).b);
            short[] sArray = ((AudioRecorder)object).c;
            this.mSpectrum.a = sArray;
            object = new FFT(this.mAccuracy, 44100.0f);
            this.getFreqByFFT((FFT)object, sArray);
        }
    }
}

