/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.graphics.PointF;
import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.GLProgram;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class BigEyeFilter
extends BasicFilter
implements FaceDetectInterface {
    public static final String UNIFORM_TEXTURE_SIZE = "textureSize";
    public static final String UNIFORM_CENTER_LEFT = "centerLeft";
    public static final String UNIFORM_CENTER_RIGHT = "centerRight";
    public static final String UNIFORM_RADIUS_LEFT = "radiusLeft";
    public static final String UNIFORM_RADIUS_RIGHT = "radiusRight";
    public static final String UNIFORM_SCALE = "scale";
    public int handleTextureSize = 0;
    public int handleCenterLeft = 0;
    public int handleCenterRight = 0;
    public int handleRadiusLeft = 0;
    public int handleRadiuRight = 0;
    public int handleScale = 0;
    public float[] textureSize = new float[2];
    public float[] centerLeft = new float[2];
    public float[] centerRight = new float[2];
    public float radiusLeft = 0.0f;
    public float radiusRight = 0.0f;
    private float scale = 0.0f;
    private float mEyeScale = 0.0f;
    private EyesProgram eyesProgram = new EyesProgram(this, 1, 1);
    private MMCVInfo mMmcvInfo = null;

    public BigEyeFilter() {
        if (this.eyesProgram != null) {
            this.eyesProgram.setDrawType(4);
        }
    }

    public void drawSub() {
        super.drawSub();
        this.drawEyes();
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.eyesProgram != null) {
            this.eyesProgram.setRenderSize(source.getWidth(), source.getHeight());
        }
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            if (mmcvInfo == null) {
                return;
            }
            this.mMmcvInfo = var1_1;
            return;
        }
    }

    private void drawEyes() {
        if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
            for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                if (this.mMmcvInfo.getFaceAttributeInfo(i) == null || this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104() == null) continue;
                Object object = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[39], this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[143]);
                Object object2 = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[45], this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[149]);
                this.centerLeft[0] = (object.x + object2.x) / 2.0f;
                this.centerLeft[1] = 1.0f * (float)this.mMmcvInfo.getWidth() - (object.y + object2.y) / 2.0f;
                PointF pointF = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[51], this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[155]);
                PointF pointF2 = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[57], this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104()[161]);
                this.centerRight[0] = (pointF.x + pointF2.x) / 2.0f;
                this.centerRight[1] = 1.0f * (float)this.mMmcvInfo.getWidth() - (pointF.y + pointF2.y) / 2.0f;
                double d = Math.sqrt((object.x - object2.x) * (object.x - object2.x) + (object.y - object2.y) * (object.y - object2.y));
                double d2 = (Math.sqrt((pointF.x - pointF2.x) * (pointF.x - pointF2.x) + (pointF.y - pointF2.y) * (pointF.y - pointF2.y)) + d) / 2.0;
                float f = 1.0f - Math.min(Math.abs(this.mMmcvInfo.getFaceAttributeInfo(i).getEulerAngles()[1]) / 60.0f, 1.0f);
                this.scale = (float)((double)this.mEyeScale * 0.2 * Math.exp((double)f - 1.0));
                this.radiusLeft = (float)(d2 * 0.8);
                this.radiusRight = (float)(d2 * 0.8);
                object = new int[]{this.texture_in};
                object2 = AIFaceTriangulation.getFaceTriangulation(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight(), null);
                this.eyesProgram.drawFrame((float[][])object2, (int[])object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setEyeScale(float scale) {
        void var1_1;
        this.mEyeScale = var1_1;
    }

    class EyesProgram
    extends GLProgram {
        final /* synthetic */ BigEyeFilter this$0;

        /*
         * WARNING - void declaration
         */
        public EyesProgram(BigEyeFilter this$0, int numTexture, int numCoord) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((int)var2_2, (int)var3_3);
        }

        @Override
        protected String getSubFrameShader() {
            return "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate0;\nuniform vec2 textureSize;\nuniform vec2 centerLeft;\nuniform vec2 centerRight;\nuniform float radiusLeft;\nuniform float radiusRight; \nuniform float scale;\nvoid main() {\n    vec2 textureCoordinate = textureCoordinate0  * textureSize;\n    float distanceLeft = distance(centerLeft, textureCoordinate);\n    if (distanceLeft < radiusLeft) {\n        vec2 offset = textureCoordinate - centerLeft;\n        float percent = 1.0 - ((radiusLeft - distanceLeft) / radiusLeft) * scale;\n        percent = percent * percent;\n        offset *= percent;\n        gl_FragColor = texture2D(inputImageTexture0, (centerLeft + offset)/textureSize);\n        return;\n    }\n    float distanceRight = distance(centerRight, textureCoordinate);\n    if (distanceRight < radiusRight) {\n        vec2 offset = textureCoordinate - centerRight;\n        float percent = 1.0 - ((radiusRight - distanceRight) / radiusRight) * scale;\n        percent = percent * percent;\n        offset *= percent;\n        gl_FragColor = texture2D(inputImageTexture0, (centerRight + offset)/textureSize);\n        return;\n    }\n    gl_FragColor = texture2D(inputImageTexture0, textureCoordinate0);\n}";
        }

        @Override
        protected void initShaderHandles() {
            super.initShaderHandles();
            this.this$0.handleTextureSize = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_TEXTURE_SIZE);
            this.this$0.handleCenterLeft = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_CENTER_LEFT);
            this.this$0.handleCenterRight = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_CENTER_RIGHT);
            this.this$0.handleRadiusLeft = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_RADIUS_LEFT);
            this.this$0.handleRadiuRight = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_RADIUS_RIGHT);
            this.this$0.handleScale = GLES20.glGetUniformLocation((int)this.programHandle, (String)BigEyeFilter.UNIFORM_SCALE);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void passShaderValues(float[][] triArray, int[] textures) {
            void var2_2;
            void var1_1;
            super.passShaderValues((float[][])var1_1, (int[])var2_2);
            this.this$0.textureSize[0] = this.width;
            this.this$0.textureSize[1] = this.height;
            GLES20.glUniform2f((int)this.this$0.handleTextureSize, (float)this.this$0.textureSize[0], (float)this.this$0.textureSize[1]);
            GLES20.glUniform2f((int)this.this$0.handleCenterLeft, (float)this.this$0.centerLeft[0], (float)this.this$0.centerLeft[1]);
            GLES20.glUniform2f((int)this.this$0.handleCenterRight, (float)this.this$0.centerRight[0], (float)this.this$0.centerRight[1]);
            GLES20.glUniform1f((int)this.this$0.handleRadiusLeft, (float)this.this$0.radiusLeft);
            GLES20.glUniform1f((int)this.this$0.handleRadiuRight, (float)this.this$0.radiusRight);
            GLES20.glUniform1f((int)this.this$0.handleScale, (float)this.this$0.scale);
        }
    }
}

