/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.opengl.Matrix;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerMaskFilter;

public class StickerGestureMaskFilter
extends StickerMaskFilter {
    private static final float DEFAULT_GESTURE_WIDTH = 180.0f;
    private boolean hasGestureRect = false;
    private RectF currentRect = null;
    private PointF currentCenter = null;

    /*
     * WARNING - void declaration
     */
    public StickerGestureMaskFilter(Context context, Sticker sticker) {
        super((Context)var1_1, (Sticker)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        if (this.hasGestureRect) {
            if (detectParam.gestureRect == null) {
                detectParam.gestureRect = this.currentRect;
            }
        } else if (detectParam.gestureRect != null) {
            this.currentRect = detectParam.gestureRect;
            this.hasGestureRect = true;
        }
        if (this.currentRect == null) {
            return;
        }
        Object object = this.maskListLock;
        synchronized (object) {
            void var1_1;
            PointF pointF;
            float f = this.currentRect.right - this.currentRect.left;
            float f2 = this.currentRect.bottom - this.currentRect.top;
            float f3 = f / 180.0f;
            float f4 = (float)this.getWidth() / 2.0f;
            f4 = (float)this.sticker.getImageWidth() * this.getAdjustWidthScale() / f4;
            f3 *= f4;
            detectParam.points8 = new float[8];
            detectParam.points8[0] = this.currentRect.left;
            detectParam.points8[1] = this.currentRect.right;
            detectParam.points8[2] = this.currentRect.left;
            detectParam.points8[3] = this.currentRect.right;
            detectParam.points8[4] = this.currentRect.top;
            detectParam.points8[5] = this.currentRect.top;
            detectParam.points8[6] = this.currentRect.bottom;
            detectParam.points8[7] = this.currentRect.bottom;
            if (detectParam.points8 != null && null != this.sticker.getPointIndexes() && this.sticker.getPointIndexes().length > 1) {
                int n = this.sticker.getPointIndexes()[0];
                int n2 = this.sticker.getPointIndexes()[1];
                f4 = detectParam.points8[n];
                float f5 = detectParam.points8[n + 4];
                float f6 = detectParam.points8[n2];
                float f7 = detectParam.points8[n2 + 4];
                pointF = this.getCenterPoint(new PointF(f4, f5), new PointF(f6, f7));
                pointF = new PointF(pointF.x / (float)this.getWidth(), pointF.y / (float)this.getHeight());
            } else {
                pointF = new PointF((this.currentRect.left + f / 2.0f) / (float)this.getWidth(), (this.currentRect.top + f2 / 2.0f) / (float)this.getHeight());
            }
            float f8 = f3;
            this.setParamForMatrix(f8, f8, pointF, 0.0f, var1_1.filterTrigerManager);
            return;
        }
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return 1.5f;
    }

    /*
     * WARNING - void declaration
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, FilterTriggerManager filterTrigerManager) {
        void var2_3;
        void var1_1;
        float f = -(centerPoint.x * 2.0f - 1.0f);
        float f2 = -centerPoint.y * 2.0f + 1.0f;
        centerPoint.x = f;
        fArray.y = f2;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f), (float)f2, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
        Matrix.rotateM((float[])fArray, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])fArray, (int)0, (float)var1_1, (float)var2_3, (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
        float[] fArray3 = new float[8];
        float[] fArray4 = fArray3;
        fArray3[0] = fArray2[0];
        fArray4[1] = fArray2[1];
        fArray4[2] = fArray2[4];
        fArray4[3] = fArray2[5];
        fArray4[4] = fArray2[8];
        fArray4[5] = fArray2[9];
        fArray4[6] = fArray2[12];
        fArray4[7] = fArray2[13];
        this.mvpLists.add(fArray4);
    }

    /*
     * WARNING - void declaration
     */
    public PointF getCenterPoint(PointF pointA, PointF pointB) {
        void var1_1;
        void var2_3;
        float f = pointA.x + (pointB.x - pointA.x) / 2.0f;
        float f2 = pointA.y + (var2_3.y - var1_1.y) / 2.0f;
        return new PointF(f, f2);
    }

    @Override
    public void pauseBitmapCache() {
        super.pauseBitmapCache();
        if (this.sticker != null) {
            this.sticker.curIndex = 0;
            this.hasGestureRect = false;
            this.currentRect = null;
        }
    }
}

