/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.opengl.ETC1Util;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.text.TextUtils;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momo.mcamera.mask.StickerDelegateItem;
import com.momo.mcamera.mask.StickerETC1Item;
import com.momo.mcamera.mask.StickerFixItem;
import com.momo.mcamera.mask.StickerGameItem;
import com.momo.mcamera.mask.StickerHaniItem;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.mask.bean.AbsolutePosition;
import com.momo.mcamera.util.PointHelper;
import com.momocv.MMBox;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import project.android.imageprocessing.EffectTimeBean;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class MultiStickerMaskFilter
extends BasicFilter
implements FaceDetectInterface,
IVideoTrackTime {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_3 = "position3";
    public static final String UNIFORM_ETC1FLAG = "etc1Flag";
    public static final String UNIFORM_PREMULTI = "isPreMulti";
    protected static final long DEFAULT_DURATION = 30000000L;
    protected List<StickerItem> stickerItemList;
    protected List<List<StickerItem>> mPollTriggerStickerItemList;
    protected List<StickerItem> stickerItemDestroyList;
    protected final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    protected static final int COORDS_PER_VERTEX = 2;
    protected final int vertexStride = 8;
    protected int decorateHandler;
    private int mVPMatrixHandler;
    private int mETC1Handler;
    protected int positionHandle3;
    private int isPreMultiHandle;
    public ShortBuffer drawListBuffer;
    private boolean lockTexture = false;
    protected final float[] mProjectionMatrix = new float[16];
    FilterTriggerManager filterTriggerManager;
    float scaleWidthRatio = 1.0f;
    float scaleHeightRatio = 1.0f;
    public static final int POINTS_LENGTH = 68;
    private MMCVBoxes mmcvBoxes;
    public StickerFinishListener finishListener;
    protected FloatBuffer vertexBufer;
    protected float[] textureCoord;
    protected Context context;
    private boolean isPreMultiMode = false;
    protected int faceIndex = 0;
    private boolean projectionInit = false;
    protected long lastStickerTime = 0L;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   inputTextureCoordinate ; attribute vec4   position3 ; varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nuniform mediump float etc1Flag;\nvoid main() {  gl_Position = position;  vec2 coord = inputTextureCoordinate.xy;  if(etc1Flag > 0.5){\n    vec2 coord1 = position3.xy;    textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0-(coord1.y + 0.5));\n  }else{\n    coord = (coord) / decorationSize;\n   }\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture0;uniform float etc1Flag;\nuniform int isPreMulti;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture0,textureCoordinate);\nif(etc1Flag > 0.5){\n   color1.a  = texture2D(inputImageTexture0,textureCoordinate1).r;\n}else{\n   if(isPreMulti == 1){\n       if (color1.a > 0.0) {color1.rgb = color1.rgb/color1.a;}   }\n}\n   gl_FragColor = color1; }";
    private List<StickerItem> mCurrentStickerItem = null;
    private int mIndex = 0;
    private boolean mLastMmcvBoxIsEmpty = true;
    private int mNoBoxCount = 0;
    private long mCurrentTime = 0L;

    public MultiStickerMaskFilter(Context context) {
        ByteBuffer byteBuffer;
        this.context = byteBuffer;
        this.stickerItemList = new ArrayList<StickerItem>();
        this.stickerItemDestroyList = new ArrayList<StickerItem>();
        byteBuffer = ByteBuffer.allocateDirect(this.drawOrder.length << 1);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.drawListBuffer = byteBuffer.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
    }

    public void setPollGroupNumber(int number) {
        this.mPollTriggerStickerItemList = new ArrayList<List<StickerItem>>();
        for (int i = 0; i < number; ++i) {
            this.mPollTriggerStickerItemList.add(new ArrayList());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addSticker(StickerItem item) {
        if (item != null) {
            item.setProjectionMatrix(this.mProjectionMatrix);
            item.setFinishListener(new StickerBlendFilter.StickerMaskFinishListener(this, item){
                final /* synthetic */ StickerItem val$item;
                final /* synthetic */ MultiStickerMaskFilter this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$item = stickerItem;
                }

                @Override
                public void stickerRenderFinished() {
                    this.this$0.removeStickerItem(this.val$item);
                    if (this.this$0.finishListener != null) {
                        int n = this.this$0.stickerItemList.size() - this.this$0.stickerItemDestroyList.size();
                        this.this$0.finishListener.stickerRenderFinished(n > 0 ? n : 0, this.val$item.sticker);
                    }
                }
            });
            if (item.sticker.getPollTrigger()) {
                if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
                    this.mPollTriggerStickerItemList.get(item.sticker.getGroupNum()).add(item);
                    return;
                }
            } else {
                void var1_1;
                this.stickerItemList.add((StickerItem)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addSticker(Sticker sticker, StickerBlendFilter.StickerStateChangeListener listener) {
        if (sticker != null) {
            void var1_1;
            void var2_2;
            StickerItem stickerItem = sticker.getEtcTextureBatch() != null ? new StickerETC1Item(sticker, this.context) : (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().startsWith("weex") ? new StickerDelegateItem(sticker, this.context) : (sticker.isGameSticker ? new StickerGameItem(sticker, this.context) : ("STICKER_TYPE_GAME_FIX_TYPE".equals(sticker.getStickerType()) ? new StickerFixItem(sticker, this.context) : (sticker.isHaniSticker ? new StickerHaniItem(sticker, this.context) : new StickerItem(sticker, this.context)))));
            stickerItem.setStickerStateChangeListener((StickerBlendFilter.StickerStateChangeListener)var2_2);
            stickerItem.mStickerDuration = sticker.getDuration() > 0L ? var1_1.getDuration() : 30000000L;
            this.addSticker(stickerItem);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void passStickerShaderValues(StickerItem item, float[] mvpMatrix) {
        void var2_2;
        if (item.fvertexBuffer == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(mvpMatrix.length << 2);
            byteBuffer.order(ByteOrder.nativeOrder());
            item.fvertexBuffer = byteBuffer.asFloatBuffer();
        }
        item.fvertexBuffer.position(0);
        item.fvertexBuffer.put((float[])var2_2);
        item.fvertexBuffer.position(0);
        if (item instanceof StickerETC1Item) {
            this.setUseETC1(true);
        } else {
            this.setUseETC1(false);
        }
        GLES20.glUniform1i((int)this.isPreMultiHandle, (int)(this.isPreMultiMode ? 1 : 0));
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)item.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)item.vertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle3, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)item.vertexBuffer2);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle3);
        GLES20.glActiveTexture((int)33984);
        if (item instanceof StickerETC1Item) {
            GLES20.glBindTexture((int)3553, (int)((StickerETC1Item)item).etc1_texture_sticker);
        } else {
            void var1_1;
            GLES20.glBindTexture((int)3553, (int)var1_1.texture_sticker);
        }
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public void drawStick(float aspectRatio) {
        void var1_1;
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)var1_1);
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        this.disableDrawArray();
        GLES20.glDisableVertexAttribArray((int)this.positionHandle3);
    }

    public void drawBackgroundImage() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)1.0f);
        this.setUseETC1(false);
        if (this.textureCoord == null) {
            this.textureCoord = new float[8];
        }
        this.textureVertices[this.curRotation].position(0);
        this.textureVertices[this.curRotation].get(this.textureCoord);
        if (this.vertexBufer == null) {
            this.vertexBufer = ByteBuffer.allocateDirect(this.textureCoord.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        for (int i = 0; i < 8; ++i) {
            this.textureCoord[i] = -this.textureCoord[i] + 0.5f;
        }
        this.vertexBufer.position(0);
        this.vertexBufer.put(this.textureCoord);
        this.vertexBufer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.disableDrawArray();
        GLES20.glDisableVertexAttribArray((int)this.positionHandle3);
    }

    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        GLES20.glClear((int)16640);
        this.drawBackgroundImage();
        GLES20.glEnable((int)3042);
        GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        if (this.stickerItemDestroyList.size() > 0) {
            Iterator<StickerItem> iterator = new ArrayList<StickerItem>(this.stickerItemDestroyList);
            Iterator object = iterator.iterator();
            while (object.hasNext()) {
                StickerItem stickerItem = (StickerItem)object.next();
                stickerItem.destroy();
                this.stickerItemDestroyList.remove(stickerItem);
                if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
                    for (List<StickerItem> list : this.mPollTriggerStickerItemList) {
                        if (!list.contains(stickerItem)) continue;
                        list.remove(stickerItem);
                    }
                }
                this.stickerItemList.remove(stickerItem);
            }
            iterator.clear();
        }
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            for (StickerItem stickerItem : this.stickerItemList) {
                this.drawSubStickerItemByAll(stickerItem);
            }
        }
        if (this.mCurrentStickerItem != null && this.mCurrentStickerItem.size() > 0) {
            for (StickerItem stickerItem : this.mCurrentStickerItem) {
                this.drawSubStickerItemByAll(stickerItem);
            }
        }
        GLES20.glDisable((int)3042);
    }

    /*
     * WARNING - void declaration
     */
    private void drawSubStickerItemByAll(StickerItem stickerItem) {
        if (stickerItem.getEffectTimeBean() == null || !stickerItem.sticker.isHaniSticker || this.mCurrentTime >= stickerItem.getEffectTimeBean().mStartTime && this.mCurrentTime <= stickerItem.getEffectTimeBean().mEndTime) {
            void var1_1;
            this.drawSubStickerItem((StickerItem)var1_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void drawSubStickerItem(StickerItem stickerItem) {
        Object object = stickerItem.getLockObject();
        synchronized (object) {
            Object object2;
            Object object3;
            boolean bl = false;
            stickerItem.imageWidth = this.getWidth();
            stickerItem.imageHeight = this.getHeight();
            if (stickerItem.mvpLists != null && stickerItem.mvpLists.size() > 0 && stickerItem.isDraw) {
                if (stickerItem instanceof StickerETC1Item) {
                    object3 = (StickerETC1Item)stickerItem;
                    bl = true;
                    if (((StickerETC1Item)object3).etc1_texture_sticker == 0) {
                        ((StickerETC1Item)object3).etc1_texture_sticker = TextureHelper.etc1ToTexture((ETC1Util.ETC1Texture)((StickerETC1Item)object3).texture);
                    }
                    ((StickerETC1Item)object3).updateETC1Coordinate();
                } else {
                    object3 = stickerItem.getMmcvImage(this.context);
                    if (object3 != null && object3.getDataPtr() != null) {
                        stickerItem.texture_sticker = stickerItem.texture_sticker == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)object3) : TextureHelper.loadDataToTexture((int)stickerItem.texture_sticker, (MMFrameInfo)object3);
                    } else {
                        object2 = stickerItem.getBitmap();
                        if (object2 != null && !object2.isRecycled()) {
                            if (stickerItem.texture_sticker > 0) {
                                TextureHelper.updateBitmap((Bitmap)object2, (int)stickerItem.texture_sticker);
                            } else {
                                stickerItem.texture_sticker = TextureHelper.bitmapToTexture((Bitmap)object2);
                            }
                        }
                    }
                }
            } else if (stickerItem.sticker.getLoopStart() <= 0 || !stickerItem.sticker.isAlwaysShow()) {
                stickerItem.sticker.curIndex = 0;
            }
            if (stickerItem.isDraw && (stickerItem.texture_sticker != 0 || bl)) {
                void var1_1;
                this.isPreMultiMode = stickerItem.sticker.isPreMultiAlpha();
                object3 = stickerItem.mvpLists.iterator();
                while (object3.hasNext()) {
                    object2 = (float[])object3.next();
                    this.passStickerShaderValues(stickerItem, (float[])object2);
                    this.drawStick(stickerItem.getStickerAspectRatio());
                }
                var1_1.clearPoints();
            }
            return;
        }
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle3 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_3);
        this.mVPMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_MVP_MATRIX);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
        this.mETC1Handler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ETC1FLAG);
        this.isPreMultiHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_PREMULTI);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_MVP_MATRIX);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var2_2;
        void var1_1;
        if (newData) {
            this.markAsDirty();
        }
        this.texture_in = var1_1;
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        var2_2.unlockRenderBuffer();
    }

    protected void handleSizeChange() {
        super.handleSizeChange();
        if (this.getHeight() > 0 && this.getWidth() > 0) {
            float f = (float)this.getWidth() / (float)this.getHeight();
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / f), (float)(1.0f / f), (float)3.0f, (float)7.0f);
            this.projectionInit = true;
        }
    }

    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   inputTextureCoordinate ; attribute vec4   position3 ; varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nuniform mediump float etc1Flag;\nvoid main() {  gl_Position = position;  vec2 coord = inputTextureCoordinate.xy;  if(etc1Flag > 0.5){\n    vec2 coord1 = position3.xy;    textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0-(coord1.y + 0.5));\n  }else{\n    coord = (coord) / decorationSize;\n   }\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture0;uniform float etc1Flag;\nuniform int isPreMulti;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture0,textureCoordinate);\nif(etc1Flag > 0.5){\n   color1.a  = texture2D(inputImageTexture0,textureCoordinate1).r;\n}else{\n   if(isPreMulti == 1){\n       if (color1.a > 0.0) {color1.rgb = color1.rgb/color1.a;}   }\n}\n   gl_FragColor = color1; }";
    }

    public void destroy() {
        Iterator<Object> iterator;
        super.destroy();
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            iterator = this.stickerItemList.iterator();
            while (iterator.hasNext()) {
                ((StickerItem)iterator.next()).destroy();
            }
            this.stickerItemList.clear();
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List list : this.mPollTriggerStickerItemList) {
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    ((StickerItem)iterator2.next()).destroy();
                }
                list.clear();
            }
            this.mPollTriggerStickerItemList.clear();
        }
        if (this.stickerItemDestroyList != null && this.stickerItemDestroyList.size() > 0) {
            iterator = this.stickerItemDestroyList.iterator();
            while (iterator.hasNext()) {
                ((StickerItem)iterator.next()).destroy();
            }
            this.stickerItemDestroyList.clear();
        }
    }

    public void setTimeStamp(long ms) {
        this.mCurrentTime = ms;
        Iterator<Object> iterator = this.stickerItemList.iterator();
        while (iterator.hasNext()) {
            iterator.next().setRenderTime(ms);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            iterator = this.mPollTriggerStickerItemList.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    ((StickerItem)iterator2.next()).setRenderTime(ms);
                }
            }
        }
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        float f;
        this.lastStickerTime = System.currentTimeMillis();
        if (!this.projectionInit && this.getWidth() > 0 && this.getHeight() > 0) {
            f = (float)this.getWidth() / (float)this.getHeight();
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / f), (float)(1.0f / f), (float)3.0f, (float)7.0f);
            this.projectionInit = true;
        }
        if (mmcvInfo.getMaxFaceCnt() <= 0) {
            this.updateFaceInfo(mmcvInfo, 0.0f, null, false);
            return;
        }
        if (this.faceIndex != 0 && this.faceIndex < mmcvInfo.getMaxFaceCnt()) {
            f = mmcvInfo.getFaceAttributeInfo(this.faceIndex).getFaceRotateDegree_2d();
            float[] fArray = mmcvInfo.getFaceAttributeInfo(this.faceIndex).getLandmarks68();
            this.updateFaceInfo(mmcvInfo, f, fArray, true);
            return;
        }
        for (int i = mmcvInfo.getMaxFaceCnt() - 1; i >= 0; --i) {
            float f2 = mmcvInfo.getFaceAttributeInfo(i).getFaceRotateDegree_2d();
            float[] fArray = mmcvInfo.getFaceAttributeInfo(i).getLandmarks68();
            this.updateFaceInfo(mmcvInfo, f2, fArray, true);
        }
    }

    public float getAdjustHeightScale() {
        if ((float)this.getHeight() == 640.0f) {
            return 1.0f;
        }
        return (float)this.getHeight() / 640.0f;
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return (float)this.getWidth() / 480.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void setFilterTriggerManager(FilterTriggerManager filterTriggerManager) {
        void var1_1;
        this.filterTriggerManager = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMmcvBoxes(MMCVBoxes mmcvBoxes) {
        void var1_1;
        this.mmcvBoxes = mmcvBoxes;
        if (this.mmcvBoxes != null && this.mCurrentStickerItem == null && this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0 && this.mmcvBoxes.getDetectResult()[0].class_name_.equals(this.mPollTriggerStickerItemList.get((int)0).get((int)0).sticker.getObjectTriggerType())) {
            this.mCurrentStickerItem = this.mPollTriggerStickerItemList.get(this.mIndex);
            this.mLastMmcvBoxIsEmpty = false;
            return;
        }
        if (var1_1 != null && this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0 && this.mmcvBoxes.getDetectResult().length > 0 && this.mmcvBoxes.getDetectResult()[0].class_name_.equals(this.mPollTriggerStickerItemList.get((int)0).get((int)0).sticker.getObjectTriggerType())) {
            if (this.mLastMmcvBoxIsEmpty) {
                ++this.mIndex;
                this.mCurrentStickerItem = this.mPollTriggerStickerItemList.get(this.mIndex % this.mPollTriggerStickerItemList.size());
            }
            this.mLastMmcvBoxIsEmpty = false;
            return;
        }
        if (this.mNoBoxCount == 3) {
            this.mLastMmcvBoxIsEmpty = true;
            this.mNoBoxCount = 0;
        }
        ++this.mNoBoxCount;
    }

    public void updateFaceInfo(MMCVInfo info, float angle, float[] facePos, boolean hasFace) {
        for (StickerItem stickerItem : this.stickerItemList) {
            this.updateFaceInfoBySingleItem(info, angle, facePos, hasFace, stickerItem);
        }
        if (this.mPollTriggerStickerItemList != null && this.mCurrentStickerItem != null) {
            for (StickerItem stickerItem : this.mCurrentStickerItem) {
                this.updateFaceInfoBySingleItem(info, angle, facePos, hasFace, stickerItem);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateFaceInfoBySingleItem(MMCVInfo info, float angle, float[] facePos, boolean hasFace, StickerItem stickerItem) {
        stickerItem.setCurrentTime(this.lastStickerTime);
        Sticker sticker = stickerItem.sticker;
        FaceDetectFilter.FaceDetectParam faceDetectParam = new FaceDetectFilter.FaceDetectParam();
        if (hasFace) {
            faceDetectParam.mmcvBoxes = this.mmcvBoxes;
            if (!this.drawAllStickers(stickerItem, faceDetectParam, hasFace) && sticker.getType() == 0) {
                void var2_2;
                void var3_3;
                void var1_1;
                this.drawFaceSticker(stickerItem, faceDetectParam, (MMCVInfo)var1_1, (float[])var3_3, (float)var2_2);
                return;
            }
        } else {
            this.drawAllStickers(stickerItem, faceDetectParam, hasFace);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean drawAllStickers(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param, boolean hasFace) {
        void var3_3;
        Sticker sticker = stickerItem.sticker;
        if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("object_follower")) {
            stickerItem.clearPoints();
            this.drawGestureFilter(stickerItem, param);
        } else if (!sticker.isAlwaysShow() && !hasFace) {
            stickerItem.clearPoints();
        } else if (sticker.getType() == 1) {
            stickerItem.clearPoints();
            this.drawFixedSticker(stickerItem, param);
        } else if (sticker.getType() == 2) {
            stickerItem.clearPoints();
            this.drawFullScreenFixed(stickerItem, param);
        } else if (sticker.getType() == 3) {
            stickerItem.clearPoints();
            this.drawScaleToFill(stickerItem, param);
        } else if (sticker.getType() == 99) {
            stickerItem.clearPoints();
            this.drawScaleCenterCrop(stickerItem, param);
        } else if (sticker.getType() == 5) {
            stickerItem.clearPoints();
            this.drawAbsolutePostion(stickerItem, param);
        } else if (sticker.getType() == 6) {
            stickerItem.clearPoints();
            this.drawAbsolutePostionUseStcikerDim(stickerItem, param);
        } else if (sticker.getType() == 7) {
            stickerItem.clearPoints();
            this.drawAbsPostionAdjustResolution(stickerItem, param);
        } else if (sticker.isNotHiddenAfterTrigger() && var3_3 == false) {
            void var2_2;
            void var1_1;
            var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void drawFaceSticker(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param, MMCVInfo info, float[] facePos, float faceRotateDegree) {
        void var2_2;
        void var1_1;
        Object object;
        Object object2;
        float f;
        PointF pointF;
        Sticker sticker = stickerItem.sticker;
        if (!sticker.isGameSticker) {
            stickerItem.clearPoints();
        }
        float f2 = facePos[sticker.getFacePositionLeft()];
        float f3 = facePos[sticker.getFacePositionLeft() + 68];
        float f4 = facePos[sticker.getFacePositionRight()];
        Object object3 = facePos[sticker.getFacePositionRight() + 68];
        PointF pointF2 = new PointF(f2, f3);
        PointF pointF3 = new PointF(f4, object3);
        PointF pointF4 = new PointF((float)sticker.getOffsetX() * this.getAdjustWidthScale(), (float)sticker.getOffsetY() * this.getAdjustWidthScale());
        PointHelper.a(pointF4, faceRotateDegree);
        if (sticker.hasCenterPoint()) {
            pointF = new PointF(facePos[sticker.getCenterIndex()], facePos[sticker.getCenterIndex() + 68]);
        } else if (sticker.getPointIndexes().length == 1) {
            int n = sticker.getPointIndexes()[0];
            f = pointF[n];
            object2 = pointF[n + 68];
            pointF = new PointF(f, (float)object2);
        } else {
            int n = sticker.getPointIndexes()[0];
            int n2 = sticker.getPointIndexes()[1];
            object2 = pointF[n];
            object = pointF[n + 68];
            object3 = pointF[n2];
            PointF pointF5 = pointF[n2 + 68];
            pointF = PointHelper.b(new PointF((float)object2, (float)object), new PointF(object3, (float)pointF5));
        }
        object3 = (float)PointHelper.a(pointF2, pointF3);
        f = object3 / 180.0f / this.getAdjustWidthScale();
        object2 = (float)(this.getWidth() / 2);
        object = (float)sticker.getImageWidth() * this.getAdjustWidthScale() / object2;
        pointF.x += pointF4.x * (object3 / 180.0f) / this.getAdjustWidthScale();
        pointF.y += pointF4.y * (object3 / 180.0f) / this.getAdjustWidthScale();
        PointF pointF6 = new PointF(pointF.x / (float)this.getWidth(), pointF.y / (float)this.getHeight());
        param.scaleW = f *= object;
        param.scaleH = f;
        param.centerPoint = pointF6;
        param.angle = faceRotateDegree;
        if (info.getMaxFaceCnt() > 0) {
            void var3_3;
            param.points68 = info.getFaceAttributeInfo(0).getLandmarks68();
            param.points96 = info.getFaceAttributeInfo(0).getLandmarks96();
            param.points104 = info.getFaceAttributeInfo(0).getLandmarks104();
            param.warpedPoints104 = var3_3.getFaceAttributeInfo(0).getWarpedLandmarks104();
        }
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawFixedSticker(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        Sticker sticker = stickerItem.sticker;
        float f = (float)this.getWidth() / 2.0f;
        float f2 = sticker.isShowTop() ? (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f : (float)this.getHeight() - (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF pointF = new PointF(f / (float)this.getWidth(), f2 / (float)this.getHeight());
        param.scaleW = f = (float)stickerItem.sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f);
        param.scaleH = f;
        param.centerPoint = pointF;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawGestureFilter(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        if (stickerItem.sticker.isDonotTrack()) {
            void var2_2;
            void var1_1;
            this.drawGestureFixedFilter((StickerItem)var1_1, (FaceDetectFilter.FaceDetectParam)var2_2);
        }
    }

    private void drawGestureFixedFilter(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        if (null == stickerItem.sticker.getObjectTriggerType()) {
            return;
        }
        if (this.mmcvBoxes == null || null == this.mmcvBoxes.getDetectResult()) {
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            stickerItem.setDetectParam(param);
            return;
        }
        param.triggerType = stickerItem.sticker.getObjectTriggerType();
        if (!TextUtils.isEmpty((CharSequence)param.triggerType)) {
            for (MMBox mMBox : this.mmcvBoxes.getDetectResult()) {
                if (!param.triggerType.equals(mMBox.class_name_)) continue;
                param.gestureRect = new RectF((float)mMBox.x_, (float)mMBox.y_, (float)(mMBox.x_ + mMBox.width_), (float)(mMBox.y_ + mMBox.height_));
                param.filterTrigerManager = this.filterTriggerManager;
                param.centerPoint = new PointF(0.0f, 0.0f);
                stickerItem.setDetectParam(param);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawFullScreenFixed(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f;
        float f2 = (float)this.getWidth() / 2.0f;
        float f3 = ((float)this.getHeight() - (float)stickerItem.sticker.getImageHeight() * this.getAdjustHeightScale()) / 2.0f + (float)stickerItem.sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF pointF = new PointF(f2 / (float)this.getWidth(), f3 / (float)this.getHeight());
        if (stickerItem.sticker.getImageWidth() > 360) {
            f3 = 2.0f;
            f = 2.0f;
        } else if (this.getWidth() == 720) {
            f3 = 2.0f;
            f = 2.0f;
        } else {
            f3 = 1.5f;
            f = 1.5f;
        }
        param.scaleW = f3;
        param.scaleH = f;
        param.centerPoint = pointF;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawScaleToFill(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f = (float)stickerItem.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f);
        param.scaleH = (float)this.getHeight() / (float)stickerItem.sticker.getImageHeight() * f;
        param.scaleW = (float)this.getWidth() / (float)stickerItem.sticker.getImageWidth() * f;
        param.centerPoint = new PointF(0.5f, 0.5f);
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawScaleCenterCrop(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f = (float)stickerItem.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f);
        float f2 = stickerItem.sticker.getImageWidth();
        float f3 = stickerItem.sticker.getImageHeight();
        f = f2 * (float)this.getHeight() > (float)this.getWidth() * f3 ? (float)this.getHeight() / f3 * f : (float)this.getWidth() / f2 * f;
        param.scaleW = f;
        param.scaleH = f;
        param.centerPoint = new PointF(0.5f, 0.5f);
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsolutePostion(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f = (float)stickerItem.sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f);
        AbsolutePosition absolutePosition = stickerItem.sticker.getAbsolutePos();
        param.centerPoint = absolutePosition != null && absolutePosition.getCenter() != null ? new PointF(absolutePosition.getCenter().x, absolutePosition.getCenter().y) : new PointF(0.5f, 0.5f);
        if (stickerItem instanceof StickerFixItem) {
            f = 2.0f * (float)stickerItem.sticker.getImageWidth() / (float)this.getWidth();
            float f2 = absolutePosition.getCenter().x * absolutePosition.getCenter().w + ((float)this.getWidth() - absolutePosition.getCenter().w) / 2.0f;
            float f3 = absolutePosition.getCenter().y * absolutePosition.getCenter().h;
            param.centerPoint.x = f2 / (float)this.getWidth();
            param.centerPoint.y = f3 / (float)this.getHeight();
        }
        param.scaleW = f;
        param.scaleH = f;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsolutePostionUseStcikerDim(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f = (float)stickerItem.sticker.getImageWidth() * ((float)this.getHeight() / (float)stickerItem.sticker.getBaseDemensionHeight()) / ((float)this.getWidth() / 2.0f);
        AbsolutePosition absolutePosition = stickerItem.sticker.getAbsolutePos();
        param.centerPoint = absolutePosition != null && absolutePosition.getCenter() != null ? new PointF(absolutePosition.getCenter().x, absolutePosition.getCenter().y) : new PointF(0.5f, 0.5f);
        param.scaleW = f;
        param.scaleH = f;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsPostionAdjustResolution(StickerItem stickerItem, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f = (float)this.getWidth() > 480.0f ? (float)this.getWidth() / 352.0f : 1.0f;
        f = (float)stickerItem.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f) * f;
        AbsolutePosition absolutePosition = stickerItem.sticker.getAbsolutePos();
        param.centerPoint = absolutePosition != null && absolutePosition.getCenter() != null ? new PointF(absolutePosition.getCenter().x, absolutePosition.getCenter().y) : new PointF(0.5f, 0.5f);
        param.scaleW = f;
        param.scaleH = f;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    public float getScaleWidthRatio() {
        return this.scaleWidthRatio;
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleWidthRatio(float scaleWidthRatio) {
        void var1_1;
        this.scaleWidthRatio = var1_1;
    }

    public float getScaleHeightRatio() {
        return this.scaleHeightRatio;
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleHeightRatio(float scaleHeightRatio) {
        void var1_1;
        this.scaleHeightRatio = var1_1;
    }

    public void setDownVelocity(float downVelocity) {
        for (StickerItem object : this.stickerItemList) {
            if (!(object instanceof StickerGameItem)) continue;
            ((StickerGameItem)object).downVelocity = downVelocity;
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            Iterator<Object> iterator = this.mPollTriggerStickerItemList.iterator();
            while (iterator.hasNext()) {
                for (StickerItem stickerItem : (List)iterator.next()) {
                    if (!(stickerItem instanceof StickerGameItem)) continue;
                    ((StickerGameItem)stickerItem).downVelocity = downVelocity;
                }
            }
        }
    }

    public void setHaniStickerParam(FaceDetectFilter.FaceDetectParam faceDetectParam, int haniID) {
        MultiStickerMaskFilter multiStickerMaskFilter = this;
        multiStickerMaskFilter.setHanniStickerParamInItemList(multiStickerMaskFilter.stickerItemList, faceDetectParam, haniID);
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List<StickerItem> list : this.mPollTriggerStickerItemList) {
                this.setHanniStickerParamInItemList(list, faceDetectParam, haniID);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setHanniStickerParamInItemList(List<StickerItem> itemList, FaceDetectFilter.FaceDetectParam faceDetectParam, int haniID) {
        StickerHaniItem stickerHaniItem = null;
        boolean bl = false;
        for (int i = 0; i < itemList.size(); ++i) {
            StickerItem stickerItem = itemList.get(i);
            if (!(stickerItem instanceof StickerHaniItem)) continue;
            stickerHaniItem = (StickerHaniItem)stickerItem;
            if (stickerHaniItem.sticker.getModelType() != haniID) continue;
            stickerHaniItem.setDetectParam(faceDetectParam);
            itemList.remove(stickerItem);
            bl = true;
            break;
        }
        if (bl && stickerHaniItem != null) {
            void var1_1;
            var1_1.add(stickerHaniItem);
        }
    }

    public void removeHaniSticker(int haniID) {
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            MultiStickerMaskFilter multiStickerMaskFilter = this;
            multiStickerMaskFilter.removeHaniStickerFromList(multiStickerMaskFilter.stickerItemList, haniID);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List<StickerItem> list : this.mPollTriggerStickerItemList) {
                this.removeHaniStickerFromList(list, haniID);
            }
        }
    }

    private void removeHaniStickerFromList(List<StickerItem> itemList, int haniID) {
        for (StickerItem stickerItem : itemList) {
            if (!(stickerItem instanceof StickerHaniItem) || ((StickerHaniItem)stickerItem).sticker.getModelType() != haniID) continue;
            this.stickerItemDestroyList.add(stickerItem);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeStickerItem(StickerItem item) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            this.stickerItemDestroyList.add((StickerItem)var1_1);
            return;
        }
    }

    public void clearMaskWithModelType(int modelType) {
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            MultiStickerMaskFilter multiStickerMaskFilter = this;
            multiStickerMaskFilter.clearMaskWithModeTypeFromList(multiStickerMaskFilter.stickerItemList, modelType);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List<StickerItem> list : this.mPollTriggerStickerItemList) {
                this.clearMaskWithModeTypeFromList(list, modelType);
            }
            this.mPollTriggerStickerItemList.clear();
            this.mPollTriggerStickerItemList = null;
        }
    }

    private void clearMaskWithModeTypeFromList(List<StickerItem> itemList, int modelType) {
        for (StickerItem stickerItem : itemList) {
            if (stickerItem.sticker.getModelType() != modelType) continue;
            this.stickerItemDestroyList.add(stickerItem);
        }
    }

    public void removeSticker(String stickerType) {
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            MultiStickerMaskFilter multiStickerMaskFilter = this;
            multiStickerMaskFilter.removeStickerFromList(multiStickerMaskFilter.stickerItemList, stickerType);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            for (List<StickerItem> list : this.mPollTriggerStickerItemList) {
                this.removeStickerFromList(list, stickerType);
            }
        }
    }

    private void removeStickerFromList(List<StickerItem> itemList, String stickerType) {
        for (StickerItem stickerItem : itemList) {
            if (!stickerType.equals(stickerItem.sticker.getStickerType())) continue;
            this.stickerItemDestroyList.add(stickerItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStickerItemListSize() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.stickerItemList != null) {
                int n = 0;
                if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
                    for (List<StickerItem> list : this.mPollTriggerStickerItemList) {
                        n += list.size();
                    }
                }
                return this.stickerItemList.size() + n;
            }
        }
        return 0;
    }

    public boolean isHaveSameSticker(Sticker sticker) {
        if (TextUtils.isEmpty((CharSequence)sticker.getStickerType())) {
            return false;
        }
        for (StickerItem object : this.stickerItemList) {
            if (!sticker.getStickerType().equals(object.sticker.getStickerType())) continue;
            return this.judgeHaveSameSticker(sticker, object);
        }
        if (this.mPollTriggerStickerItemList != null && this.mPollTriggerStickerItemList.size() > 0) {
            Iterator<Object> iterator = this.mPollTriggerStickerItemList.iterator();
            while (iterator.hasNext()) {
                for (StickerItem stickerItem : (List)iterator.next()) {
                    if (!stickerItem.sticker.getStickerType().equals(sticker.getStickerType())) continue;
                    return this.judgeHaveSameSticker(sticker, stickerItem);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean judgeHaveSameSticker(Sticker sticker, StickerItem stickerItem) {
        void var2_2;
        if (stickerItem instanceof StickerDelegateItem && stickerItem.sticker.getImageProvider() != null) {
            void var1_1;
            ((StickerDelegateItem)stickerItem).replaceSticker((Sticker)var1_1);
            return true;
        }
        this.removeStickerItem((StickerItem)var2_2);
        return false;
    }

    protected void setUseETC1(boolean bUseETC1) {
        if (bUseETC1) {
            GLES20.glUniform1f((int)this.mETC1Handler, (float)1.0f);
            return;
        }
        GLES20.glUniform1f((int)this.mETC1Handler, (float)0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public void setMainFaceIndex(int index) {
        void var1_1;
        this.faceIndex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setStickerFinishListener(StickerFinishListener finishListener) {
        void var1_1;
        this.finishListener = var1_1;
    }

    public void setEffectTimeInfoByHaniId(EffectTimeBean time, int haniId) {
        if (this.stickerItemList != null && this.stickerItemList.size() > 0) {
            for (StickerItem stickerItem : this.stickerItemList) {
                if (stickerItem.sticker.getModelType() != haniId) continue;
                stickerItem.setEffectTimeInfo(time);
            }
        }
    }

    public static interface StickerFinishListener {
        public void stickerRenderFinished(int var1, Sticker var2);
    }
}

