/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.Matrix;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.Log4Cam;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FacePositions;
import com.momo.mcamera.mask.MmcvImageCacheLoader;
import com.momo.mcamera.mask.MmcvImageLoader;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerFacePosition;
import com.momo.mcamera.mask.StickerItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StickerCutFaceItem
extends StickerItem {
    public List<FacePositions> mFacePositions;
    public List<float[]> mCutFaceList = Collections.synchronizedList(new ArrayList());
    float realWidth = 0.5f;
    float mStickerScale = 1.7777778f;
    int renderWidth = 0;
    int renderHeight = 0;
    float[] texData1 = new float[]{-this.realWidth, -(this.realWidth * this.mStickerScale), 0.0f, 1.0f, this.realWidth, -this.realWidth * this.mStickerScale, 0.0f, 1.0f, -this.realWidth, this.realWidth * this.mStickerScale, 0.0f, 1.0f, this.realWidth, this.realWidth * this.mStickerScale, 0.0f, 1.0f};
    private MMFrameInfo mBitmap = null;

    /*
     * WARNING - void declaration
     */
    public StickerCutFaceItem(Sticker inSticker, Context context) {
        super(inSticker, (Context)var2_2);
        void var1_1;
        void var2_2;
        this.isDraw = true;
        this.mFacePositions = var1_1.getAdditionalInfo().getFacePositions();
    }

    @Override
    public MMFrameInfo getMmcvImage(Context context) {
        return this.mBitmap;
    }

    @Override
    protected MmcvImageLoader getMMcvImageLoader() {
        return new MmcvImageCacheLoader(this.sticker, this.context);
    }

    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam param) {
        super.setDetectParam(param);
        if (this.renderWidth == 0 || this.renderHeight == 0) {
            return;
        }
        this.mBitmap = this.mmcvImageLoader.getMmcvImage(this.context);
        if (this.mvpLists != null && this.mvpLists.size() > 0) {
            this.mCutFaceList.clear();
            StickerCutFaceItem stickerCutFaceItem = this;
            int n = stickerCutFaceItem.getImageIndexByPath(stickerCutFaceItem.mmcvImageLoader.imagePath);
            Object object = this.mFacePositions.get(n).getStickerFacePositions();
            Log4Cam.i((String)"huli", (String)("in " + this.sticker.curIndex));
            if (object != null && object.size() > 0) {
                object = object.iterator();
                while (object.hasNext()) {
                    StickerFacePosition stickerFacePosition = (StickerFacePosition)object.next();
                    int n2 = stickerFacePosition.getFacex();
                    int n3 = stickerFacePosition.getFacey();
                    int n4 = (int)((double)stickerFacePosition.getRadius() * 1.1);
                    int n5 = stickerFacePosition.getAngle();
                    float f = (float)this.renderWidth * (float)this.sticker.getImageHeight() / (float)this.renderHeight;
                    float f2 = ((float)n2 + (f - (float)this.sticker.getImageWidth()) / 2.0f) / f;
                    float f3 = (float)n3 / (float)this.sticker.getImageHeight();
                    f = param.scaleW / (float)this.sticker.getImageWidth();
                    float f4 = (float)(2 * n4) * f;
                    float f5 = param.angle + (float)n5;
                    float f6 = f4;
                    this.calculateCutFaceMatrix(f6, f6 / 16.0f * 9.0f, new PointF(f2, f3), f5, this.texData1);
                }
            }
        }
    }

    public int getImageIndexByPath(String path) {
        String[] stringArray = path.split("_");
        return Integer.parseInt(stringArray[stringArray.length - 1].replace(".png", ""));
    }

    /*
     * WARNING - void declaration
     */
    public void calculateCutFaceMatrix(float w, float h, PointF centerPoint, float angle, float[] texData1) {
        void var2_3;
        void var1_1;
        void var3_4;
        if (centerPoint == null) {
            return;
        }
        float f = -(centerPoint.x * 2.0f - 1.0f);
        float f2 = -var3_4.y * 2.0f + 1.0f;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        Matrix.setIdentityM((float[])fArray3, (int)0);
        fArray3[0] = -1.0f;
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f), (float)f2, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray3, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.rotateM((float[])fArray, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])fArray, (int)0, (float)var1_1, (float)var2_3, (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])texData1, (int)0);
        float[] fArray4 = new float[8];
        float[] fArray5 = fArray4;
        fArray4[0] = fArray2[0];
        fArray5[1] = fArray2[1];
        fArray5[2] = fArray2[4];
        fArray5[3] = fArray2[5];
        fArray5[4] = fArray2[8];
        fArray5[5] = fArray2[9];
        fArray5[6] = fArray2[12];
        fArray5[7] = fArray2[13];
        this.mCutFaceList.add(fArray5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCutFacePoints() {
        Object object = this.maskLock;
        synchronized (object) {
            if (this.mCutFaceList != null) {
                this.mCutFaceList.clear();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRenderSize(int width, int height) {
        void var2_2;
        void var1_1;
        this.renderWidth = var1_1;
        this.renderHeight = var2_2;
    }

    @Override
    public void clearPoints() {
        super.clearPoints();
        if (this.mCutFaceList != null) {
            this.mCutFaceList.clear();
        }
    }
}

