/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.delegate.ImageDelegateProvider;
import java.util.LinkedList;

public class StickerBitmapCache {
    private static final int MAX_CACHE = 5;
    public boolean isLoadNew = false;
    protected Object imageQueenLock = new Object();
    private int readIndex;
    private LinkedList<MMFrameInfo> linkedBlockingDeque;
    private boolean running = false;
    private Sticker sticker;
    private int loopCount = 0;
    private Context context;
    private long startTime = -1L;
    private boolean startLoop = false;
    private Object waitSignal;
    private boolean pauseCache;
    private int lastIndex;
    private long renderTime = -1L;
    int i = 0;
    long now;
    long oldnow;
    int count;
    int t;
    int mRenderFRate = 20;
    long mRenderTime = -1L;
    ImageDelegateProvider imageProvider;
    Bitmap realBitmap;
    MMCVImageCacheManager cacheManager;
    MMFrameInfo oneImage;
    private String imagePath;
    private long lastFrameTime;
    private final int STICKER_MMTIME_PER_FRAME = 66;
    private int lastFrameIndex = 0;

    /*
     * WARNING - void declaration
     */
    public StickerBitmapCache(Sticker sticker, Context context, ImageDelegateProvider imageProvider) {
        void var3_4;
        void var1_1;
        this.sticker = var1_1;
        this.context = context;
        this.imageProvider = var3_4;
        this.waitSignal = new Object();
        this.linkedBlockingDeque = new LinkedList();
        this.cacheManager = new MMCVImageCacheManager(this);
        int n = 0;
        while (n < this.getMaxIndex()) {
            this.addNewIndex(context, n);
            this.readIndex = n++;
        }
        this.readIndex = 5;
        new ReadBitmapThread().start();
        this.running = true;
        this.startTime = System.currentTimeMillis();
    }

    public int getMaxIndex() {
        return Math.min(5, this.sticker.getFrameNumber());
    }

    public void addNewIndex(Context context, int index) {
        if (this.imageProvider != null) {
            return;
        }
        MMFrameInfo mMFrameInfo = this.cacheManager.getOneImageBuffer();
        if (mMFrameInfo != null) {
            ImageUtils.decodeMMCVImage((MMFrameInfo)mMFrameInfo, (String)this.imagePath);
        } else {
            mMFrameInfo = new MMFrameInfo();
            mMFrameInfo.setDataPtr(null);
        }
        this.linkedBlockingDeque.add(mMFrameInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNewBitMaps(Context context) {
        Object object = this.imageQueenLock;
        synchronized (object) {
            this.isLoadNew = true;
            int n = 0;
            if (this.readIndex + 2 < this.sticker.getFrameNumber() - 1) {
                int n2 = this.readIndex;
                while (n2 <= this.readIndex + this.getMaxIndex() / 2) {
                    this.addNewIndex(context, n2);
                    n = n2++;
                }
                this.readIndex = n + 1;
            } else {
                int n3;
                for (n3 = this.readIndex; n3 < this.sticker.getFrameNumber(); ++n3) {
                    this.addNewIndex(context, n3);
                }
                n3 = 0;
                while (n3 < 5) {
                    this.addNewIndex(context, n3);
                    n = n3++;
                }
                this.readIndex = n + 1;
            }
            this.isLoadNew = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        Object object = this.imageQueenLock;
        synchronized (object) {
            this.startTime = -1L;
            this.startLoop = false;
            this.sticker.curIndex = 0;
            this.linkedBlockingDeque.clear();
            this.realBitmap = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseCache() {
        if (this.pauseCache) {
            return;
        }
        Object object = this.imageQueenLock;
        synchronized (object) {
            this.pauseCache = true;
            this.linkedBlockingDeque.clear();
            this.realBitmap = null;
            return;
        }
    }

    public void resumeCache() {
        this.pauseCache = false;
    }

    public Bitmap getRealBitmap() {
        if (this.imageProvider != null) {
            if (this.realBitmap == null) {
                this.realBitmap = this.imageProvider.getRealBitmap();
            }
            return this.realBitmap;
        }
        return null;
    }

    public MMFrameInfo getBitmap() {
        if (this.imageProvider != null) {
            return null;
        }
        long l = System.currentTimeMillis();
        if (this.startTime == -1L) {
            this.startTime = l;
        }
        if (this.pauseCache) {
            return null;
        }
        if (this.oneImage == null) {
            this.imagePath = this.sticker.getImagePath(this.context);
            ImageUtils.decodeMMCVImage(null, (String)this.imagePath);
            this.lastFrameTime = this.mRenderTime == -1L ? l : this.mRenderTime;
        } else {
            if ((this.mRenderTime == -1L ? l - this.lastFrameTime : this.mRenderTime - this.lastFrameTime) > 66L) {
                this.imagePath = this.sticker.getImagePath(this.context);
                this.lastFrameTime = this.mRenderTime == -1L ? l : this.mRenderTime;
            }
            ImageUtils.decodeMMCVImage(null, (String)this.imagePath);
        }
        return this.oneImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.waitSignal;
        synchronized (object) {
            this.running = false;
            this.waitSignal.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void resetStickers(Sticker sticker) {
        Object object = this.imageQueenLock;
        synchronized (object) {
            void var1_1;
            this.startLoop = false;
            this.startTime = System.currentTimeMillis();
            this.linkedBlockingDeque.clear();
            this.sticker = var1_1;
            return;
        }
    }

    public void release() {
        if (this.cacheManager != null) {
            this.cacheManager.clear();
        }
        if (this.oneImage != null) {
            this.oneImage = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRenderTime(long mRenderTime) {
        void var1_1;
        this.mRenderTime = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(StickerBitmapCache x0, boolean x1) {
        void var1_1;
        x0.running = var1_1;
        return x0.running;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ LinkedList access$402(StickerBitmapCache x0, LinkedList x1) {
        void var1_1;
        x0.linkedBlockingDeque = var1_1;
        return x0.linkedBlockingDeque;
    }

    final class ReadBitmapThread
    extends Thread {
        private boolean reading = true;

        private ReadBitmapThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            StickerBitmapCache.access$102(StickerBitmapCache.this, true);
            try {
                Object object = StickerBitmapCache.this.waitSignal;
                synchronized (object) {
                    while (this.reading && StickerBitmapCache.this.running) {
                        StickerBitmapCache.this.waitSignal.wait();
                        if (!StickerBitmapCache.this.running) continue;
                        StickerBitmapCache.this.readNewBitMaps(StickerBitmapCache.this.context);
                    }
                }
                StickerBitmapCache.this.linkedBlockingDeque.clear();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.reading = false;
                return;
            }
            finally {
                StickerBitmapCache.this.linkedBlockingDeque.clear();
                StickerBitmapCache.access$402(StickerBitmapCache.this, null);
            }
        }
    }

    class MMCVImageCacheManager {
        MMFrameInfo[] cacheArray = new MMFrameInfo[5];
        int mmcvImageDataSize = 0;
        int curIndex = 0;
        int totalSize = 5;
        final /* synthetic */ StickerBitmapCache this$0;

        /*
         * WARNING - void declaration
         */
        MMCVImageCacheManager(StickerBitmapCache this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.updateImageArray();
        }

        private void updateImageArray() {
            for (int i = 0; i < this.totalSize; ++i) {
                this.cacheArray[i] = new MMFrameInfo();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setMmcvImageDataSize(int mmcvImageDataSize) {
            void var1_1;
            this.mmcvImageDataSize = var1_1;
            this.updateImageArray();
        }

        public MMFrameInfo getOneImageBuffer() {
            MMFrameInfo mMFrameInfo = this.cacheArray[this.curIndex];
            this.curIndex = (this.curIndex + 1) % this.totalSize;
            return mMFrameInfo;
        }

        public void clear() {
            if (this.cacheArray != null) {
                this.mmcvImageDataSize = 0;
            }
        }
    }
}

