/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.filtermanager.b;
import com.momo.mcamera.mask.NormalFilter;
import com.momo.mcamera.mask.bean.EffectFilterItem;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IEffectOptionsFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.model.FilterOptions;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class EffectGroupFilter
extends GroupFilter
implements FaceDetectInterface,
IVideoTrackTime {
    private final int INVALID_MODEL_TYPE = -1;
    private NormalFilter mNormalFilter = new NormalFilter();
    private BasicFilter mTerminalFilter;
    private ConcurrentHashMap<String, AbsEffectOptionFilter> mEffectFilterMap;
    private CopyOnWriteArrayList<GLRenderer> mFiltersToDestroy;
    private EffectRenderFinishListener mRenderFinishListener;

    public EffectGroupFilter() {
        this.mNormalFilter.addTarget((GLTextureInputRenderer)this);
        EffectGroupFilter effectGroupFilter = this;
        effectGroupFilter.registerInitialFilter(effectGroupFilter.mNormalFilter);
        EffectGroupFilter effectGroupFilter2 = this;
        effectGroupFilter2.registerTerminalFilter(effectGroupFilter2.mNormalFilter);
        this.mTerminalFilter = this.mNormalFilter;
        this.mFiltersToDestroy = new CopyOnWriteArrayList();
        this.mEffectFilterMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public void addEffectFilterItem(EffectFilterItem effectItem) {
        void var1_1;
        AbsEffectOptionFilter absEffectOptionFilter;
        block4: {
            block7: {
                long l;
                AbsEffectOptionFilter absEffectOptionFilter2;
                block6: {
                    block5: {
                        absEffectOptionFilter = this.mEffectFilterMap.get(effectItem.getName());
                        if (absEffectOptionFilter == null) break block4;
                        if (effectItem.getImageFolderPath() == null || !effectItem.getImageFolderPath().equals(absEffectOptionFilter.getFilterOptions().getImageFolderPath())) break block5;
                        AbsEffectOptionFilter absEffectOptionFilter3 = absEffectOptionFilter;
                        absEffectOptionFilter2 = absEffectOptionFilter3;
                        l = absEffectOptionFilter3.getDuration() - absEffectOptionFilter.getEscapedTime() + effectItem.getDuration();
                        break block6;
                    }
                    FilterOptions filterOptions = b.b(effectItem);
                    if (filterOptions == null) break block7;
                    absEffectOptionFilter.resetFilterOptions(filterOptions);
                    absEffectOptionFilter2 = absEffectOptionFilter;
                    l = effectItem.getDuration() > 0L ? effectItem.getDuration() : 99999999999L;
                }
                absEffectOptionFilter2.setDuration(l);
            }
            return;
        }
        absEffectOptionFilter = b.a(effectItem);
        if (absEffectOptionFilter == null) {
            return;
        }
        absEffectOptionFilter.setDuration(effectItem.getDuration() > 0L ? effectItem.getDuration() : 99999999999L);
        absEffectOptionFilter.getFilterOptions().setModelType(var1_1.getModelType());
        this.addTerminalFilter(absEffectOptionFilter);
        this.mEffectFilterMap.put(absEffectOptionFilter.getFilterOptions().getName(), absEffectOptionFilter);
        AbsEffectOptionFilter absEffectOptionFilter4 = absEffectOptionFilter;
        absEffectOptionFilter.setRenderFinishListener(new IEffectOptionsFilter.RenderFinishListener(this, absEffectOptionFilter4){
            final /* synthetic */ AbsEffectOptionFilter val$finalFilter;
            final /* synthetic */ EffectGroupFilter this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$finalFilter = absEffectOptionFilter;
            }

            public void onRenderFinish() {
                EffectGroupFilter.access$000(this.this$0, this.val$finalFilter);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void removeEffectFilter(AbsEffectOptionFilter filter) {
        void var1_1;
        BasicFilter basicFilter = filter.parentFilter;
        basicFilter.removeTarget((GLTextureInputRenderer)filter);
        if (this.mTerminalFilter == filter) {
            this.removeTerminalFilter((BasicFilter)filter);
            this.registerTerminalFilter(basicFilter);
            basicFilter.addTarget((GLTextureInputRenderer)this);
            this.mTerminalFilter = basicFilter;
        } else {
            this.removeFilter((BasicFilter)filter);
            BasicFilter basicFilter2 = (BasicFilter)filter.getTargets().get(0);
            filter.removeTarget((GLTextureInputRenderer)basicFilter2);
            basicFilter2.parentFilter = basicFilter;
            basicFilter.addTarget((GLTextureInputRenderer)basicFilter2);
        }
        this.mFiltersToDestroy.add((GLRenderer)filter);
        this.mEffectFilterMap.remove(var1_1.getFilterOptions().getName());
        if (this.mEffectFilterMap.size() == 0 && this.mRenderFinishListener != null) {
            this.mRenderFinishListener.onRenderFinish();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addTerminalFilter(AbsEffectOptionFilter filter) {
        void var1_1;
        this.mTerminalFilter.removeTarget((GLTextureInputRenderer)this);
        this.mTerminalFilter.addTarget((GLTextureInputRenderer)filter);
        filter.parentFilter = this.mTerminalFilter;
        EffectGroupFilter effectGroupFilter = this;
        effectGroupFilter.removeTerminalFilter(effectGroupFilter.mTerminalFilter);
        EffectGroupFilter effectGroupFilter2 = this;
        effectGroupFilter2.registerFilter(effectGroupFilter2.mTerminalFilter);
        this.mTerminalFilter = filter;
        var1_1.addTarget((GLTextureInputRenderer)this);
        EffectGroupFilter effectGroupFilter3 = this;
        effectGroupFilter3.registerTerminalFilter(effectGroupFilter3.mTerminalFilter);
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.mFiltersToDestroy.size() > 0) {
            Iterator<GLRenderer> iterator = this.mFiltersToDestroy.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
            this.mFiltersToDestroy.clear();
        }
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_2, (boolean)var3_3);
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (this.mEffectFilterMap.size() == 0) {
            return;
        }
        for (AbsEffectOptionFilter absEffectOptionFilter : this.mEffectFilterMap.values()) {
            if (!(absEffectOptionFilter instanceof FaceDetectInterface)) continue;
            ((FaceDetectInterface)absEffectOptionFilter).setMMCVInfo(mmcvInfo);
        }
    }

    public void clearWithModelType(int modelType) {
        if (this.mEffectFilterMap.size() == 0) {
            return;
        }
        for (AbsEffectOptionFilter absEffectOptionFilter : this.mEffectFilterMap.values()) {
            if (modelType != -1 && absEffectOptionFilter.getFilterOptions().getModelType() != modelType) continue;
            this.removeEffectFilter(absEffectOptionFilter);
        }
    }

    public void clearAll() {
        this.clearWithModelType(-1);
    }

    public synchronized void destroy() {
        super.destroy();
        this.mEffectFilterMap.clear();
        if (this.mFiltersToDestroy.size() > 0) {
            Iterator<GLRenderer> iterator = this.mFiltersToDestroy.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
            this.mFiltersToDestroy.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRenderFinishListener(EffectRenderFinishListener listener) {
        void var1_1;
        this.mRenderFinishListener = var1_1;
    }

    public void setTimeStamp(long ms) {
        if (this.mEffectFilterMap != null && this.mEffectFilterMap.size() > 0) {
            Iterator<AbsEffectOptionFilter> iterator = this.mEffectFilterMap.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().setTimeStamp(ms);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(EffectGroupFilter x0, AbsEffectOptionFilter x1) {
        void var1_1;
        x0.removeEffectFilter((AbsEffectOptionFilter)var1_1);
    }

    public static interface EffectRenderFinishListener {
        public void onRenderFinish();
    }
}

