/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.skin;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import project.android.imageprocessing.filter.TwoPassMultiPixelFilter;
import project.android.imageprocessing.filter.processing.GaussianBlurFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class AISkinBlurFilter
extends TwoPassMultiPixelFilter
implements FaceDetectInterface {
    private MMCVInfo mMmcvInfo;
    private float mBlurSize = 0.0f;
    private int textureId = -1;
    private int textureInId = -1;
    private int textureBeforeId = -1;
    private boolean isDiscard = false;

    /*
     * WARNING - void declaration
     */
    public AISkinBlurFilter(float _blurRadiusInPixels) {
        if (_blurRadiusInPixels >= 0.0f) {
            void var1_1;
            this.mBlurSize = (float)Math.floor(Math.sqrt(-2.0 * Math.pow(_blurRadiusInPixels, 2.0) * Math.log(0.00390625 * Math.sqrt(Math.PI * 2 * Math.pow((double)var1_1, 2.0)))));
            this.mBlurSize += this.mBlurSize % 2.0f;
        }
    }

    public void drawSub() {
        super.drawSub();
        if (this.isDiscard) {
            return;
        }
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.programHandle);
        if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
            Object object = new ArrayList<float[]>();
            for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                object.add(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104());
            }
            Object object2 = AIFaceTriangulation.getFaceTriangulationBoundingBox((float[][])object.toArray((T[])new float[this.mMmcvInfo.getMaxFaceCnt()][]), this.getWidth(), this.getHeight());
            object = object2[0];
            object2 = object2[1];
            this.passShaderValues();
            Buffer buffer = ByteBuffer.allocateDirect(((Object)object).length << 2);
            ((ByteBuffer)buffer).order(ByteOrder.nativeOrder());
            buffer = ((ByteBuffer)buffer).asFloatBuffer();
            ((FloatBuffer)buffer).put((float[])object);
            ((FloatBuffer)buffer).position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)buffer);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            object = ByteBuffer.allocateDirect(((float[][])object2).length << 2);
            ((ByteBuffer)object).order(ByteOrder.nativeOrder());
            object = ((ByteBuffer)object).asFloatBuffer();
            ((FloatBuffer)object).put((float[])object2);
            ((FloatBuffer)object).position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)object);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
        if (this.getCurrentPass() == 2) {
            this.disableDrawArray();
        }
    }

    public String getVertexShader() {
        return GaussianBlurFilter.getVertexShader((float)this.mBlurSize, (float)this.mBlurSize);
    }

    public String getFragmentShader() {
        return GaussianBlurFilter.getFragmentShader((float)this.mBlurSize, (float)this.mBlurSize);
    }

    /*
     * WARNING - void declaration
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        void var1_1;
        this.mMmcvInfo = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.textureInId != -1 && this.textureId != -1 && this.textureBeforeId != -1 && (texture != this.textureId || this.textureBeforeId != texture)) {
            this.isDiscard = true;
        }
        this.textureBeforeId = this.textureId;
        this.textureId = texture;
        this.textureInId = this.texture_in;
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_2, (boolean)var3_3);
    }
}

