/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.text.TextUtils;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.filter.CXTwoPassFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class CXFaceSkinSmoothFilter
extends CXTwoPassFilter
implements FaceDetectInterface {
    private static final String UNIFORM_EPSLONE = "epslone";
    private static final String UNIFORM_CX_SKIN_SMOOTHING_USES_MASK = "cxSkinSmoothingUsesMask";
    private static final String UNIFORM_CX_SKIN_SMOOTHING_CONSIDERS_SKIN_RELATION = "cxSkinSmoothingConsidersSkinRelation";
    private static final String UNIFORM_SAMPLE_STEP = "sampleStep";
    private static final String UNIFORM_LAND = "land";
    private static final String UNIFORM_WINSIZE = "winSize";
    private int mWinSize = 6;
    public static final int STEP_FIRST = 1;
    public static final int STEP_SECOND = 2;
    private static final int TYPE_FULL_SCREEN = 0;
    private static final int TYPE_NORMAL = 1;
    private static final int TYPE_HD = 2;
    private int[] mLowSkinThreshold = new int[]{0, 0, 0};
    private int[] mHighSkinThreshold = new int[]{255, 255, 255};
    private int[] mDefaultSkinThreshold = new int[]{160, 120, 110};
    private float mMMCVWidth = 0.0f;
    private int mCxSkinSmoothingUsesMask = 0;
    private int mCxSkinSmoothingConsidersSkinRelation = 0;
    private float[] mEpslone = new float[3];
    private float[] mSampleStep = new float[2];
    private float step = 0.0f;
    private float mFaceWidth = 0.0f;
    private int maskTexture = 0;
    private String maskPath = null;
    private int maskTextureHandle = 0;
    private int maskTexCoordHandle = 0;
    private int mDefaultSkinThresholdHandle = 0;
    private int mEpsloneHandle = 0;
    private int mCxSkinSmoothingUsesMaskHandle = 0;
    private int mCxSkinSmoothingConsidersSkinRelationHandle = 0;
    private int mSampleStepHandle = 0;
    private int mLandHandle = 0;
    private int mWinSizeHandle = 0;
    private List<SkinFaceBuffer> skinBuffers = new ArrayList<SkinFaceBuffer>(3);
    private int mType = 1;
    public int skinStep = 1;
    private int land = this.currentPass;
    private MMCVInfo mMmcvInfo;
    private float mDermabrasion = 0.0f;
    private float mEyesAreaAmount = 0.0f;
    private int textureId = -1;
    private int textureInId = -1;
    private int textureBeforeId = -1;
    private boolean isDiscard = false;

    public CXFaceSkinSmoothFilter() {
        this.init(6);
    }

    private void init(int winSize) {
        int n;
        this.mWinSize = n;
        this.mLowSkinThreshold[0] = 0;
        this.mLowSkinThreshold[1] = 0;
        this.mLowSkinThreshold[2] = 0;
        this.mHighSkinThreshold[0] = 255;
        this.mHighSkinThreshold[1] = 255;
        this.mHighSkinThreshold[2] = 255;
        for (n = 0; n < 3; ++n) {
            this.skinBuffers.add(new SkinFaceBuffer(this));
        }
    }

    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nattribute vec2 inputTextureCoordinate1;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {\n  textureCoordinate = inputTextureCoordinate;\n  textureCoordinate1 = inputTextureCoordinate1;\n   gl_Position = position;\n}\n";
    }

    protected String getFragmentShader() {
        return "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec3 skinDefaultRGB;\nuniform vec3 epslone;\nuniform int cxSkinSmoothingUsesMask;\nuniform int cxSkinSmoothingConsidersSkinRelation;\nuniform int land;\nuniform vec2 sampleStep;\nuniform int winSize;\nvoid main() {\n    mediump vec4 meanI = vec4(0., 0., 0., 0.);\n    mediump vec4 meanII = vec4(0., 0., 0., 0.);\n    mediump vec4 temp = vec4(0., 0., 0., 0.);\n    mediump vec4 sourceColor = texture2D(inputImageTexture0,textureCoordinate);\n    float eps = epslone.r;\n    if (cxSkinSmoothingUsesMask > 0) {\n            vec4 mask = texture2D(inputImageTexture1,textureCoordinate1);\n            eps = dot(epslone, vec3(mask.rgb));\n    };\n    if (cxSkinSmoothingConsidersSkinRelation > 0) {\n            vec3 relation = vec3(1.) + min((sourceColor.xyz - vec3(skinDefaultRGB)), vec3(0.0));\n            float meanrelation = dot(relation, vec3(1.0/3.0));\n            float r = 1.0 / (1.0 + exp(24.0 - 30.0 * meanrelation));\n            eps = eps * r;\n        }\n    if (eps < 0.000001) {\n         gl_FragColor = sourceColor;\n         return;\n    }\n    mediump float sumW = 0.0;\n    float xInc = sampleStep.x;\n    float yInc = sampleStep.y;\n    if(land == 1){\n    float x = textureCoordinate.x + (-float(winSize) * 0.5 * xInc);\n    float y = textureCoordinate.y;\n         int j = 0;\n         for (int i = 0; i < winSize; i++) {\n             temp = texture2D(inputImageTexture0, vec2(x + float(i) * xInc, y));\n             vec3 weightsRelation = clamp((vec3(1.0) - vec3(5.0) * abs(temp.xyz - sourceColor.xyz)), vec3(0.0), vec3(1.0));\n             mediump float weightFloat = dot(weightsRelation, vec3(1.0/3.0));\n             sumW += weightFloat;\n             meanI += weightFloat * temp;\n             meanII += weightFloat * temp * temp;\n         }\n    }else{\n    float x = textureCoordinate.x;\n    float y = textureCoordinate.y + (-float(winSize) * 0.5 * yInc);\n          int i = 0;\n          for (int j = 0; j < winSize; j++) {\n              temp = texture2D(inputImageTexture0, vec2(x, y + float(j) * yInc));\n              vec3 weightsRelation = clamp((vec3(1.0) - vec3(5.0) * abs(temp.xyz - sourceColor.xyz)), vec3(0.0), vec3(1.0));\n              mediump float weightFloat = dot(weightsRelation, vec3(1.0/3.0));\n              sumW += weightFloat;\n              meanI += weightFloat * temp;\n              meanII += weightFloat * temp * temp;\n          }\n    }\n    meanI /= sumW;\n    meanII /= sumW;\n    temp = meanII - meanI * meanI;\n    vec3 a = clamp((vec4(temp) / (vec4(temp) + vec4(vec3(eps), 1.0))), vec4(0.0), vec4(1.0)).rgb;\n    vec3 b = vec4(meanI).rgb - a * vec4(meanI).rgb;\n    gl_FragColor = vec4(a * sourceColor.rgb + b,sourceColor.a);\n}\n";
    }

    /*
     * WARNING - void declaration
     */
    private float CXSkinSmoothingEpsloneForAmount(float amount) {
        void var1_1;
        return 0.005f * amount * var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private float CXSkinSmoothingEpsloneForMaskAmount(float amount) {
        void var1_1;
        return 0.01f * amount * var1_1;
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.maskTexCoordHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)"inputTextureCoordinate1");
        this.maskTextureHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture1");
        this.mDefaultSkinThresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"skinDefaultRGB");
        this.mEpsloneHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_EPSLONE);
        this.mCxSkinSmoothingUsesMaskHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CX_SKIN_SMOOTHING_USES_MASK);
        this.mCxSkinSmoothingConsidersSkinRelationHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CX_SKIN_SMOOTHING_CONSIDERS_SKIN_RELATION);
        this.mSampleStepHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SAMPLE_STEP);
        this.mLandHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_LAND);
        this.mWinSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_WINSIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)"inputTextureCoordinate1");
    }

    private void faceDisableDrawArray() {
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glDisableVertexAttribArray((int)this.maskTexCoordHandle);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    private void facePassShaderValues() {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        if (this.mCxSkinSmoothingUsesMask > 0) {
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)this.maskTexture);
            GLES20.glUniform1i((int)this.maskTextureHandle, (int)1);
        }
        this.land = this.currentPass - 1;
        GLES20.glUniform1i((int)this.mLandHandle, (int)this.land);
        GLES20.glUniform1i((int)this.mWinSizeHandle, (int)this.mWinSize);
        GLES20.glUniform3f((int)this.mDefaultSkinThresholdHandle, (float)((float)this.mDefaultSkinThreshold[0] / 255.0f), (float)((float)this.mDefaultSkinThreshold[1] / 255.0f), (float)((float)this.mDefaultSkinThreshold[2] / 255.0f));
        GLES20.glUniform1i((int)this.mCxSkinSmoothingUsesMaskHandle, (int)this.mCxSkinSmoothingUsesMask);
        GLES20.glUniform1i((int)this.mCxSkinSmoothingConsidersSkinRelationHandle, (int)this.mCxSkinSmoothingConsidersSkinRelation);
        GLES20.glUniform3f((int)this.mEpsloneHandle, (float)this.mEpslone[0], (float)this.mEpslone[1], (float)this.mEpslone[2]);
        GLES20.glUniform2f((int)this.mSampleStepHandle, (float)this.mSampleStep[0], (float)this.mSampleStep[1]);
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.maskTexture == 0 && !TextUtils.isEmpty((CharSequence)this.maskPath)) {
            MMFrameInfo mMFrameInfo = new MMFrameInfo();
            ImageUtils.decodeMMCVImage((MMFrameInfo)mMFrameInfo, (String)this.maskPath);
            this.maskTexture = TextureHelper.bitmapToTexture((MMFrameInfo)mMFrameInfo);
        }
        if (this.textureInId != -1 && this.textureId != -1 && this.textureBeforeId != -1 && (texture != this.textureId || this.textureBeforeId != texture)) {
            this.isDiscard = true;
        }
        this.textureBeforeId = this.textureId;
        this.textureId = texture;
        this.textureInId = this.texture_in;
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            if (mmcvInfo == null) {
                return;
            }
            this.mMmcvInfo = mmcvInfo;
            this.mLowSkinThreshold[0] = 0;
            this.mLowSkinThreshold[1] = 0;
            this.mLowSkinThreshold[2] = 0;
            this.mHighSkinThreshold[0] = 255;
            this.mHighSkinThreshold[1] = 255;
            this.mHighSkinThreshold[2] = 255;
            this.mDefaultSkinThreshold[0] = 160;
            this.mDefaultSkinThreshold[1] = 120;
            this.mDefaultSkinThreshold[2] = 110;
            this.mMMCVWidth = mmcvInfo.restoreDegree % 90 == 0 && mmcvInfo.restoreDegree % 180 != 0 ? (float)mmcvInfo.height : (float)var1_1.width;
            return;
        }
    }

    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        this.facePassShaderValues();
    }

    /*
     * WARNING - void declaration
     */
    private void setParamters(int type, int skinRelation, int usesMask, float faceWidth, float amount, float eyesAreaAmount) {
        void var3_5;
        void var2_3;
        switch (type) {
            case 0: {
                this.mWinSize = 4;
                this.step = 3.0f;
                break;
            }
            case 1: {
                this.mWinSize = 10;
                this.step = 3.0f;
                break;
            }
            case 2: {
                this.mWinSize = 12;
                this.step = 1.7f;
            }
        }
        this.mCxSkinSmoothingConsidersSkinRelation = var2_3;
        this.mCxSkinSmoothingUsesMask = usesMask;
        this.mFaceWidth = faceWidth;
        float f = this.mFaceWidth / 360.0f;
        float f2 = this.step / (float)this.width * f;
        f = this.step / (float)this.height * f;
        this.mSampleStep[0] = f2;
        this.mSampleStep[1] = f;
        if (var3_5 > 0) {
            this.mEpslone[0] = this.CXSkinSmoothingEpsloneForMaskAmount(eyesAreaAmount);
            this.mEpslone[1] = this.CXSkinSmoothingEpsloneForMaskAmount(this.getNasolabialFoldAreaAmount(amount));
            this.mEpslone[2] = 0.0f;
            return;
        }
        this.mEpslone[0] = f = this.CXSkinSmoothingEpsloneForAmount(amount);
        this.mEpslone[1] = f;
        this.mEpslone[2] = f;
    }

    /*
     * WARNING - void declaration
     */
    private float getNasolabialFoldAreaAmount(float value) {
        void var1_1;
        return Math.min(0.5f, Math.max(0.0f, (float)(var1_1 - 0.5f))) * 2.0f;
    }

    public void drawSub() {
        if (this.isDiscard) {
            return;
        }
        switch (this.skinStep) {
            case 1: {
                float f = Math.min(this.mDermabrasion, 0.3f);
                this.setParamters(0, 1, 0, (float)this.getWidth() / 2.0f, f, 0.0f);
                super.drawSub();
                if (this.mMmcvInfo == null || this.mMmcvInfo.getMaxFaceCnt() <= 0) break;
                for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                    if (this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104() == null) continue;
                    float[] fArray = this.landMark104ToPoint(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight());
                    float f2 = AIFaceTriangulation.getFaceTriangulationWidth(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), (float)this.width / this.mMMCVWidth);
                    this.setParamters(this.mType, 1, 0, f2, this.mDermabrasion, this.mEyesAreaAmount);
                    this.facePassShaderValues();
                    Object object = AIFaceTriangulation.getFaceSkinHead(fArray, false);
                    float[] fArray2 = object[0];
                    float[] fArray3 = object[1];
                    object = object[2];
                    this.drawFace(fArray2, fArray3, (float[])object, this.skinBuffers.get(0));
                    this.setParamters(this.mType, 1, 0, f2, this.mDermabrasion, this.mEyesAreaAmount);
                    this.facePassShaderValues();
                    object = AIFaceTriangulation.getfaceSkinBelowHead(fArray, true);
                    fArray2 = object[0];
                    fArray3 = object[1];
                    object = object[2];
                    this.drawFace(fArray2, fArray3, (float[])object, this.skinBuffers.get(1));
                }
                return;
            }
            case 2: {
                this.setParamters(0, 1, 0, (float)this.getWidth() / 2.0f, 0.0f, 0.0f);
                super.drawSub();
                if (this.mMmcvInfo == null || this.mMmcvInfo.getMaxFaceCnt() <= 0) break;
                for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                    if (this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104() == null) continue;
                    float[] fArray = this.landMark104ToPoint(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight());
                    float f = AIFaceTriangulation.getFaceTriangulationWidth(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), (float)this.width / this.mMMCVWidth);
                    this.setParamters(this.mType, 1, 0, f, this.mDermabrasion, this.mEyesAreaAmount);
                    this.facePassShaderValues();
                    Object object = AIFaceTriangulation.getFaceSkinHead(fArray, false);
                    float[] fArray4 = object[0];
                    float[] fArray5 = object[1];
                    object = object[2];
                    this.drawFace(fArray4, fArray5, (float[])object, this.skinBuffers.get(2));
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawFace(float[] vertexCoord, float[] textureCoord, float[] sourceCoord, SkinFaceBuffer skinBuffer) {
        void var2_2;
        void var1_1;
        if (skinBuffer.byteBufVer == null) {
            SkinFaceBuffer.access$002(skinBuffer, ByteBuffer.allocateDirect(vertexCoord.length << 2));
            skinBuffer.byteBufVer.order(ByteOrder.nativeOrder());
        }
        if (skinBuffer.bufferVer == null) {
            SkinFaceBuffer.access$102(skinBuffer, skinBuffer.byteBufVer.asFloatBuffer());
        }
        skinBuffer.bufferVer.clear();
        skinBuffer.bufferVer.put((float[])var1_1);
        skinBuffer.bufferVer.flip();
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)skinBuffer.bufferVer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        if (skinBuffer.byteBufTex == null) {
            SkinFaceBuffer.access$202(skinBuffer, ByteBuffer.allocateDirect(textureCoord.length << 2));
            skinBuffer.byteBufTex.order(ByteOrder.nativeOrder());
        }
        if (skinBuffer.bufferTex == null) {
            SkinFaceBuffer.access$302(skinBuffer, skinBuffer.byteBufTex.asFloatBuffer());
        }
        skinBuffer.bufferTex.clear();
        skinBuffer.bufferTex.put(textureCoord);
        skinBuffer.bufferTex.flip();
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)skinBuffer.bufferTex);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        if (this.mCxSkinSmoothingUsesMask > 0) {
            void var3_3;
            if (skinBuffer.byteBufSource == null) {
                SkinFaceBuffer.access$402(skinBuffer, ByteBuffer.allocateDirect(textureCoord.length << 2));
                skinBuffer.byteBufSource.order(ByteOrder.nativeOrder());
            }
            if (skinBuffer.bufferSource == null) {
                SkinFaceBuffer.access$502(skinBuffer, skinBuffer.byteBufSource.asFloatBuffer());
            }
            skinBuffer.bufferSource.clear();
            skinBuffer.bufferSource.put((float[])var3_3);
            skinBuffer.bufferSource.flip();
            GLES20.glVertexAttribPointer((int)this.maskTexCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)skinBuffer.bufferSource);
            GLES20.glEnableVertexAttribArray((int)this.maskTexCoordHandle);
        }
        GLES20.glDrawArrays((int)4, (int)0, (int)(((void)var2_2).length / 2));
        this.faceDisableDrawArray();
    }

    public void destroy() {
        super.destroy();
        if (this.maskTexture != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.maskTexture;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.maskTexture = 0;
        }
    }

    public void onDrawFrame() {
        super.onDrawFrame();
    }

    /*
     * WARNING - void declaration
     */
    public void setSkinParameter(float dermabrasion, float eyesAreaAmount) {
        void var2_2;
        void var1_1;
        this.mDermabrasion = var1_1;
        this.mEyesAreaAmount = var2_2;
    }

    public String getMaskPath() {
        return this.maskPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaskPath(String maskPath) {
        void var1_1;
        this.maskPath = var1_1;
    }

    public int getType() {
        return this.mType;
    }

    /*
     * WARNING - void declaration
     */
    public void setType(int mType) {
        void var1_1;
        this.mType = var1_1;
    }

    private float[] landMark104ToPoint(float[] landmarks104, float width, float height) {
        float[] fArray = new float[landmarks104.length];
        int n = landmarks104.length;
        for (int i = 0; i < n / 2; ++i) {
            fArray[i] = landmarks104[i] / width;
            fArray[i + n / 2] = landmarks104[i + n / 2] / height;
        }
        return fArray;
    }

    public class SkinFaceBuffer {
        private ByteBuffer byteBufVer = null;
        private FloatBuffer bufferVer = null;
        private ByteBuffer byteBufTex = null;
        private FloatBuffer bufferTex = null;
        private ByteBuffer byteBufSource = null;
        private FloatBuffer bufferSource = null;
        final /* synthetic */ CXFaceSkinSmoothFilter this$0;

        /*
         * WARNING - void declaration
         */
        public SkinFaceBuffer(CXFaceSkinSmoothFilter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public String toString() {
            return "SkinFaceBuffer{byteBufVer=" + this.byteBufVer + ", bufferVer=" + this.bufferVer + ", byteBufTex=" + this.byteBufTex + ", bufferTex=" + this.bufferTex + ", byteBufSource=" + this.byteBufSource + ", bufferSource=" + this.bufferSource + '}';
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ ByteBuffer access$002(SkinFaceBuffer x0, ByteBuffer x1) {
            void var1_1;
            x0.byteBufVer = var1_1;
            return x0.byteBufVer;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ FloatBuffer access$102(SkinFaceBuffer x0, FloatBuffer x1) {
            void var1_1;
            x0.bufferVer = var1_1;
            return x0.bufferVer;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ ByteBuffer access$202(SkinFaceBuffer x0, ByteBuffer x1) {
            void var1_1;
            x0.byteBufTex = var1_1;
            return x0.byteBufTex;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ FloatBuffer access$302(SkinFaceBuffer x0, FloatBuffer x1) {
            void var1_1;
            x0.bufferTex = var1_1;
            return x0.bufferTex;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ ByteBuffer access$402(SkinFaceBuffer x0, ByteBuffer x1) {
            void var1_1;
            x0.byteBufSource = var1_1;
            return x0.byteBufSource;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ FloatBuffer access$502(SkinFaceBuffer x0, FloatBuffer x1) {
            void var1_1;
            x0.bufferSource = var1_1;
            return x0.bufferSource;
        }
    }
}

