/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import com.core.glcore.cv.MMCVInfo;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.mask.BaseSkinComposeFilter;
import com.momo.mcamera.mask.FaceSkinSmoothFilter;
import com.momo.mcamera.mask.NormalFilter;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.skin.SkinSmoothingFilter;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class SkinChooseFilter
extends BaseSkinComposeFilter {
    public static int SKIN_TYPE_SMOOTH_DEFAULT = 0;
    public static int SKIN_TYPE_SMOOTH_8_0 = 1;
    private int skinTypeSaved;
    private NormalFilter normalFilter;
    private SkinSmoothingFilter skinSmoothingFilter;
    private FaceSkinSmoothFilter faceSkinSmoothFilter;
    private boolean useOldFilter;
    private float currentLevel;

    /*
     * WARNING - void declaration
     */
    public SkinChooseFilter(boolean useOldFilter, float defaultLevel, int skinType) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.useOldFilter = useOldFilter;
        this.currentLevel = defaultLevel;
        this.skinTypeSaved = var3_3;
        if (var1_1 != false) {
            this.normalFilter = new NormalFilter();
            if (defaultLevel == 0.0f) {
                this.registerInitialFilter(this.normalFilter);
                this.registerTerminalFilter(this.normalFilter);
                this.normalFilter.addTarget((GLTextureInputRenderer)this);
                return;
            }
            this.skinSmoothingFilter = new SkinSmoothingFilter();
            this.skinSmoothingFilter.setSmoothLevel(defaultLevel);
            this.normalFilter.addTarget((GLTextureInputRenderer)this.skinSmoothingFilter);
            this.registerInitialFilter(this.normalFilter);
            this.registerTerminalFilter((BasicFilter)this.skinSmoothingFilter);
            this.skinSmoothingFilter.addTarget((GLTextureInputRenderer)this);
            return;
        }
        this.normalFilter = new NormalFilter();
        if (defaultLevel == 0.0f) {
            this.registerInitialFilter(this.normalFilter);
            this.registerTerminalFilter(this.normalFilter);
            this.normalFilter.addTarget((GLTextureInputRenderer)this);
            return;
        }
        if (this.skinTypeSaved == SKIN_TYPE_SMOOTH_DEFAULT) {
            this.faceSkinSmoothFilter = new FaceSkinSmoothFilter();
        } else if (this.skinTypeSaved == SKIN_TYPE_SMOOTH_8_0) {
            this.faceSkinSmoothFilter = new FaceSkinSmoothFilter(FaceSkinSmoothFilter.edgePassFilterVersion.transitionalGuidedFilter);
        } else {
            MDLog.e((String)"Beauty TAG", (String)"Wrong type parameters.");
        }
        this.faceSkinSmoothFilter.setSkinSmoothScale((float)var2_2);
        this.normalFilter.addTarget((GLTextureInputRenderer)this.faceSkinSmoothFilter);
        this.registerInitialFilter(this.normalFilter);
        this.registerTerminalFilter(this.faceSkinSmoothFilter);
        this.faceSkinSmoothFilter.addTarget((GLTextureInputRenderer)this);
    }

    public float getSkinLevel() {
        return this.currentLevel;
    }

    /*
     * WARNING - void declaration
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (this.faceSkinSmoothFilter != null) {
            void var1_1;
            this.faceSkinSmoothFilter.setMMCVInfo((MMCVInfo)var1_1);
        }
    }

    public synchronized void destroy() {
        super.destroy();
        if (this.normalFilter != null) {
            this.normalFilter.destroy();
        }
        if (this.faceSkinSmoothFilter != null) {
            this.faceSkinSmoothFilter.destroy();
        }
        if (this.skinSmoothingFilter != null) {
            this.skinSmoothingFilter.destroy();
        }
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.normalFilter != null) {
            this.normalFilter.releaseFrameBuffer();
        }
        if (this.faceSkinSmoothFilter != null) {
            this.faceSkinSmoothFilter.releaseFrameBuffer();
        }
        if (this.skinSmoothingFilter != null) {
            this.skinSmoothingFilter.releaseFrameBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setSmoothLevel(float skinLevel) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.useOldFilter) {
                if (skinLevel == 0.0f) {
                    if (this.currentLevel != 0.0f) {
                        this.skinSmoothingFilter.setSmoothLevel(0.0f);
                        this.skinSmoothingFilter.removeTarget((GLTextureInputRenderer)this);
                        this.normalFilter.removeTarget((GLTextureInputRenderer)this.skinSmoothingFilter);
                        this.removeTerminalFilter((BasicFilter)this.skinSmoothingFilter);
                        this.registerTerminalFilter(this.normalFilter);
                        this.normalFilter.addTarget((GLTextureInputRenderer)this);
                        this.registerFilter((BasicFilter)this.skinSmoothingFilter);
                        this.currentLevel = skinLevel;
                    }
                } else {
                    if (this.currentLevel == 0.0f) {
                        if (this.skinSmoothingFilter == null) {
                            this.skinSmoothingFilter = new SkinSmoothingFilter();
                        }
                        this.normalFilter.removeTarget((GLTextureInputRenderer)this);
                        this.normalFilter.addTarget((GLTextureInputRenderer)this.skinSmoothingFilter);
                        this.removeTerminalFilter(this.normalFilter);
                        this.registerTerminalFilter((BasicFilter)this.skinSmoothingFilter);
                        this.skinSmoothingFilter.addTarget((GLTextureInputRenderer)this);
                    }
                    this.skinSmoothingFilter.setSmoothLevel(skinLevel);
                }
                this.currentLevel = skinLevel;
            } else {
                void var1_1;
                if (skinLevel == 0.0f) {
                    if (this.currentLevel != 0.0f) {
                        this.faceSkinSmoothFilter.setSkinSmoothScale(0.0f);
                        this.faceSkinSmoothFilter.removeTarget((GLTextureInputRenderer)this);
                        this.normalFilter.removeTarget((GLTextureInputRenderer)this.faceSkinSmoothFilter);
                        this.removeTerminalFilter(this.faceSkinSmoothFilter);
                        this.registerTerminalFilter(this.normalFilter);
                        this.normalFilter.addTarget((GLTextureInputRenderer)this);
                        this.registerFilter(this.faceSkinSmoothFilter);
                        this.currentLevel = skinLevel;
                    }
                } else {
                    if (this.currentLevel == 0.0f) {
                        if (this.faceSkinSmoothFilter == null) {
                            if (this.skinTypeSaved == SKIN_TYPE_SMOOTH_DEFAULT) {
                                this.faceSkinSmoothFilter = new FaceSkinSmoothFilter();
                            } else if (this.skinTypeSaved == SKIN_TYPE_SMOOTH_8_0) {
                                this.faceSkinSmoothFilter = new FaceSkinSmoothFilter(FaceSkinSmoothFilter.edgePassFilterVersion.transitionalGuidedFilter);
                            } else {
                                MDLog.e((String)"Beauty TAG", (String)"Wrong type parameters.");
                            }
                        }
                        this.normalFilter.removeTarget((GLTextureInputRenderer)this);
                        this.normalFilter.addTarget((GLTextureInputRenderer)this.faceSkinSmoothFilter);
                        this.removeTerminalFilter(this.normalFilter);
                        this.registerTerminalFilter(this.faceSkinSmoothFilter);
                        this.faceSkinSmoothFilter.addTarget((GLTextureInputRenderer)this);
                    }
                    this.faceSkinSmoothFilter.setSkinSmoothScale(skinLevel);
                }
                this.currentLevel = var1_1;
            }
            return;
        }
    }
}

