/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.ETC1Util;
import android.opengl.GLES20;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.MultiStickerMaskFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momo.mcamera.mask.StickerCutFaceItem;
import com.momo.mcamera.mask.StickerETC1Item;
import com.momo.mcamera.mask.StickerFixItem;
import com.momo.mcamera.mask.StickerGameItem;
import com.momo.mcamera.mask.StickerHaniItem;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.util.PointHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;

public class MultiStickerCutFaceMaskFilter
extends MultiStickerMaskFilter {
    public static final String UNIFORM_BACKGROUND = "bgFlag";
    private float mRadius = 100.0f;
    private PointF mPointF;
    private int mBackGroundHandler;
    private StickerCutFaceItem mCutFaceItem = null;
    private boolean lastHasFace = false;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4   position3 ; varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nuniform mediump float etc1Flag;\nuniform mediump float bgFlag;\nvoid main() {  gl_Position = position;  vec2 coord = position2.xy;  if(bgFlag > 0.5){\n     textureCoordinate = position2.xy;\n     return;\n  }\n  if(etc1Flag > 0.5){\n    vec2 coord1 = position3.xy;    textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0-(coord1.y + 0.5));\n  }else{\n    coord = (coord) / decorationSize;\n   }\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";

    /*
     * WARNING - void declaration
     */
    public MultiStickerCutFaceMaskFilter(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addSticker(Sticker sticker, StickerBlendFilter.StickerStateChangeListener listener) {
        if (sticker != null) {
            void var1_1;
            void var2_2;
            StickerItem stickerItem;
            if (sticker.getEtcTextureBatch() != null) {
                stickerItem = new StickerETC1Item(sticker, this.context);
            } else if (sticker.isGameSticker) {
                stickerItem = new StickerGameItem(sticker, this.context);
            } else if (sticker.isCutFaceSticker) {
                this.mCutFaceItem = new StickerCutFaceItem(sticker, this.context);
                stickerItem = this.mCutFaceItem;
            } else {
                stickerItem = sticker.getStickerType() == "STICKER_TYPE_GAME_FIX_TYPE" ? new StickerFixItem(sticker, this.context) : (sticker.isHaniSticker ? new StickerHaniItem(sticker, this.context) : new StickerItem(sticker, this.context));
            }
            stickerItem.setStickerStateChangeListener((StickerBlendFilter.StickerStateChangeListener)var2_2);
            stickerItem.mStickerDuration = sticker.getDuration() > 0L ? var1_1.getDuration() : 30000000L;
            this.addSticker(stickerItem);
        }
    }

    @Override
    public void setTimeStamp(long ms) {
        for (StickerItem stickerItem : this.stickerItemList) {
            if (!(stickerItem instanceof StickerHaniItem)) continue;
            stickerItem.setRenderTime(ms);
        }
    }

    @Override
    public void drawBackgroundImage() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)1.0f);
        super.setUseETC1(false);
        if (this.textureCoord == null) {
            this.textureCoord = new float[8];
        }
        this.textureVertices[this.curRotation].position(0);
        this.textureVertices[this.curRotation].get(this.textureCoord);
        if (this.vertexBufer == null) {
            this.vertexBufer = ByteBuffer.allocateDirect(this.textureCoord.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        this.vertexBufer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glUniform1f((int)this.mBackGroundHandler, (float)1.0f);
        if (this.mCutFaceItem != null) {
            this.drawCutBgBackGround();
        } else {
            this.vertexBufer.position(0);
            this.vertexBufer.put(this.textureCoord);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
        GLES20.glUniform1f((int)this.mBackGroundHandler, (float)0.0f);
    }

    private void drawCutBgBackGround() {
        if (this.mCutFaceItem.mCutFaceList != null && this.mCutFaceItem.mCutFaceList.size() > 0) {
            for (Object object : this.mCutFaceItem.mCutFaceList) {
                this.setRenderVertices((float[])object);
                this.renderVertices.position(0);
                GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
                GLES20.glEnableVertexAttribArray((int)this.positionHandle);
                object = new PointF(this.mPointF.x - this.mRadius, (float)this.getHeight() - (this.mPointF.y + this.mRadius));
                PointF pointF = new PointF(this.mPointF.x + this.mRadius, (float)this.getHeight() - (this.mPointF.y - this.mRadius));
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    this.textureCoord[0] = object.x / (float)this.getWidth();
                    this.textureCoord[1] = object.y / (float)this.getHeight();
                    this.textureCoord[2] = pointF.x / (float)this.getWidth();
                    this.textureCoord[3] = object.y / (float)this.getHeight();
                    this.textureCoord[4] = object.x / (float)this.getWidth();
                    this.textureCoord[5] = pointF.y / (float)this.getHeight();
                    this.textureCoord[6] = pointF.x / (float)this.getWidth();
                    this.textureCoord[7] = pointF.y / (float)this.getHeight();
                }
                this.vertexBufer.position(0);
                this.vertexBufer.put(this.textureCoord);
                this.vertexBufer.position(0);
                GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufer);
                GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
                this.lastHasFace = true;
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
            }
            this.mCutFaceItem.clearCutFacePoints();
            return;
        }
        this.resetBackgroundCanvas();
        this.vertexBufer.position(0);
        this.vertexBufer.put(this.textureCoord);
        if (this.lastHasFace) {
            this.lastHasFace = false;
            return;
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mBackGroundHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BACKGROUND);
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo == null) {
            return;
        }
        this.lastStickerTime = System.currentTimeMillis();
        if (mmcvInfo.getMaxFaceCnt() <= 0) {
            this.updateFaceInfo(mmcvInfo, 0.0f, null, false);
            return;
        }
        if (this.mCutFaceItem != null && mmcvInfo.getMaxFaceCnt() > 0) {
            float[] fArray = mmcvInfo.getFaceAttributeInfo(0).getLandmarks68();
            PointF pointF = new PointF(fArray[18], fArray[86]);
            PointF pointF2 = new PointF(fArray[10], fArray[78]);
            this.mRadius = (float)PointHelper.a(pointF, pointF2);
            this.mRadius = this.mRadius * 1.1f / 2.0f;
            this.mPointF = new PointF(fArray[29], fArray[97]);
        }
        for (int i = mmcvInfo.getMaxFaceCnt() - 1; i >= 0; --i) {
            float f = mmcvInfo.getFaceAttributeInfo(i).getFaceRotateDegree_2d();
            if (this.mCutFaceItem != null) {
                this.mCutFaceItem.setRenderSize(this.getWidth(), this.getHeight());
            }
            this.updateFaceInfo(mmcvInfo, f, mmcvInfo.getFaceAttributeInfo(i).getLandmarks68(), true);
        }
    }

    @Override
    public void removeSticker(String stickerType) {
        for (StickerItem stickerItem : this.stickerItemList) {
            if (stickerItem == this.mCutFaceItem) {
                this.mCutFaceItem = null;
                this.resetBackgroundCanvas();
            }
            if (!stickerItem.sticker.getStickerType().equals(stickerType)) continue;
            this.stickerItemDestroyList.add(stickerItem);
        }
    }

    @Override
    protected String getVertexShader() {
        return this.vertexShaderCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawSub() {
        Object object;
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        GLES20.glClear((int)16640);
        this.drawBackgroundImage();
        GLES20.glEnable((int)3042);
        GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        if (this.stickerItemDestroyList.size() > 0) {
            Iterator iterator = new ArrayList(this.stickerItemDestroyList);
            Object object2 = iterator.iterator();
            while (object2.hasNext()) {
                object = (StickerItem)object2.next();
                ((StickerItem)object).destroy();
                this.stickerItemDestroyList.remove(object);
                this.stickerItemList.remove(object);
            }
            iterator.clear();
        }
        for (Object object2 : this.stickerItemList) {
            if (!(object2 instanceof StickerCutFaceItem) || ((StickerItem)object2).getMmcvImage(this.context) != null) continue;
            return;
        }
        for (Object object2 : this.stickerItemList) {
            object = ((StickerItem)object2).getLockObject();
            synchronized (object) {
                Object object3;
                Object object4;
                boolean bl = false;
                ((StickerItem)object2).imageWidth = this.getWidth();
                ((StickerItem)object2).imageHeight = this.getHeight();
                if (((StickerItem)object2).mvpLists != null && ((StickerItem)object2).mvpLists.size() > 0 && ((StickerItem)object2).isDraw) {
                    if (object2 instanceof StickerETC1Item) {
                        object4 = (StickerETC1Item)object2;
                        bl = true;
                        if (((StickerETC1Item)object4).etc1_texture_sticker == 0) {
                            ((StickerETC1Item)object4).etc1_texture_sticker = TextureHelper.etc1ToTexture((ETC1Util.ETC1Texture)((StickerETC1Item)object4).texture);
                        }
                        ((StickerETC1Item)object4).updateETC1Coordinate();
                    } else {
                        object4 = ((StickerItem)object2).getMmcvImage(this.context);
                        if (object4 != null && object4.getDataPtr() != null) {
                            ((StickerItem)object2).texture_sticker = ((StickerItem)object2).texture_sticker == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)object4) : TextureHelper.loadDataToTexture((int)((StickerItem)object2).texture_sticker, (MMFrameInfo)object4);
                        } else {
                            object3 = ((StickerItem)object2).getBitmap();
                            if (object3 != null && !object3.isRecycled()) {
                                if (((StickerItem)object2).texture_sticker > 0) {
                                    TextureHelper.updateBitmap((Bitmap)object3, (int)((StickerItem)object2).texture_sticker);
                                } else {
                                    ((StickerItem)object2).texture_sticker = TextureHelper.bitmapToTexture((Bitmap)object3);
                                }
                            }
                        }
                    }
                } else {
                    ((StickerItem)object2).sticker.curIndex = 0;
                }
                if (((StickerItem)object2).isDraw && (((StickerItem)object2).texture_sticker != 0 || bl)) {
                    object4 = ((StickerItem)object2).mvpLists.iterator();
                    while (object4.hasNext()) {
                        object3 = (float[])object4.next();
                        this.passStickerShaderValues((StickerItem)object2, (float[])object3);
                        this.drawStick(((StickerItem)object2).getStickerAspectRatio());
                    }
                    ((StickerItem)object2).clearPoints();
                }
            }
        }
        GLES20.glDisable((int)3042);
    }

    private void resetBackgroundCanvas() {
        this.setRenderVertices(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    }
}

