/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.graphics.PointF;
import android.graphics.RectF;
import android.text.TextUtils;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.MaskModel;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momocv.MMBox;

public class FilterTriggerManager {
    public static final int TRIGER_MOUSE = 1;
    public static final int TRIGER_LEFT_EYE = 8;
    public static final int TRIGER_LEFT_EYE_BLINK = 16;
    public static final int TRIGER_RIGHT_EYE = 64;
    public static final int TRIGER_RIGHT_EYE_BLINK = 128;
    public static final int TRIGER_EYE_BLINK = 256;
    public static final int TRIGER_SMILE = 512;
    public static final int TRIGER_DUCK_FACE = 1024;
    public static final int TRIGER_CLICK = 2048;
    public static final int STATE_OPEN = 0;
    public static final int STATE_CLOSE = 1;
    private static int INDEX_FACE_LEFT = 0;
    private static int INDEX_FACE_RIGHT = 16;
    private static int INDEX_MOUSE_UP = 62;
    private static int INDEX_MOUSE_DOWN = 66;
    public int mouseOpenState = 1;
    public int leftEyeBlinkState = 1;
    public int leftEyeBlinkCount = 0;
    public int eyeBlinkState = 1;
    public int eyeBlinkCount = 0;
    public int rightEyeBlinkState = 0;
    public int rightEyeBlinkCount = 0;
    public int leftEyeOpenState = 0;
    public int rightEyeOpenState = 0;
    public int expressionState = -1;
    public int smileState = 1;
    public int duckFaceState = 1;
    public float leftEyeOpenAmount = 1.0f;
    public float rightEyeOpenAmount = 1.0f;
    private int flag = -1;
    private int hiddenFlag = -1;
    private int faceIndex = 0;

    /*
     * WARNING - void declaration
     */
    public static boolean isTriggerRegionMatches(MMCVBoxes mmcvBoxes, String triggerType, MaskModel model, int width, int height) {
        boolean bl = true;
        if (null != model.getTriggerRegion() && model.getTriggerRegion().length == 3) {
            void var3_6;
            void var2_5;
            MMCVBoxes objectArray;
            PointF pointF = null;
            if (mmcvBoxes.getDetectResult() == null || mmcvBoxes.getDetectResult().length == 0) {
                return false;
            }
            for (MMBox mMBox : objectArray.getDetectResult()) {
                if (!triggerType.equals(mMBox.class_name_)) continue;
                RectF rectF = new RectF((float)mMBox.x_, (float)mMBox.y_, (float)(mMBox.x_ + mMBox.width_), (float)(mMBox.y_ + mMBox.height_));
                pointF = new PointF(rectF.centerX(), rectF.centerY());
            }
            if (pointF == null) {
                return false;
            }
            int[] nArray = var2_5.getTriggerRegion();
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            float f = (float)(var3_6 / n);
            float f2 = (float)(height / n);
            bl = new RectF((float)(n3 % n) * f, (float)(n3 / n2) * f2, (float)(n3 % n) * f + f, (float)(n3 / n2) * f2 + f2).contains(pointF.x, pointF.y);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void setTriggerType(int permission) {
        void var1_1;
        if (this.flag == -1) {
            this.flag = permission;
            return;
        }
        this.enable((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void enable(int permission) {
        void var1_1;
        this.flag |= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void disable(int permission) {
        void var1_1;
        this.flag &= ~var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isContain(int permission) {
        void var1_1;
        return (this.flag & permission) == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setHiddenTriggerType(int permission) {
        void var1_1;
        if (this.hiddenFlag == -1) {
            this.hiddenFlag = permission;
            return;
        }
        this.hiddenEnable((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void hiddenEnable(int permission) {
        void var1_1;
        this.hiddenFlag |= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void hiddenDisable(int permission) {
        void var1_1;
        this.hiddenFlag &= ~var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isHiddenContain(int permission) {
        void var1_1;
        return (this.hiddenFlag & permission) == var1_1;
    }

    public void adjustStateBy(MMCVInfo mmcvInfo) {
        FaceAttributeInfo faceAttributeInfo;
        if (mmcvInfo == null) {
            return;
        }
        if (this.faceIndex >= mmcvInfo.getMaxFaceCnt()) {
            this.faceIndex = 0;
        }
        if ((faceAttributeInfo = faceAttributeInfo.getFaceAttributeInfo(this.faceIndex)) != null) {
            if (this.isContain(1) || this.isHiddenContain(1)) {
                this.updateMouseState(faceAttributeInfo.getLandmarks68());
            }
            if (this.isContain(1024) || this.isContain(512) || this.isHiddenContain(1024) || this.isHiddenContain(512)) {
                this.smileState = 1;
                this.duckFaceState = 1;
                if (faceAttributeInfo.getExpression() == 1) {
                    this.duckFaceState = 0;
                } else if (faceAttributeInfo.getExpression() == 2) {
                    this.smileState = 0;
                }
            }
            if (this.isContain(8) || this.isContain(64) || this.isContain(16) || this.isContain(128) || this.isHiddenContain(8) || this.isHiddenContain(64) || this.isHiddenContain(256) || this.isHiddenContain(16) || this.isHiddenContain(128)) {
                this.updateEyeState(faceAttributeInfo);
            }
            if (this.isContain(16) || this.isContain(128) || this.isContain(256) || this.isHiddenContain(16) || this.isHiddenContain(128)) {
                if (this.rightEyeOpenState == 0 && this.leftEyeOpenState == 1) {
                    ++this.leftEyeBlinkCount;
                    this.leftEyeBlinkState = this.leftEyeBlinkCount > 1 ? 0 : 1;
                } else {
                    this.leftEyeBlinkCount = 0;
                    this.leftEyeBlinkState = 1;
                }
                if (this.rightEyeOpenState == 1 && this.leftEyeOpenState == 0) {
                    ++this.rightEyeBlinkCount;
                    this.rightEyeBlinkState = this.rightEyeBlinkCount > 1 ? 0 : 1;
                } else {
                    this.rightEyeBlinkCount = 0;
                    this.rightEyeBlinkState = 1;
                }
                if (this.rightEyeOpenState == 1 || this.leftEyeOpenState == 1) {
                    ++this.eyeBlinkCount;
                    if (this.eyeBlinkCount > 1) {
                        this.eyeBlinkState = 0;
                        return;
                    }
                    this.eyeBlinkState = 1;
                    return;
                }
                this.eyeBlinkCount = 0;
                this.eyeBlinkState = 1;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateEyeState(FaceAttributeInfo faceAttributeInfo) {
        void var1_1;
        this.leftEyeOpenAmount = faceAttributeInfo.getLeftEyeCloseProb();
        this.rightEyeOpenAmount = var1_1.getRightEyeCloseProb();
        this.leftEyeOpenState = (double)this.leftEyeOpenAmount >= 0.7 ? 1 : 0;
        if ((double)this.rightEyeOpenAmount >= 0.7) {
            this.rightEyeOpenState = 1;
            return;
        }
        this.rightEyeOpenState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void updateMouseState(float[] points) {
        block3: {
            block4: {
                float f;
                float f2;
                block2: {
                    void var1_1;
                    if (points == null) {
                        return;
                    }
                    f2 = points[INDEX_FACE_LEFT];
                    float f3 = points[INDEX_FACE_LEFT + 68];
                    float f4 = points[INDEX_FACE_RIGHT];
                    float f5 = points[INDEX_FACE_RIGHT + 68];
                    float f6 = points[INDEX_MOUSE_DOWN];
                    float f7 = points[INDEX_MOUSE_DOWN + 68];
                    float f8 = points[INDEX_MOUSE_UP];
                    f = var1_1[INDEX_MOUSE_UP + 68];
                    f2 = (float)Math.hypot(f2 - f4, f3 - f5);
                    f = (float)Math.hypot(f8 - f6, (double)(f - f7));
                    if (this.mouseOpenState != 0) break block2;
                    if (!((double)f < (double)f2 / 14.0)) break block3;
                    break block4;
                }
                if (f > f2 / 10.0f) {
                    this.mouseOpenState = 0;
                    return;
                }
            }
            this.mouseOpenState = 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean triggerTypeProcess(Sticker sticker, StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener) {
        int n;
        int n2 = 1;
        if (sticker.getTriggerType() > 0) {
            sticker.setTriggerState(this.getTriggerStateByTriggerType(sticker.getTriggerType()));
            if (stickerStateChangeListener != null) {
                stickerStateChangeListener.stickerStateChanged(sticker.getTriggerType(), this.getTriggerStateByTriggerType(sticker.getTriggerType()));
            }
            n2 = sticker.getTriggerState() == 1 ? 0 : 1;
        }
        if ((n = sticker.getHiddenTriggerType()) > 0) {
            void var1_1;
            n2 = this.getTriggerStateByTriggerType(n);
            sticker.setTriggerState(n2);
            if (stickerStateChangeListener != null) {
                void var2_2;
                var2_2.stickerStateChanged(sticker.getTriggerType(), this.getTriggerStateByTriggerType(sticker.getTriggerType()));
            }
            n2 = n == 8 || n == 64 ? (sticker.getTriggerState() == 0 ? 1 : 0) : (var1_1.getTriggerState() != 0 ? 1 : 0);
        }
        return n2 != 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean objectTriggerTypeProcess(Sticker sticker, FaceDetectFilter.FaceDetectParam param, boolean isTriggered) {
        MMBox mMBox3;
        MMBox[] mMBoxArray;
        boolean bl = true;
        String string = sticker.getHiddenObjectTriggerType();
        if (!TextUtils.isEmpty((CharSequence)string) && param.mmcvBoxes != null && param.mmcvBoxes.getDetectResult() != null) {
            mMBoxArray = param.mmcvBoxes.getDetectResult();
            int n = mMBoxArray.length;
            for (int i = 0; i < n; ++i) {
                MMBox mMBox2 = mMBoxArray[i];
                if (!string.equals(mMBox2.class_name_)) continue;
                return false;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(mMBoxArray = mMBox3.getObjectTriggerType()))) {
            void var2_2;
            if (mMBoxArray.equals("game_over")) {
                void var3_3;
                bl = var3_3;
            } else if (param.mmcvBoxes != null && param.mmcvBoxes.getDetectResult() != null && param.mmcvBoxes.getDetectResult().length > 0) {
                for (MMBox mMBox3 : param.mmcvBoxes.getDetectResult()) {
                    if (!mMBoxArray.equals(mMBox3.class_name_)) continue;
                    return true;
                }
                bl = false;
            } else if (var2_2.gestureRect == null) {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int getTriggerStateByTriggerType(int triggerType) {
        void var1_1;
        int n = this.mouseOpenState;
        switch (var1_1) {
            case 1: {
                n = this.mouseOpenState;
                break;
            }
            case 8: {
                n = this.leftEyeOpenState;
                break;
            }
            case 64: {
                n = this.rightEyeOpenState;
                break;
            }
            case 128: {
                n = this.rightEyeBlinkState;
                break;
            }
            case 16: {
                n = this.leftEyeBlinkState;
                break;
            }
            case 256: {
                n = this.eyeBlinkState;
                break;
            }
            case 512: {
                n = this.smileState;
                break;
            }
            case 1024: {
                n = this.duckFaceState;
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void setTriggerFaceIndex(int faceIndex) {
        void var1_1;
        this.faceIndex = var1_1;
    }
}

