/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.text.TextUtils;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class CXSkinWhiteningFilter
extends BasicFilter {
    private static final String UNIFORM_ALPHA = "alpha";
    private static final String UNIFORM_LEVEL_BLACK = "levelBlack";
    private static final String UNIFORM_LEVEL_RANGE_INV = "levelRangeInv";
    private int alphaHandle = 0;
    private int levelBlackHandle = 0;
    private int levelRangeInvHandle = 0;
    private int mTextureHandle1 = 0;
    private int mTextureHandle2 = 0;
    private boolean isInit = false;
    private float alpha = 0.0f;
    private float levelBlack = 0.0f;
    private float levelRangeInv = 1.0f;
    private int mEnhancementCurveTexture = 0;
    private int mEnhancementLookupTexture = 0;
    private String mEnhancementCurvePath = null;
    private String mEnhancementLookupPath = null;

    /*
     * WARNING - void declaration
     */
    public void setImagepath(List<String> paths) {
        void var1_1;
        if (paths == null || paths.isEmpty()) {
            return;
        }
        this.mEnhancementCurvePath = paths.get(0);
        this.mEnhancementLookupPath = (String)var1_1.get(1);
        this.isInit = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setAlpha(float alphaValue) {
        void var1_1;
        this.alpha = var1_1;
    }

    protected String getFragmentShader() {
        return "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nuniform float levelBlack;\nuniform float levelRangeInv;\nuniform float alpha;\nvoid main() {\n    vec3 colorOrigin = texture2D(inputImageTexture0,textureCoordinate).rgb;\n    vec3 color = clamp((colorOrigin - vec3(levelBlack)) * levelRangeInv, 0.0, 1.0);\n    vec3 texel;\n    texel.r = texture2D(inputImageTexture2, vec2((color.r * 255.0 + 0.5) / 256.0, 0.5)).r;\n    texel.g = texture2D(inputImageTexture2, vec2((color.g * 255.0 + 0.5) / 256.0, 0.5)).g;\n    texel.b = texture2D(inputImageTexture2, vec2((color.b * 255.0 + 0.5) / 256.0, 0.5)).b;\n    texel = mix(color, texel, 0.5);\n    texel = mix(colorOrigin, texel, alpha);\n    \n    float blueColor = texel.b * 15.0;\n    vec2 quad1, quad2;\n    quad1.y = floor(floor(blueColor) * 0.25);\n    quad1.x = floor(blueColor) - (quad1.y * 4.0);\n    quad2.y = floor(ceil(blueColor) * 0.25);\n    quad2.x = ceil(blueColor) - (quad2.y * 4.0);\n    vec2 texPos2, texPos1;\n    texPos2 = texel.rg * 0.234375 + 0.0078125;\n    texPos1 = quad1 * 0.25 + texPos2;\n    texPos2 = quad2 * 0.25 + texPos2;\n    vec4 newColor1 = texture2D(inputImageTexture1, texPos1);\n    vec4 newColor2 = texture2D(inputImageTexture1, texPos2);\n    color = mix(newColor1.rgb, newColor2.rgb, fract(blueColor));\n    color = mix(texel, color, 0.75);\n    gl_FragColor = vec4(mix(colorOrigin, color, alpha), 1.0);\n}";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mTextureHandle1 = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture1");
        this.mTextureHandle2 = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture2");
        this.alphaHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ALPHA);
        this.levelBlackHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_LEVEL_BLACK);
        this.levelRangeInvHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_LEVEL_RANGE_INV);
    }

    protected void passShaderValues() {
        super.passShaderValues();
        if (!this.isInit) {
            return;
        }
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.mEnhancementLookupTexture);
        GLES20.glUniform1i((int)this.mTextureHandle1, (int)1);
        GLES20.glActiveTexture((int)33986);
        GLES20.glBindTexture((int)3553, (int)this.mEnhancementCurveTexture);
        GLES20.glUniform1i((int)this.mTextureHandle2, (int)2);
        GLES20.glUniform1f((int)this.alphaHandle, (float)this.alpha);
        GLES20.glUniform1f((int)this.levelBlackHandle, (float)this.levelBlack);
        GLES20.glUniform1f((int)this.levelRangeInvHandle, (float)this.levelRangeInv);
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var2_2;
        void var1_1;
        MMFrameInfo mMFrameInfo;
        if (this.mEnhancementCurveTexture == 0 && !TextUtils.isEmpty((CharSequence)this.mEnhancementLookupPath)) {
            mMFrameInfo = new MMFrameInfo();
            ImageUtils.decodeMMCVImage((MMFrameInfo)mMFrameInfo, (String)this.mEnhancementCurvePath);
            this.mEnhancementCurveTexture = TextureHelper.bitmapToTexture((MMFrameInfo)mMFrameInfo);
        }
        if (this.mEnhancementLookupTexture == 0 && !TextUtils.isEmpty((CharSequence)this.mEnhancementLookupPath)) {
            mMFrameInfo = new MMFrameInfo();
            ImageUtils.decodeMMCVImage((MMFrameInfo)mMFrameInfo, (String)this.mEnhancementLookupPath);
            this.mEnhancementLookupTexture = TextureHelper.bitmapToTexture((MMFrameInfo)mMFrameInfo);
        }
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_2, (boolean)var3_3);
    }
}

