/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.beauty;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.cosmos.mdlog.MDLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.filter.BasicFilter;

public class DrawFaceFilter
extends BasicFilter
implements FaceDetectInterface {
    float[] faceRec = null;
    float[][] facePos96 = null;
    float[][] facePos68 = null;
    float[][] facePos104 = null;
    float[][] facePos137 = null;
    public static final int FACE_TYPE_68 = 0;
    public static final int FACE_TYPE_96 = 1;
    public static final int FACE_TYPE_104 = 2;
    public static final int FACE_TYPE_137 = 3;
    private int faceType = 0;
    FloatBuffer floatBuffer;
    FloatBuffer floatBufFace68;
    FloatBuffer floatBufFace96;
    FloatBuffer floatBufFace104;
    FloatBuffer floatBufFace137;
    private int colorHandle = 0;

    /*
     * WARNING - void declaration
     */
    public void setFaceType(int faceType) {
        void var1_1;
        this.faceType = var1_1;
    }

    private void updateFaceInfo(MMCVInfo info) {
        int n = info.getMaxFaceCnt();
        if (n <= 0) {
            MDLog.d((String)"mediaRender", (String)"No face");
            return;
        }
        if (this.facePos68 == null || n != this.facePos68.length) {
            this.facePos68 = new float[n][136];
            this.facePos96 = new float[n][192];
            this.facePos104 = new float[n][208];
            this.facePos137 = new float[n][274];
        }
        for (int i = 0; i < n; ++i) {
            Object object = info.getFaceAttributeInfo(i);
            if (object == null) continue;
            float[] fArray = object.getLandmarks68();
            object = fArray;
            if (fArray != null) {
                this.adjustCoordnate(this.facePos68[i], (float[])object);
            }
            float[] fArray2 = info.getFaceAttributeInfo(i).getLandmarks96();
            object = fArray2;
            if (fArray2 != null) {
                this.adjustCoordnate(this.facePos96[i], (float[])object);
            }
            float[] fArray3 = info.getFaceAttributeInfo(i).getLandmarks104();
            object = fArray3;
            if (fArray3 != null) {
                this.adjustCoordnate(this.facePos104[i], (float[])object);
            }
            float[] fArray4 = info.getFaceAttributeInfo(i).getLandmarks137();
            object = fArray4;
            if (fArray4 == null) continue;
            this.adjustCoordnate(this.facePos137[i], (float[])object);
        }
    }

    private void adjustCoordnate(float[] coord, float[] src) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (coord != null && coord.length > 0 && src != null && src.length > 0) {
            for (int i = 0; i < coord.length / 2; ++i) {
                coord[i << 1] = 2.0f * (src[i] / (float)n - 0.5f);
                coord[(i << 1) + 1] = -2.0f * (src[i + coord.length / 2] / (float)n2 - 0.5f);
            }
            return;
        }
        MDLog.d((String)"mediaRender", (String)"No face Info or buffer is empty");
    }

    /*
     * WARNING - void declaration
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo != null) {
            void var1_1;
            float[][] fArray = mmcvInfo.getFaceRects();
            if (fArray != null && fArray.length > 0 && fArray[0] != null) {
                this.faceRec = fArray[0];
            }
            this.updateFaceInfo((MMCVInfo)var1_1);
        }
    }

    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1i((int)this.colorHandle, (int)1);
    }

    public void drawSub() {
        super.drawSub();
        try {
            GLES20.glUniform1i((int)this.colorHandle, (int)0);
            if (this.faceRec == null || this.faceRec.length <= 0) {
                MDLog.e((String)"mediaRender", (String)"Render no face!");
                return;
            }
            GLES20.glClearColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f = 2.0f * (this.faceRec[0] / (float)this.getWidth() - 0.5f);
            float f2 = -2.0f * (this.faceRec[1] / (float)this.getHeight() - 0.5f);
            float f3 = 2.0f * (this.faceRec[2] / (float)this.getWidth() - 0.5f);
            float f4 = -2.0f * (this.faceRec[3] / (float)this.getHeight() - 0.5f);
            Object object = new float[]{f, f2, f, f4, f, f4, f3, f4, f3, f4, f3, f2, f, f2, f3, f2};
            if (this.floatBuffer == null || this.floatBuffer.capacity() != 16) {
                this.floatBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
            }
            this.floatBuffer.put((float[])object);
            this.floatBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.floatBuffer);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            GLES20.glLineWidth((float)2.0f);
            GLES20.glDrawArrays((int)1, (int)0, (int)8);
            this.floatBufFace68 = this.putDataToFloatBuffer(this.floatBufFace68, this.facePos68);
            this.floatBufFace96 = this.putDataToFloatBuffer(this.floatBufFace96, this.facePos96);
            this.floatBufFace104 = this.putDataToFloatBuffer(this.floatBufFace104, this.facePos104);
            this.floatBufFace137 = this.putDataToFloatBuffer(this.floatBufFace137, this.facePos137);
            object = null;
            switch (this.faceType) {
                case 0: {
                    object = this.floatBufFace68;
                    break;
                }
                case 1: {
                    object = this.floatBufFace96;
                    break;
                }
                case 2: {
                    object = this.floatBufFace104;
                    break;
                }
                case 3: {
                    object = this.floatBufFace137;
                }
            }
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)object);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            GLES20.glDrawArrays((int)0, (int)0, (int)(((Buffer)object).capacity() / 2));
            this.disableDrawArray();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private FloatBuffer putDataToFloatBuffer(FloatBuffer floatBuffer, float[][] faceInfo) {
        void var1_1;
        if (faceInfo.length <= 0) {
            floatBuffer.position(0);
            return floatBuffer;
        }
        if (floatBuffer == null) {
            floatBuffer = ByteBuffer.allocateDirect((faceInfo.length << 2) * faceInfo[0].length).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        for (int i = 0; i < faceInfo.length; ++i) {
            if (faceInfo[i] == null || faceInfo[i].length <= 0) continue;
            floatBuffer.put(faceInfo[i], i * faceInfo[i].length, faceInfo[i].length);
        }
        floatBuffer.position(0);
        return var1_1;
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.colorHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"color");
    }

    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform int color;\nvarying vec2 textureCoordinate;\nvoid main(){\n if(color == 1){   gl_FragColor = texture2D(inputImageTexture0,textureCoordinate);\n }else{   gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);\n }}\n";
    }

    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvoid main() {\n  textureCoordinate = inputTextureCoordinate;\n gl_PointSize = 3.0;   gl_Position = position;\n}\n";
    }
}

