/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.MmcvImageCacheLoader;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.delegate.ImageDelegateProvider;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class StickerMaskFilter
extends FaceDetectFilter
implements IVideoTrackTime {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    static final int COORDS_PER_VERTEX = 2;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   gl_FragColor = color1;\n}";
    protected final float[] mProjectionMatrix = new float[16];
    protected final float[] mViewMatrix = new float[16];
    private final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final int vertexStride = 8;
    protected Object maskListLock = new Object();
    float[] color = new float[]{0.2f, 0.70980394f, 0.8980392f, 1.0f};
    float[] color2 = new float[]{0.0f, 0.20980392f, 0.19803922f, 1.0f};
    int textId;
    float stickerScale;
    float[] mvpMatrix;
    float[] texData0;
    List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    protected Sticker sticker;
    private MmcvImageCacheLoader mmcvImageLoader;
    private Context context;
    private FloatBuffer vertexBuffer;
    private FloatBuffer fvertexBuffer;
    private ShortBuffer drawListBuffer;
    private int decorateHandler;
    private int mVPMatrixHandler;
    protected int positionHandle2;
    private boolean isDraw;
    private boolean lockTexture = false;
    private boolean isPlaying;
    private String imagePath;

    /*
     * WARNING - void declaration
     */
    public StickerMaskFilter(Context context, Sticker sticker, ImageDelegateProvider imageDelegateProvider) {
        ByteBuffer byteBuffer;
        void var2_2;
        this.sticker = sticker;
        this.context = context;
        this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
        float[] fArray = new float[]{-0.5f, 0.5f * this.stickerScale, -0.5f, -0.5f * this.stickerScale, 0.5f, -0.5f * this.stickerScale, 0.5f, 0.5f * this.stickerScale};
        this.mmcvImageLoader = new MmcvImageCacheLoader((Sticker)var2_2, (Context)byteBuffer);
        this.isPlaying = true;
        byteBuffer = ByteBuffer.allocateDirect(32);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put(fArray);
        this.vertexBuffer.position(0);
        this.texData0 = new float[]{-0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f, -0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f};
        byteBuffer = ByteBuffer.allocateDirect(this.drawOrder.length << 1);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.drawListBuffer = byteBuffer.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void setTextId(int textId) {
        void var1_1;
        this.textId = var1_1;
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   gl_FragColor = color1;\n}";
    }

    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.mVPMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_MVP_MATRIX);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_MVP_MATRIX);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    /*
     * WARNING - void declaration
     */
    protected void passShaderValues(float[] mvpMatrix) {
        void var1_1;
        this.renderVertices.position(0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(mvpMatrix.length << 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.fvertexBuffer = byteBuffer.asFloatBuffer();
        this.fvertexBuffer.put((float[])var1_1);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            for (float[] fArray : this.mvpLists) {
                this.passShaderValues(fArray);
                this.draw();
            }
            return;
        }
    }

    public void draw() {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)((float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth()));
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var2_4;
        if (newData) {
            this.markAsDirty();
        }
        if (this.lockTexture && this.texture_in > 0 && this.mvpLists != null && this.mvpLists.size() > 0) {
            this.isDraw = true;
        } else if (this.mvpLists != null && this.mvpLists.size() > 0) {
            if (!this.isDraw) {
                this.clearPoints();
            } else if (this.isPlaying) {
                MMFrameInfo mMFrameInfo = this.mmcvImageLoader.getMmcvImage(this.context);
                this.imagePath = this.mmcvImageLoader.imagePath;
                if (mMFrameInfo != null && mMFrameInfo.getDataPtr() != null) {
                    this.texture_in = this.texture_in == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)mMFrameInfo) : TextureHelper.loadDataToTexture((int)this.texture_in, (MMFrameInfo)mMFrameInfo);
                } else {
                    mMFrameInfo = this.mmcvImageLoader.getDelegateBitmap();
                    if (mMFrameInfo != null) {
                        this.deleteTexture();
                        this.texture_in = TextureHelper.bitmapToTexture((Bitmap)mMFrameInfo);
                    } else {
                        this.clearPoints();
                    }
                }
            } else {
                this.deleteTexture();
                this.clearPoints();
            }
            if (this.texture_in == 0) {
                this.clearPoints();
            }
            this.isDraw = true;
        } else {
            this.isDraw = false;
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        float f = (float)this.getWidth() / (float)this.getHeight();
        Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / f), (float)(1.0f / f), (float)3.0f, (float)7.0f);
        this.onDrawFrame();
        var2_4.unlockRenderBuffer();
    }

    protected void deleteTexture() {
        if (this.texture_in != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_in;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_in = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, float[] points, float[] points96, float[] points104, FilterTriggerManager filterTrigerManager) {
        Object object = this.maskListLock;
        synchronized (object) {
            float f;
            if (centerPoint == null) {
                return;
            }
            float f2 = -(centerPoint.x * 2.0f - 1.0f);
            float f3 = -centerPoint.y * 2.0f + 1.0f;
            centerPoint.x = f2;
            fArray.y = f3;
            float[] fArray = new float[16];
            float[] fArray2 = new float[16];
            Matrix.setIdentityM((float[])fArray2, (int)0);
            Matrix.translateM((float[])fArray2, (int)0, (float)(-f2), (float)f3, (float)0.0f);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
            Matrix.rotateM((float[])fArray, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])fArray, (int)0, (float)f, (float)h, (float)1.0f);
            Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
            f = 0.0f;
            if (this.sticker.isComic()) {
                void var2_3;
                f = angle == 0.0f ? (this.getHeight() <= 960 && (float)this.getHeight() / (float)this.getWidth() != 1.0f ? 0.75f * h * ((float)this.sticker.getImageHeight() / (float)this.getHeight()) / 2.0f : h * ((float)this.sticker.getImageHeight() / (float)this.getHeight()) / 2.0f) : (this.getHeight() <= 960 && (float)this.getHeight() / (float)this.getWidth() != 1.0f ? -0.75f * h * ((float)this.sticker.getImageHeight() / (float)this.getHeight()) / 2.0f : -var2_3 * ((float)this.sticker.getImageHeight() / (float)this.getHeight()) / 2.0f);
            }
            float[] fArray3 = new float[8];
            float[] fArray4 = fArray3;
            fArray3[0] = fArray2[0];
            fArray4[1] = fArray2[1] - f;
            fArray4[2] = fArray2[4];
            fArray4[3] = fArray2[5] - f;
            fArray4[4] = fArray2[8];
            fArray4[5] = fArray2[9] - f;
            fArray4[6] = fArray2[12];
            fArray4[7] = fArray2[13] - f;
            this.mvpLists.add(fArray4);
            return;
        }
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        void var1_1;
        this.setParamForMatrix(detectParam.scaleW, detectParam.scaleH, detectParam.centerPoint, detectParam.angle, detectParam.points68, detectParam.points96, detectParam.points104, var1_1.filterTrigerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPoints() {
        Object object = this.maskListLock;
        synchronized (object) {
            this.mvpLists.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDraw() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.isDraw = false;
            this.isPlaying = false;
            this.mmcvImageLoader.cancel();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockTexture() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.lockTexture = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockTexture() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.lockTexture = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseBitmapCache() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.isPlaying = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeBitmapCache() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.isPlaying = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void resetSticker(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            this.sticker = sticker;
            this.cancelDraw();
            this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
            Object object2 = new float[]{-0.5f, 0.5f * this.stickerScale, -0.5f, -0.5f * this.stickerScale, 0.5f, -0.5f * this.stickerScale, 0.5f, 0.5f * this.stickerScale};
            this.texData0 = new float[]{-0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f, -0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f};
            if (this.vertexBuffer != null) {
                this.vertexBuffer.clear();
                this.drawListBuffer.clear();
            }
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(32);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.vertexBuffer = byteBuffer.asFloatBuffer();
            this.vertexBuffer.put((float[])object2);
            this.vertexBuffer.position(0);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.drawOrder.length << 1);
            object2 = byteBuffer2;
            byteBuffer2.order(ByteOrder.nativeOrder());
            this.drawListBuffer = ((ByteBuffer)object2).asShortBuffer();
            this.drawListBuffer.put(this.drawOrder);
            this.drawListBuffer.position(0);
            this.mmcvImageLoader = new MmcvImageCacheLoader((Sticker)var1_1, this.context);
            return;
        }
    }

    public void destroy() {
        super.destroy();
        this.deleteTexture();
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long ms) {
        if (this.mmcvImageLoader != null) {
            void var1_1;
            this.mmcvImageLoader.setRenderTime((long)var1_1);
        }
    }

    public String getImagePathName() {
        return this.imagePath;
    }
}

