/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.opengl.Matrix;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerMaskFilter;
import com.momo.mcamera.mask.bean.ObjectRegion;
import com.momocv.MMRect;
import com.momocv.objecttracker.ObjectTracker;
import com.momocv.objecttracker.ObjectTrackerInfo;
import com.momocv.objecttracker.ObjectTrackerParams;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class StickerGestureTrackingFilter
extends StickerMaskFilter {
    private static final int DETECT_MISS_COUNT = 3;
    private static final float DEFAULT_GESTURE_WIDTH = 180.0f;
    private boolean hasGestureRect = false;
    private RectF currentRect = null;
    private PointF currentCenter = null;
    private volatile boolean startTracking;
    private volatile boolean trackingInit;
    private int gestureMiss;
    private MMRect mmcvRect;
    private MMCVInfo mmcvInfo;
    private ObjectTracker mTracker = new ObjectTracker();
    private MMFrameInfo mmFrame = new MMFrameInfo();
    private ObjectTrackerParams trackerParams = new ObjectTrackerParams();
    private ObjectTrackerInfo trackerInfo = new ObjectTrackerInfo();

    /*
     * WARNING - void declaration
     */
    public StickerGestureTrackingFilter(Context context, Sticker sticker) {
        super((Context)var1_1, (Sticker)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        if (detectParam.gestureRect != null) {
            this.currentRect = detectParam.gestureRect;
        }
        if (this.currentRect == null) {
            return;
        }
        Object object = this.maskListLock;
        synchronized (object) {
            void var1_1;
            PointF pointF;
            float f = this.currentRect.right - this.currentRect.left;
            float f2 = this.currentRect.bottom - this.currentRect.top;
            float f3 = f / 180.0f / this.getAdjustWidthScale();
            detectParam.points8 = new float[8];
            detectParam.points8[0] = this.currentRect.left;
            detectParam.points8[1] = this.currentRect.right;
            detectParam.points8[2] = this.currentRect.left;
            detectParam.points8[3] = this.currentRect.right;
            detectParam.points8[4] = this.currentRect.top;
            detectParam.points8[5] = this.currentRect.top;
            detectParam.points8[6] = this.currentRect.bottom;
            detectParam.points8[7] = this.currentRect.bottom;
            if (detectParam.points8 != null && null != this.sticker.getPointIndexes() && this.sticker.getPointIndexes().length > 1) {
                int n = this.sticker.getPointIndexes()[0];
                int n2 = this.sticker.getPointIndexes()[1];
                float f4 = detectParam.points8[n];
                float f5 = detectParam.points8[n + 4];
                float f6 = detectParam.points8[n2];
                float f7 = detectParam.points8[n2 + 4];
                pointF = this.getCenterPoint(new PointF(f4, f5), new PointF(f6, f7));
                pointF.x += (float)this.sticker.getOffsetX() * f3 / 2.0f;
                pointF.y += (float)this.sticker.getOffsetY() * f3 / 2.0f;
                pointF = new PointF(pointF.x / (float)this.getWidth(), pointF.y / (float)this.getHeight());
            } else {
                f3 = f / 180.0f / this.getAdjustWidthScale();
                f = this.currentRect.left + f / 2.0f + (float)this.sticker.getOffsetX() * f3;
                f2 = this.currentRect.top + f2 / 2.0f + (float)this.sticker.getOffsetY() * f3;
                pointF = new PointF(f / (float)this.getWidth(), f2 / (float)this.getHeight());
            }
            this.setParamForMatrix(f3, f3, pointF, 0.0f, var1_1.filterTrigerManager);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        void var1_1;
        this.mmcvInfo = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_4;
        void var2_3;
        void var1_1;
        Object object = this.getLockObject();
        synchronized (object) {
            this.trackingUpdate();
        }
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_3, (boolean)var3_4);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mTracker != null) {
            this.mTracker.Release();
        }
    }

    private void trackingUpdate() {
        if (this.startTracking && this.mmcvRect != null && this.mmcvInfo != null) {
            this.mmFrame.setFormat(17);
            this.mmFrame.setStep_(this.width);
            this.mmFrame.setWidth(this.width);
            this.mmFrame.setHeight(this.height);
            this.trackerParams.rect_ = this.mmcvRect;
            this.trackerInfo.rect_ = this.mmcvRect;
            if (!this.trackingInit) {
                this.mTracker.ReInit(this.mmFrame.getFrame(), this.trackerParams);
                this.trackingInit = true;
            } else {
                this.mTracker.Update(this.mmFrame.getFrame(), this.trackerParams, this.trackerInfo);
            }
            FaceDetectFilter.FaceDetectParam faceDetectParam = new FaceDetectFilter.FaceDetectParam();
            new FaceDetectFilter.FaceDetectParam().centerPoint = new PointF(0.0f, 0.0f);
            RectF rectF = new RectF();
            new RectF().left = this.trackerInfo.rect_.x_;
            rectF.top = this.trackerInfo.rect_.y_;
            rectF.right = this.trackerInfo.rect_.x_ + this.trackerInfo.rect_.width_;
            rectF.bottom = this.trackerInfo.rect_.y_ + this.trackerInfo.rect_.height_;
            if (this.sticker.getTrackingRegion() != null) {
                this.adjustRectF(rectF);
            }
            faceDetectParam.gestureRect = rectF;
            this.setDetectParam(faceDetectParam);
            return;
        }
        this.trackingInit = false;
    }

    /*
     * WARNING - void declaration
     */
    private void adjustRectF(RectF rectF) {
        void var1_1;
        ObjectRegion objectRegion = this.sticker.getTrackingRegion();
        float f = rectF.width() / objectRegion.w;
        float f2 = rectF.height() / objectRegion.h;
        rectF.left -= f * objectRegion.x;
        rectF.top -= f2 * objectRegion.y;
        rectF.right = rectF.left + f;
        rectF.bottom = var1_1.top + f2;
    }

    public boolean isTrackingInit() {
        return this.trackingInit;
    }

    /*
     * WARNING - void declaration
     */
    private void log(String info, MMRect mmcvRect) {
        if (mmcvRect != null) {
            void var2_2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[").append(mmcvRect.x_).append(",").append(mmcvRect.y_).append(",").append(mmcvRect.x_ + mmcvRect.width_).append(",").append(mmcvRect.y_ + mmcvRect.height_).append("]");
            stringBuilder.append("   ").append(mmcvRect.y_ + mmcvRect.width_ / 2).append(" , ").append(mmcvRect.y_ + var2_2.height_ / 2);
        }
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return 1.5f;
    }

    /*
     * WARNING - void declaration
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, FilterTriggerManager filterTrigerManager) {
        void var2_3;
        void var1_1;
        float f = -(centerPoint.x * 2.0f - 1.0f);
        float f2 = -centerPoint.y * 2.0f + 1.0f;
        centerPoint.x = f;
        fArray.y = f2;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f), (float)f2, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
        Matrix.rotateM((float[])fArray, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])fArray, (int)0, (float)var1_1, (float)var2_3, (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
        float[] fArray3 = new float[8];
        float[] fArray4 = fArray3;
        fArray3[0] = fArray2[0];
        fArray4[1] = fArray2[1];
        fArray4[2] = fArray2[4];
        fArray4[3] = fArray2[5];
        fArray4[4] = fArray2[8];
        fArray4[5] = fArray2[9];
        fArray4[6] = fArray2[12];
        fArray4[7] = fArray2[13];
        this.mvpLists.add(fArray4);
    }

    /*
     * WARNING - void declaration
     */
    public PointF getCenterPoint(PointF pointA, PointF pointB) {
        void var1_1;
        void var2_3;
        float f = pointA.x + (pointB.x - pointA.x) / 2.0f;
        float f2 = pointA.y + (var2_3.y - var1_1.y) / 2.0f;
        return new PointF(f, f2);
    }

    @Override
    public void pauseBitmapCache() {
        super.pauseBitmapCache();
        if (this.sticker != null) {
            this.sticker.curIndex = 0;
            this.hasGestureRect = false;
            this.currentRect = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMMCVRect(MMRect mmcvRect) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            this.mmcvRect = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.startTracking = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gestureMiss() {
        Object object = this.getLockObject();
        synchronized (object) {
            ++this.gestureMiss;
            if (this.gestureMiss >= 3) {
                this.gestureMiss = 0;
                this.startTracking = false;
                this.trackingInit = false;
                this.mmcvRect = null;
                this.pauseBitmapCache();
            }
            return;
        }
    }
}

