/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.MmcvImageCacheLoader;
import com.momo.mcamera.mask.Sticker;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ImageMoveStickerMaskFilter
extends BasicFilter
implements IVideoTrackTime {
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    static final int COORDS_PER_VERTEX = 2;
    private final String vertexShaderCode = "attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   if (color1.a > 0.0) {color1.rgb = color1.rgb/color1.a;}    gl_FragColor = color1;\n}";
    protected final float[] mProjectionMatrix = new float[16];
    protected final float[] mViewMatrix = new float[16];
    private final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final int vertexStride = 8;
    protected Object maskListLock = new Object();
    float stickerScale;
    float[] texData0;
    List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    protected Sticker sticker;
    private MmcvImageCacheLoader mmcvImageLoader;
    private Context context;
    private FloatBuffer vertexBuffer;
    private FloatBuffer fvertexBuffer;
    private ShortBuffer drawListBuffer;
    private int decorateHandler;
    protected int positionHandle2;
    private boolean isDraw;
    private boolean lockTexture = false;
    private int stickerWidth = 0;
    private int stickerHeight = 0;
    private String imagePath;
    private boolean isPost = false;
    private float PositionX = 0.5f;

    /*
     * WARNING - void declaration
     */
    public ImageMoveStickerMaskFilter(Context context, Sticker sticker) {
        void var1_1;
        void var2_2;
        this.sticker = var2_2;
        this.context = var1_1;
        this.initCoordinate();
    }

    private void initCoordinate() {
        this.updateSticker(this.sticker);
    }

    public void updateSticker(Sticker sticker) {
        if (sticker == null) {
            return;
        }
        this.sticker = sticker;
        this.mmcvImageLoader = new MmcvImageCacheLoader(sticker, this.context);
        if (this.stickerWidth != sticker.getImageWidth() || this.stickerHeight != sticker.getImageHeight()) {
            Object object;
            this.stickerWidth = sticker.getImageWidth();
            this.stickerHeight = ((Sticker)object).getImageHeight();
            this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
            object = new float[]{-0.5f, 0.5f * this.stickerScale, -0.5f, -0.5f * this.stickerScale, 0.5f, -0.5f * this.stickerScale, 0.5f, 0.5f * this.stickerScale};
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(32);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.vertexBuffer = byteBuffer.asFloatBuffer();
            this.vertexBuffer.put((float[])object);
            this.vertexBuffer.position(0);
            this.texData0 = new float[]{-0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f, -0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f};
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.drawOrder.length << 1);
            object = byteBuffer2;
            byteBuffer2.order(ByteOrder.nativeOrder());
            this.drawListBuffer = ((ByteBuffer)object).asShortBuffer();
            this.drawListBuffer.put(this.drawOrder);
            this.drawListBuffer.position(0);
            Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
            this.mViewMatrix[0] = -1.0f;
        }
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   if (color1.a > 0.0) {color1.rgb = color1.rgb/color1.a;}    gl_FragColor = color1;\n}";
    }

    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    /*
     * WARNING - void declaration
     */
    protected void passShaderValues(float[] mvpMatrix) {
        void var1_1;
        this.renderVertices.position(0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(mvpMatrix.length << 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.fvertexBuffer = byteBuffer.asFloatBuffer();
        this.fvertexBuffer.put((float[])var1_1);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        if (this.mvpLists == null || this.mvpLists.size() <= 0) {
            if (this.isPost) {
                this.drawPositionSetScaleSize();
            } else {
                this.drawPositionSetFixed();
            }
        }
        if (this.texture_in == 0) {
            return;
        }
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            for (float[] fArray : this.mvpLists) {
                this.passShaderValues(fArray);
                this.draw();
            }
            return;
        }
    }

    public void draw() {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)((float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth()));
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }

    /*
     * Unable to fully structure code
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        block7: {
            block8: {
                block6: {
                    if (newData) {
                        this.markAsDirty();
                    }
                    if (!this.lockTexture || this.texture_in <= 0 || this.mvpLists == null || this.mvpLists.size() <= 0) break block6;
                    this.isDraw = true;
                    break block7;
                }
                if (this.mvpLists == null || this.mvpLists.size() <= 0) break block8;
                if (!this.isDraw) ** GOTO lbl-1000
                var1_2 = this.mmcvImageLoader.getMmcvImage(this.context);
                this.imagePath = this.mmcvImageLoader.imagePath;
                if (var1_2 != null && var1_2.getDataPtr() != null) {
                    this.texture_in = this.texture_in == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)var1_2) : TextureHelper.loadDataToTexture((int)this.texture_in, (MMFrameInfo)var1_2);
                } else {
                    var1_2 = this.mmcvImageLoader.getDelegateBitmap();
                    if (var1_2 != null) {
                        this.deleteTexture();
                        this.texture_in = TextureHelper.bitmapToTexture((Bitmap)var1_2);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.clearPoints();
                    }
                }
                if (this.texture_in == 0) {
                    this.clearPoints();
                }
                this.isDraw = true;
                break block7;
            }
            this.isDraw = false;
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        var1_3 = (float)this.getWidth() / (float)this.getHeight();
        Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / var1_3), (float)(1.0f / var1_3), (float)3.0f, (float)7.0f);
        this.onDrawFrame();
        var2_4.unlockRenderBuffer();
    }

    protected void deleteTexture() {
        if (this.texture_in != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_in;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_in = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle) {
        Object object = this.maskListLock;
        synchronized (object) {
            void var2_4;
            void var1_1;
            if (centerPoint == null) {
                return;
            }
            float f = -(centerPoint.x * 2.0f - 1.0f);
            float f2 = -centerPoint.y * 2.0f + 1.0f;
            centerPoint.x = f;
            fArray.y = f2;
            float[] fArray = new float[16];
            float[] fArray2 = new float[16];
            Matrix.setIdentityM((float[])fArray2, (int)0);
            Matrix.translateM((float[])fArray2, (int)0, (float)(-f), (float)f2, (float)0.0f);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
            Matrix.rotateM((float[])fArray, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])fArray, (int)0, (float)var1_1, (float)var2_4, (float)1.0f);
            Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
            float[] fArray3 = new float[8];
            float[] fArray4 = fArray3;
            fArray3[0] = fArray2[0];
            fArray4[1] = fArray2[1];
            fArray4[2] = fArray2[4];
            fArray4[3] = fArray2[5];
            fArray4[4] = fArray2[8];
            fArray4[5] = fArray2[9];
            fArray4[6] = fArray2[12];
            fArray4[7] = fArray2[13];
            this.mvpLists.add(fArray4);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPoints() {
        Object object = this.maskListLock;
        synchronized (object) {
            this.mvpLists.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDraw() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.isDraw = false;
            return;
        }
    }

    public void destroy() {
        super.destroy();
        this.deleteTexture();
        this.clearPoints();
    }

    private void drawPositionSetFixed() {
        float f;
        float f2 = (float)this.getWidth() / 2.0f;
        float f3 = ((float)this.getHeight() - (float)this.sticker.getImageHeight() * this.getAdjustHeightScale()) / 2.0f + (float)this.sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF pointF = new PointF(f2 / (float)this.getWidth(), f3 / (float)this.getHeight());
        if (this.sticker.getImageWidth() > 360) {
            f3 = 2.0f;
            f = 2.0f;
        } else if (this.getWidth() == 720) {
            f3 = 2.0f;
            f = 2.0f;
        } else {
            f3 = 1.5f;
            f = 1.5f;
        }
        this.setParamForMatrix(f, f3, pointF, 0.0f);
    }

    private void drawPositionSetScaleSize() {
        PointF pointF = new PointF(this.PositionX, 0.5f);
        this.setParamForMatrix(1.0f, 1.0f, pointF, 0.0f);
    }

    public float getAdjustHeightScale() {
        if ((float)this.getHeight() == 640.0f) {
            return 1.0f;
        }
        return (float)this.getHeight() / 640.0f;
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return (float)this.getWidth() / 480.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void setPostWatermark(boolean isPost) {
        void var1_1;
        this.isPost = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPosition(float position) {
        void var1_1;
        this.PositionX = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long ms) {
        if (this.mmcvImageLoader != null) {
            void var1_1;
            this.mmcvImageLoader.setRenderTime((long)var1_1);
        }
    }
}

