/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.filtermanager;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.momo.mcamera.filtermanager.MMPresetFilterStore;
import com.momo.mcamera.filtermanager.MMProcessUnit;
import com.momo.mcamera.filtermanager.a;
import com.momo.mcamera.filtermanager.filterext.BitmapBlendFilter;
import com.momo.mcamera.mask.MaskStore;
import com.momo.mcamera.mask.StickerAdjustFilter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.SingleLineGroupFilter;
import project.android.imageprocessing.filter.colour.LookupFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;

public class MMFilter
implements Serializable {
    public static final long serialVersionUID = 8953832831202944607L;
    public String mImageUri;
    public String mFilterName;
    private List<MMProcessUnit> mProcessUnits;
    private transient Context context;

    /*
     * WARNING - void declaration
     */
    public MMFilter(Context context) {
        void var1_1;
        this.mProcessUnits = new ArrayList<MMProcessUnit>();
        this.context = var1_1;
    }

    public MMFilter() {
    }

    public static List<BasicFilter> getFilterGroupByUnits(Collection<MMProcessUnit> processUnits, Context context) {
        Object object;
        ArrayList<BasicFilter> arrayList = new ArrayList<BasicFilter>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            MMProcessUnit mMProcessUnit = (MMProcessUnit)object.next();
            if (mMProcessUnit.isDecoration()) {
                object2 = new StickerAdjustFilter(context);
                new StickerAdjustFilter(context).enableSelfRender = true;
                ((StickerAdjustFilter)((Object)object2)).addMaskModel(MaskStore.getInstance().getMask(context, mMProcessUnit.getResourceName()));
                arrayList.add((BasicFilter)object2);
                continue;
            }
            try {
                object2 = Class.forName(mMProcessUnit.getFilterName());
                BasicFilter basicFilter = (BasicFilter)((Class)object2).newInstance();
                HashMap<String, Object> hashMap = mMProcessUnit.getFilterMap();
                if (hashMap != null) {
                    for (String string : hashMap.keySet()) {
                        ((Class)object2).getDeclaredMethod(string, a.a(hashMap.get(string))).invoke((Object)basicFilter, hashMap.get(string));
                    }
                }
                if (mMProcessUnit.getTexturePath1() != null) {
                    if (basicFilter instanceof LookupFilter) {
                        if (mMProcessUnit.getTexturePath1().startsWith("light_room_filters")) {
                            ((LookupFilter)basicFilter).setAssetResourcesId(context, mMProcessUnit.getTexturePath1());
                        } else {
                            ((LookupFilter)basicFilter).setLookUpPath(mMProcessUnit.getTexturePath1());
                        }
                    } else if (basicFilter instanceof BitmapBlendFilter) {
                        Bitmap bitmap = MMFilter.getBitmapByPath(mMProcessUnit.getTexturePath1(), context);
                        ((BitmapBlendFilter)basicFilter).setBlendBitmap(bitmap);
                    }
                }
                arrayList.add(basicFilter);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        if (arrayList.size() == 0) {
            object = new NormalFilter();
            arrayList.add((BasicFilter)object);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static BasicFilter getFilterByUnit(MMProcessUnit unit, Context context) {
        BasicFilter basicFilter = null;
        try {
            Class<?> clazz = Class.forName(unit.getFilterName());
            basicFilter = (BasicFilter)clazz.newInstance();
            HashMap<String, Object> hashMap = unit.getFilterMap();
            if (hashMap != null) {
                for (String string : hashMap.keySet()) {
                    clazz.getDeclaredMethod(string, a.a(hashMap.get(string))).invoke((Object)basicFilter, hashMap.get(string));
                }
            }
            if (unit.getTexturePath1() != null && basicFilter instanceof LookupFilter) {
                void var1_1;
                MMProcessUnit mMProcessUnit;
                Bitmap bitmap = MMFilter.getBitmapByPath(mMProcessUnit.getTexturePath1(), (Context)var1_1);
                ((LookupFilter)basicFilter).setLookupBitmap(bitmap);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return basicFilter;
    }

    public SingleLineGroupFilter getFilterGroup() {
        return new SingleLineGroupFilter(MMFilter.getFilterGroupByUnits(this.getProcessUnits(), this.context));
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap getBitmapByPath(String path, Context context) {
        String string;
        if (path.startsWith("light_room_filters")) {
            void var1_1;
            return MMPresetFilterStore.getBitmapWithPath(path, (Context)var1_1);
        }
        return BitmapFactory.decodeFile((String)string);
    }

    /*
     * WARNING - void declaration
     */
    public void setProcessUnits(List<MMProcessUnit> mProcessUnits) {
        void var1_1;
        this.mProcessUnits = var1_1;
    }

    public List<MMProcessUnit> getProcessUnits() {
        return this.mProcessUnits;
    }

    public String getKey() {
        return ".....";
    }

    public String getFilterName() {
        if (!TextUtils.isEmpty((CharSequence)this.mFilterName)) {
            this.mFilterName.replace(".", "_");
            String[] stringArray = this.mFilterName.split("_");
            if (stringArray.length > 1) {
                return stringArray[1];
            }
        }
        return this.mFilterName;
    }
}

