/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.filter.BasicSingleEffectFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class MirrImageFrameFilter
extends BasicSingleEffectFilter
implements IVideoTrackTime {
    private static final String UNIFORM_ORDER = "order";
    private static final String UNIFORM_BACKGROUND = "background";
    private static final String UNIFORM_FIRST_TIME = "firstTime";
    private int orderHandle;
    private int backgroundHandle;
    private int firstHandle;
    private int mTexture0 = -1;
    private int mTexture0Handle = 0;
    private int mTexture1 = -1;
    private int mTexture1Handle = 0;
    private int mTexture2 = -1;
    private int mTexture2Handle = 0;
    private int mTexture3 = -1;
    private int mTexture3Handle = 0;
    private int mImageCount = 0;
    private float mOrder = 0.0f;
    private float mBackground = 0.0f;
    private float mFirst = 0.0f;
    private GLFrameBuffer mWindowsFrameOne = null;
    private GLFrameBuffer mWindowsFrameTwo = null;
    private GLFrameBuffer mWindowsFrameThree = null;
    private GLFrameBuffer mWindowsFrameFour = null;
    private long mTimeInterval = 30L;
    private int mFourPalaceCount = 0;

    protected String getFragmentShader() {
        return "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nuniform sampler2D inputImageTexture3;\nuniform sampler2D inputImageTexture4;\nuniform float order;\nuniform float background;\nuniform float firstTime;\nvarying vec2 textureCoordinate;\n float pick(float v)\n{    if(v > 0.5){\n      return (v - 0.5) * 2.0;\n    } return v * 2.0;\n}void main(){\n    vec2 uv = textureCoordinate;\n    vec4 color = vec4(0.0);\n    if (firstTime == 1.0) {\n    if(uv.x <= 0.5 && uv.y > 0.5)\n    {\n        color = texture2D(inputImageTexture0, vec2(pick(uv.x), pick(uv.y)));\n        float gray = color.r * 0.6 + color.g * 0.3 + color.b * 0.1;\n        color = vec4(gray, gray, gray, 1.0);\n    }\n    else if(uv.x > 0.5 && uv.y > 0.5)\n    {\n        color = texture2D(inputImageTexture0, vec2(pick(uv.x), pick(uv.y)));\n        float gray = color.r * 0.6 + color.g * 0.3 + color.b * 0.1;\n        color = vec4(gray, gray, gray, 1.0);\n    }\n    else if(uv.x > 0.5 && uv.y <= 0.5)\n    {\n        color = texture2D(inputImageTexture0, vec2(pick(uv.x), pick(uv.y)));\n        float gray = color.r * 0.6 + color.g * 0.3 + color.b * 0.1;\n        color = vec4(gray, gray, gray, 1.0);\n    }\n    else if(uv.x <= 0.5 && uv.y <= 0.5)\n    {\n        color = texture2D(inputImageTexture0, vec2(pick(uv.x), pick(uv.y)));\n        float gray = color.r * 0.6 + color.g * 0.3 + color.b * 0.1;\n        color = vec4(gray, gray, gray, 1.0);\n    }\n    } else {\n    if (background == 1.0) {        color = texture2D(inputImageTexture0, uv);\n    } else if(uv.x <= 0.5 && uv.y > 0.5)\n    {\n      if (order == 0.0) {        color = texture2D(inputImageTexture0, vec2(pick(uv.x), pick(uv.y)));\n      } else {\n        color = texture2D(inputImageTexture1, vec2(pick(uv.x), pick(uv.y)));\n        float gray = color.r * 0.6 + color.g * 0.3 + color.b * 0.1;\n        color = vec4(gray, gray, gray, 1.0);\n      }\n    }\n    else if(uv.x > 0.5 && uv.y > 0.5)\n    {\n      if (order == 1.0) {        color = texture2D(inputImageTexture0, vec2(pick(uv.x), pick(uv.y)));\n      } else {\n        color = texture2D(inputImageTexture2, vec2(pick(uv.x), pick(uv.y)));\n        float gray = color.r * 0.6 + color.g * 0.3 + color.b * 0.1;\n        color = vec4(gray, gray, gray, 1.0);\n      }\n    }\n    else if(uv.x > 0.5 && uv.y <= 0.5)\n    {\n      if (order == 2.0) {        color = texture2D(inputImageTexture0, vec2(pick(uv.x), pick(uv.y)));\n      } else {\n        color = texture2D(inputImageTexture3, vec2(pick(uv.x), pick(uv.y)));\n        float gray = color.r * 0.6 + color.g * 0.3 + color.b * 0.1;\n        color = vec4(gray, gray, gray, 1.0);\n      }\n    }\n    else if(uv.x <= 0.5 && uv.y <= 0.5)\n    {\n      if (order == 3.0) {        color = texture2D(inputImageTexture0, vec2(pick(uv.x), pick(uv.y)));\n      } else {\n        color = texture2D(inputImageTexture4, vec2(pick(uv.x), pick(uv.y)));\n        float gray = color.r * 0.6 + color.g * 0.3 + color.b * 0.1;\n        color = vec4(gray, gray, gray, 1.0);\n      }\n    }\n    } gl_FragColor = color;\n}\n";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mTexture0Handle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture1");
        this.mTexture1Handle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture2");
        this.mTexture2Handle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture3");
        this.mTexture3Handle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture4");
        this.orderHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ORDER);
        this.backgroundHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BACKGROUND);
        this.firstHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_FIRST_TIME);
    }

    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.mTexture0);
        GLES20.glUniform1i((int)this.mTexture0Handle, (int)1);
        GLES20.glActiveTexture((int)33986);
        GLES20.glBindTexture((int)3553, (int)this.mTexture1);
        GLES20.glUniform1i((int)this.mTexture1Handle, (int)2);
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)this.mTexture2);
        GLES20.glUniform1i((int)this.mTexture2Handle, (int)3);
        GLES20.glActiveTexture((int)33988);
        GLES20.glBindTexture((int)3553, (int)this.mTexture3);
        GLES20.glUniform1i((int)this.mTexture3Handle, (int)4);
        GLES20.glUniform1f((int)this.orderHandle, (float)this.mOrder);
        GLES20.glUniform1f((int)this.backgroundHandle, (float)this.mBackground);
        GLES20.glUniform1f((int)this.firstHandle, (float)this.mFirst);
    }

    protected synchronized void drawFrame() {
        this.generateFramebuffer();
        for (int i2 = 0; i2 < this.mEffectTimeList.size(); ++i2) {
            block11: {
                block10: {
                    block9: {
                        if (!this.isFirstTime && this.mTexture0 != -1 && this.mTexture1 != -1 && this.mTexture2 != -1 && this.mTexture3 != -1) break block9;
                        this.mFirst = 1.0f;
                        super.drawFrame();
                        this.mFirst = 0.0f;
                        this.mFourPalaceCount = 0;
                        this.mImageCount = 0;
                        this.mOrder = 0.0f;
                        this.mBackground = 1.0f;
                        GLES20.glBindFramebuffer((int)36160, (int)this.mWindowsFrameOne.getFrameBuffer()[0]);
                        this.drawSub();
                        GLES20.glBindFramebuffer((int)36160, (int)this.mWindowsFrameTwo.getFrameBuffer()[0]);
                        this.drawSub();
                        GLES20.glBindFramebuffer((int)36160, (int)this.mWindowsFrameThree.getFrameBuffer()[0]);
                        this.drawSub();
                        GLES20.glBindFramebuffer((int)36160, (int)this.mWindowsFrameFour.getFrameBuffer()[0]);
                        this.drawSub();
                        this.mTexture0 = this.mWindowsFrameOne.getTexture_out()[0];
                        this.mTexture1 = this.mWindowsFrameTwo.getTexture_out()[0];
                        this.mTexture2 = this.mWindowsFrameThree.getTexture_out()[0];
                        this.mTexture3 = this.mWindowsFrameFour.getTexture_out()[0];
                        break block10;
                    }
                    this.mBackground = 0.0f;
                    super.drawFrame();
                    if ((long)this.mImageCount % this.mTimeInterval != 0L || this.mImageCount == 0) break block11;
                    this.mBackground = 1.0f;
                    this.mOrder = this.mFourPalaceCount % 4;
                    switch ((int)(this.mOrder - 1.0f)) {
                        case 0: {
                            GLES20.glBindFramebuffer((int)36160, (int)this.mWindowsFrameOne.getFrameBuffer()[0]);
                            this.drawSub();
                            this.mTexture0 = this.mWindowsFrameOne.getTexture_out()[0];
                            break;
                        }
                        case 1: {
                            GLES20.glBindFramebuffer((int)36160, (int)this.mWindowsFrameTwo.getFrameBuffer()[0]);
                            this.drawSub();
                            this.mTexture1 = this.mWindowsFrameTwo.getTexture_out()[0];
                            break;
                        }
                        case 2: {
                            GLES20.glBindFramebuffer((int)36160, (int)this.mWindowsFrameThree.getFrameBuffer()[0]);
                            this.drawSub();
                            this.mTexture2 = this.mWindowsFrameThree.getTexture_out()[0];
                            break;
                        }
                        case -1: {
                            GLES20.glBindFramebuffer((int)36160, (int)this.mWindowsFrameFour.getFrameBuffer()[0]);
                            this.drawSub();
                            this.mTexture3 = this.mWindowsFrameFour.getTexture_out()[0];
                        }
                    }
                }
                ++this.mFourPalaceCount;
            }
            ++this.mImageCount;
        }
    }

    protected synchronized void handleSizeChange() {
        super.handleSizeChange();
        this.releasePalaceFrameBuffer();
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeInterval(long interval) {
        void var1_1;
        this.mTimeInterval = var1_1;
    }

    public void destroy() {
        int[] nArray;
        super.destroy();
        if (this.mTexture0 != 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.mTexture0;
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.mTexture0 = 0;
        }
        if (this.mTexture1 != 0) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = this.mTexture1;
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.mTexture1 = 0;
        }
        if (this.mTexture2 != 0) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = this.mTexture2;
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.mTexture2 = 0;
        }
        if (this.mTexture3 != 0) {
            int[] nArray5 = new int[1];
            nArray = nArray5;
            nArray5[0] = this.mTexture3;
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.mTexture3 = 0;
        }
        this.releasePalaceFrameBuffer();
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        this.releasePalaceFrameBuffer();
    }

    private void releasePalaceFrameBuffer() {
        if (this.mWindowsFrameOne != null) {
            this.mWindowsFrameOne.destoryBuffer();
            this.mWindowsFrameOne = null;
        }
        if (this.mWindowsFrameTwo != null) {
            this.mWindowsFrameTwo.destoryBuffer();
            this.mWindowsFrameTwo = null;
        }
        if (this.mWindowsFrameThree != null) {
            this.mWindowsFrameThree.destoryBuffer();
            this.mWindowsFrameThree = null;
        }
        if (this.mWindowsFrameFour != null) {
            this.mWindowsFrameFour.destoryBuffer();
            this.mWindowsFrameFour = null;
        }
        this.mOrder = 0.0f;
        this.mImageCount = 0;
        this.mOrder = 0.0f;
        this.mBackground = 0.0f;
        this.mFourPalaceCount = 0;
        this.isFirstTime = true;
    }

    /*
     * WARNING - void declaration
     */
    protected GLFrameBuffer initFrameBuffer(GLFrameBuffer glFrameBuffer) {
        void var1_1;
        if (glFrameBuffer != null) {
            glFrameBuffer.destoryBuffer();
        }
        glFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
        glFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
        int n2 = GLES20.glCheckFramebufferStatus((int)36160);
        if (n2 != 36053) {
            throw new RuntimeException((Object)((Object)this) + ": Failed to set up render buffer with status " + n2 + " and error " + GLES20.glGetError());
        }
        return var1_1;
    }

    private void generateFramebuffer() {
        if (this.mWindowsFrameOne == null) {
            this.mWindowsFrameOne = this.activityPalaceFrameBuffer(this.mWindowsFrameOne);
        }
        if (this.mWindowsFrameTwo == null) {
            this.mWindowsFrameTwo = this.activityPalaceFrameBuffer(this.mWindowsFrameTwo);
        }
        if (this.mWindowsFrameThree == null) {
            this.mWindowsFrameThree = this.activityPalaceFrameBuffer(this.mWindowsFrameThree);
        }
        if (this.mWindowsFrameFour == null) {
            this.mWindowsFrameFour = this.activityPalaceFrameBuffer(this.mWindowsFrameFour);
        }
    }

    /*
     * WARNING - void declaration
     */
    private GLFrameBuffer activityPalaceFrameBuffer(GLFrameBuffer glFrameBuffer) {
        void var1_1;
        if (glFrameBuffer == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                glFrameBuffer = this.initFrameBuffer(glFrameBuffer);
            } else {
                return null;
            }
        }
        if (glFrameBuffer != null && glFrameBuffer.getFrameBuffer() == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                glFrameBuffer = this.initFrameBuffer(glFrameBuffer);
            } else {
                return null;
            }
        }
        glFrameBuffer.activityFrameBuffer(this.width, this.height);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long ms) {
        void var1_1;
        super.setTimeStamp((long)var1_1);
    }
}

