/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.videoencoder;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.StickerGroupFilter;
import com.momo.mcamera.videoencoder.ProcessParam;
import com.momo.mcamera.videoencoder.ProcessRender;
import com.momo.mcamera.videoprocess.VideoProcessListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import project.android.imageprocessing.ext.SurfaceManager;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;

public class ProcessSurface {
    private static final String TAG = "ProcessSurface";
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private EGL10 mEGL = null;
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL10.EGL_NO_CONTEXT;
    private EGLSurface mEGLSurface = EGL10.EGL_NO_SURFACE;
    private EGLSurface mEGLDumpSurface = EGL10.EGL_NO_SURFACE;
    private SurfaceManager mCodecSurfaceManager;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private Surface mMediaCodecSurface;
    private ProcessParam processParam;
    private BasicFilter mFilterWrap = null;
    private StickerGroupFilter mStickersFilter = null;
    private Object mScreenSurface = null;
    private final Lock mThreadSyn = new ReentrantLock();
    private Object mFrameSyncObject = new Object();
    private volatile boolean mFrameAvailable;
    private Object mActiviteSyncObject = new Object();
    private Object mThreadSyncObject = new Object();
    private ProcessRender mTextureRender = null;
    private int[] mScreenWidth = new int[1];
    private int[] mScreenHight = new int[1];
    private int mLastError = 0;
    private int mOutImgW = 352;
    private int mOutImgH = 640;
    private VideoProcessListener processListener;
    private long playStartTime = 0L;
    private long playIngTime = 0L;
    public AtomicBoolean isRenderDrawing = new AtomicBoolean(false);
    public AtomicBoolean shouldDrop = new AtomicBoolean(false);
    public int mRenderFRate = 20;
    public int mRenderTime = 30;
    long renderToDT = 0L;
    long renderToCT = 0L;
    long renderLoop = 0L;
    private ProcessParam mProcessParam;
    private HandlerThread mMonitorTread = null;
    private Handler mMonitorHandler = null;
    int[] mSurfaceAttribs = new int[]{12375, 192, 12374, 320, 12344};
    int[] mPbAttribListbAttribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12339, 1, 12352, 4, 12344};
    int[] mAttribList = new int[]{12322, 8, 12323, 8, 12324, 8, 12339, 4, 12352, 4, 12344};
    int[] attrib_list = new int[]{12440, 2, 12344};
    EGLConfig[] mConfigs = null;
    int[] mNumConfigs = null;
    private int[] mValue = new int[1];
    private volatile boolean mNeedRending = false;
    private volatile boolean mNeedActiveSurface = true;
    private volatile boolean mNeedSetFilter = false;
    private volatile boolean mAddCodecSurface = false;
    private volatile boolean mRemoveCodecSurface = false;
    private volatile int mEncoderFrameRate = 25;
    private volatile boolean mDropFrame = false;
    private volatile boolean mBitrateAdapt = false;
    private RenderThread mRenderThread = new RenderThread(this, "ijkStrRender");
    private volatile boolean mRenderShouldExit = false;
    public FrameRefreshSoonListener frameRefreshSoonListener;

    public void setProcessListener(VideoProcessListener processListener) {
        this.processListener = processListener;
    }

    public void setEncodeFrameRate(int frameRate) {
        this.mEncoderFrameRate = frameRate;
        if (null != this.mTextureRender) {
            this.mTextureRender.setFrameRate(frameRate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture st) {
        if (this.playIngTime == 0L) {
            this.playIngTime = System.currentTimeMillis();
        }
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            if (this.mFrameAvailable && this.mTextureRender != null) {
                this.mTextureRender.checkGlError("mFrameAvailable already set, frame could be dropped");
            }
            this.mFrameAvailable = true;
            this.mFrameSyncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaCodecSurface(Surface surface) {
        Object object = this.mActiviteSyncObject;
        synchronized (object) {
            this.mMediaCodecSurface = surface;
            this.mAddCodecSurface = true;
            try {
                this.mActiviteSyncObject.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        this.mMonitorTread = new HandlerThread("VMonitor");
        this.mMonitorTread.start();
        this.mMonitorHandler = new Handler(this.mMonitorTread.getLooper());
    }

    private void MonitorTask() {
        this.mDropFrame = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMediaCodecSurface_l(Surface surface) {
        Object object = this.mActiviteSyncObject;
        synchronized (object) {
            if (surface != null) {
                this.mCodecSurfaceManager = new SurfaceManager((Object)surface, 2, this.mEGLContext, null);
            }
            this.mAddCodecSurface = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaCodecSurface() {
        Object object = this.mActiviteSyncObject;
        synchronized (object) {
            this.mRemoveCodecSurface = true;
            try {
                this.mActiviteSyncObject.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMediaCodecSurface_l() {
        Object object = this.mActiviteSyncObject;
        synchronized (object) {
            if (this.mCodecSurfaceManager != null) {
                this.mCodecSurfaceManager.release();
                this.mCodecSurfaceManager = null;
            }
            this.mRemoveCodecSurface = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessSurface(ProcessParam videoProcessParam) {
        if (this.playStartTime == 0L) {
            this.playStartTime = System.currentTimeMillis();
        }
        Object object = this.mThreadSyncObject;
        synchronized (object) {
            this.mProcessParam = videoProcessParam;
            try {
                if (this.mRenderThread != null) {
                    this.mRenderThread.start();
                }
                this.mThreadSyncObject.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        this.mNeedRending = false;
    }

    public synchronized void selectFilter(Context context, BasicFilter filter) {
        this.switchFilterTo(context, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFilterToDestory(BasicFilter basicFilter) {
        Object object = this.mActiviteSyncObject;
        synchronized (object) {
            try {
                if (null != this.mTextureRender) {
                    this.mTextureRender.addFilterToDestory(basicFilter);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupFilter(Context context, StickerGroupFilter filter) {
        Object object = this.mActiviteSyncObject;
        synchronized (object) {
            try {
                this.mStickersFilter = filter;
                this.mActiviteSyncObject.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchFilterTo(Context context, BasicFilter filter) {
        Object object = this.mActiviteSyncObject;
        synchronized (object) {
            try {
                this.mFilterWrap = filter;
                this.mNeedSetFilter = true;
                this.mActiviteSyncObject.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void updatePoints(MMCVInfo mmcvInfo) {
        if (null != this.mStickersFilter) {
            this.mStickersFilter.setMMCVInfo(mmcvInfo);
        }
    }

    private void selectFilter_l() {
        if (this.mTextureRender != null && this.mFilterWrap != null) {
            this.mTextureRender.selectFilter(this.mFilterWrap);
        }
        this.mNeedSetFilter = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void activiteSurface(Object surface) {
        this.mLastError = 0;
        Object object = this.mActiviteSyncObject;
        synchronized (object) {
            try {
                if (this.mScreenSurface != surface || surface == null) {
                    this.mNeedActiveSurface = true;
                }
                this.mScreenSurface = surface;
                this.mActiviteSyncObject.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public synchronized void release() {
        this.mNeedRending = false;
        try {
            if (this.mRenderThread != null) {
                this.mRenderShouldExit = true;
                try {
                    this.mRenderThread.join();
                }
                catch (InterruptedException e) {
                    this.mRenderThread.interrupt();
                }
                this.mRenderThread = null;
            }
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        this.mSurfaceTexture = null;
        this.mMediaCodecSurface = null;
        this.mEGLDisplay = EGL10.EGL_NO_DISPLAY;
        this.mEGLContext = EGL10.EGL_NO_CONTEXT;
        this.mEGLSurface = EGL10.EGL_NO_SURFACE;
        this.mEGLDumpSurface = EGL10.EGL_NO_SURFACE;
        this.mEGL = null;
    }

    private void activiteSurface_l() {
        try {
            this.eglSetup(this.mScreenSurface);
        }
        catch (IllegalArgumentException e) {
            this.mNeedRending = false;
            this.setLastErr(-1);
            return;
        }
        if (this.mScreenSurface == null) {
            this.makeUnCurrent();
            this.mNeedRending = false;
        } else {
            this.makeCurrent();
            this.mNeedRending = true;
        }
        this.setup();
        this.mNeedActiveSurface = false;
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
        for (EGLConfig config : configs) {
            int d = this.findConfigAttrib(egl, display, config, 12325, 0);
            int s = this.findConfigAttrib(egl, display, config, 12326, 0);
            if (d < 0 || s < 0) continue;
            int r = this.findConfigAttrib(egl, display, config, 12324, 0);
            int g = this.findConfigAttrib(egl, display, config, 12323, 0);
            int b = this.findConfigAttrib(egl, display, config, 12322, 0);
            int a = this.findConfigAttrib(egl, display, config, 12321, 0);
            if (r != 8 || g != 8 || b != 8 || a != 8) continue;
            return config;
        }
        return null;
    }

    private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
        if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
            return this.mValue[0];
        }
        return defaultValue;
    }

    private void eglSetup(Object mSurface) {
        if (this.mEGL == null) {
            this.mEGL = (EGL10)EGLContext.getEGL();
        }
        if (this.mEGLSurface != EGL10.EGL_NO_SURFACE) {
            this.mEGL.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface);
            this.mEGL.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.mEGLSurface = EGL10.EGL_NO_SURFACE;
        }
        if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            this.mEGLDisplay = this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (!this.mEGL.eglInitialize(this.mEGLDisplay, null)) {
                this.mLastError = -1;
                return;
            }
        }
        EGLConfig selectconfig = null;
        if (this.mConfigs == null) {
            this.mConfigs = new EGLConfig[1];
        }
        if (this.mNumConfigs == null) {
            this.mNumConfigs = new int[1];
        }
        if (mSurface != null) {
            if (!this.mEGL.eglChooseConfig(this.mEGLDisplay, this.mAttribList, null, 0, this.mNumConfigs)) {
                this.mLastError = -1;
                return;
            }
            int nConfigs = this.mNumConfigs[0];
            if (nConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] tconfigs = new EGLConfig[nConfigs];
            this.mEGL.eglChooseConfig(this.mEGLDisplay, this.mAttribList, tconfigs, nConfigs, this.mNumConfigs);
            selectconfig = this.chooseConfig(this.mEGL, this.mEGLDisplay, tconfigs);
        } else {
            if (!this.mEGL.eglChooseConfig(this.mEGLDisplay, this.mPbAttribListbAttribList, null, 0, this.mNumConfigs)) {
                this.mLastError = -1;
                return;
            }
            int nConfigs = this.mNumConfigs[0];
            if (nConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] tconfigs = new EGLConfig[nConfigs];
            this.mEGL.eglChooseConfig(this.mEGLDisplay, this.mPbAttribListbAttribList, tconfigs, nConfigs, this.mNumConfigs);
            selectconfig = this.chooseConfig(this.mEGL, this.mEGLDisplay, tconfigs);
        }
        if (this.mEGLContext == EGL10.EGL_NO_CONTEXT) {
            this.mEGLContext = this.mEGL.eglCreateContext(this.mEGLDisplay, selectconfig, EGL10.EGL_NO_CONTEXT, this.attrib_list);
            this.checkEglError("eglCreateContext");
            if (this.mEGLContext == null) {
                this.mLastError = -1;
                return;
            }
        }
        if (mSurface != null) {
            if (this.mEGLSurface == EGL10.EGL_NO_SURFACE) {
                this.mEGLSurface = this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, selectconfig, mSurface, null);
                this.checkEglError("eglCreateWindowSurface");
                if (this.mEGLSurface == null) {
                    this.mLastError = -1;
                    return;
                }
            }
            this.mEGL.eglQuerySurface(this.mEGLDisplay, this.mEGLSurface, 12374, this.mScreenHight);
            this.mEGL.eglQuerySurface(this.mEGLDisplay, this.mEGLSurface, 12375, this.mScreenWidth);
        } else {
            if (this.mEGLDumpSurface != EGL10.EGL_NO_SURFACE) {
                this.mEGL.eglDestroySurface(this.mEGLDisplay, this.mEGLDumpSurface);
                this.mEGLDumpSurface = EGL10.EGL_NO_SURFACE;
            }
            this.mSurfaceAttribs[1] = this.mOutImgW;
            this.mSurfaceAttribs[3] = this.mOutImgH;
            if (this.mEGLDumpSurface == EGL10.EGL_NO_SURFACE) {
                this.mEGLDumpSurface = this.mEGL.eglCreatePbufferSurface(this.mEGLDisplay, selectconfig, this.mSurfaceAttribs);
                this.checkEglError("eglCreatePbufferSurface");
                if (this.mEGLDumpSurface == null) {
                    this.mLastError = -1;
                    return;
                }
            }
        }
    }

    private void setup() {
        if (this.mTextureRender == null) {
            this.mTextureRender = new ProcessRender((BasicFilter)new NormalFilter(), this, this.mProcessParam);
            this.mTextureRender.setFrameRate(this.mEncoderFrameRate);
            this.mTextureRender.surfaceCreated();
            try {
                this.mSurfaceTexture = this.mTextureRender.getSurfaceTexture();
                this.mSurface = this.mTextureRender.getSurface();
                this.mTextureRender.setProcessListener(new VideoProcessListener(){

                    @Override
                    public void onProcessProgress(float progress) {
                        if (null != ProcessSurface.this.processListener) {
                            ProcessSurface.this.processListener.onProcessProgress(progress);
                        }
                    }

                    @Override
                    public void onProcessFinish(String videoPath) {
                        if (null != ProcessSurface.this.processListener) {
                            ProcessSurface.this.processListener.onProcessFinish(null);
                        }
                    }

                    @Override
                    public void onStart() {
                        if (null != ProcessSurface.this.processListener) {
                            ProcessSurface.this.processListener.onStart();
                        }
                    }

                    @Override
                    public void onFail(Exception ex) {
                        if (null != ProcessSurface.this.processListener) {
                            ProcessSurface.this.processListener.onFail(ex);
                        }
                    }
                });
                this.mTextureRender.startRender();
            }
            catch (Surface.OutOfResourcesException e) {
                this.mLastError = -1;
            }
        }
    }

    private void makeCurrent() {
        if (this.mEGL == null) {
            this.mLastError = -1;
            return;
        }
        this.checkEglError("before makeCurrent");
        if (this.mEGLSurface != EGL10.EGL_NO_SURFACE && this.mScreenHight[0] != 0 && this.mScreenWidth[0] != 0 && !this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext)) {
            this.mLastError = -1;
            return;
        }
    }

    private void makeUnCurrent() {
        if (this.mEGL == null) {
            this.mLastError = -1;
            return;
        }
        this.checkEglError("before makeUnCurrent");
        if (this.mEGLDumpSurface != EGL10.EGL_NO_SURFACE && !this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLDumpSurface, this.mEGLDumpSurface, this.mEGLContext)) {
            this.mLastError = -1;
            return;
        }
    }

    public int getLastErr() {
        return this.mLastError;
    }

    public void setLastErr(int err) {
        this.mLastError = err;
    }

    public synchronized Surface getSurface() {
        return this.mSurface;
    }

    public synchronized SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    private void drawImage() {
        long beginT;
        boolean i = false;
        boolean t = false;
        if (!this.mNeedRending) {
            this.makeUnCurrent();
        } else {
            this.makeCurrent();
        }
        if (this.mTextureRender == null) {
            return;
        }
        long startDraw = System.currentTimeMillis();
        ++this.renderLoop;
        if (!this.mNeedRending) {
            this.mTextureRender.drawFrame(0);
        } else {
            beginT = System.currentTimeMillis();
            this.mTextureRender.drawFrame(0);
            this.mEGL.eglSwapBuffers(this.mEGLDisplay, this.mEGLSurface);
            if (this.renderLoop < 20L) {
                this.renderToDT = this.renderToDT + System.currentTimeMillis() - beginT;
            } else {
                this.renderToDT = System.currentTimeMillis() - beginT;
                this.renderLoop = 1L;
            }
        }
        if (this.mCodecSurfaceManager != null) {
            beginT = System.currentTimeMillis();
            if (!this.mDropFrame && !this.shouldDrop.get()) {
                this.mCodecSurfaceManager.makeCurrent();
                this.mTextureRender.drawScreenFrame();
                this.mCodecSurfaceManager.swapBuffer();
            }
            this.renderToCT = this.renderLoop == 1L ? System.currentTimeMillis() - beginT : this.renderToCT + System.currentTimeMillis() - beginT;
            if (this.mBitrateAdapt) {
                this.mDropFrame = true;
                if (this.mMonitorHandler != null) {
                    this.mMonitorHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ProcessSurface.this.MonitorTask();
                        }
                    }, (long)(1000 / this.mEncoderFrameRate));
                }
            } else {
                this.mDropFrame = false;
            }
        }
        if (null != this.frameRefreshSoonListener) {
            this.frameRefreshSoonListener.frameRefresh();
        }
    }

    private void checkEglError(String msg) {
        int error;
        boolean failed = false;
        while ((error = this.mEGL.eglGetError()) != 12288) {
            failed = true;
            this.setLastErr(-1);
        }
        if (failed) {
            // empty if block
        }
    }

    public MediaCodec.BufferInfo getCurrentBuffer() {
        if (null != this.mTextureRender) {
            return this.mTextureRender.getCurrentBuffer();
        }
        return null;
    }

    private class RenderThread
    extends Thread {
        ProcessSurface mOwr;
        final int TIMEOUT_MS = 40;
        long now;
        long oldnow;
        long count;
        int i;
        int t;
        volatile boolean isRecording;

        RenderThread(ProcessSurface ower, String name) {
            super(name);
            this.TIMEOUT_MS = 40;
            this.count = 0L;
            this.i = 0;
            this.t = 0;
            this.isRecording = false;
            this.mOwr = ower;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ProcessSurface.this.mThreadSyncObject;
            synchronized (object) {
                ProcessSurface.this.mThreadSyncObject.notifyAll();
            }
            do {
                object = ProcessSurface.this.mActiviteSyncObject;
                synchronized (object) {
                    if (ProcessSurface.this.mNeedActiveSurface) {
                        ProcessSurface.this.activiteSurface_l();
                        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        if (ProcessSurface.this.mEGLSurface != EGL10.EGL_NO_SURFACE) {
                            ProcessSurface.this.mEGL.eglSwapBuffers(ProcessSurface.this.mEGLDisplay, ProcessSurface.this.mEGLSurface);
                        }
                    }
                    if (ProcessSurface.this.mNeedSetFilter) {
                        ProcessSurface.this.selectFilter_l();
                    }
                    if (ProcessSurface.this.mAddCodecSurface) {
                        ProcessSurface.this.addMediaCodecSurface_l(ProcessSurface.this.mMediaCodecSurface);
                        this.isRecording = true;
                    }
                    if (ProcessSurface.this.mRemoveCodecSurface) {
                        ProcessSurface.this.removeMediaCodecSurface_l();
                        this.isRecording = false;
                    }
                    ProcessSurface.this.mActiviteSyncObject.notifyAll();
                }
                object = ProcessSurface.this.mFrameSyncObject;
                synchronized (object) {
                    if (!ProcessSurface.this.mFrameAvailable) {
                        try {
                            ProcessSurface.this.mFrameSyncObject.wait(40L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!ProcessSurface.this.mFrameAvailable) {
                        continue;
                    }
                    ProcessSurface.this.drawImage();
                    ProcessSurface.this.mFrameAvailable = false;
                    ++this.i;
                    this.now = System.nanoTime() / 1000L;
                    if (this.i > 3) {
                        this.t = (int)((long)this.t + (this.now - this.oldnow));
                        ++this.count;
                    }
                    if (this.i > 20) {
                        long den = (long)this.t / this.count;
                        if (den > 0L) {
                            ProcessSurface.this.mRenderFRate = (int)(1000000L / den + 1L);
                        }
                        if (ProcessSurface.this.mRenderFRate > 0) {
                            ProcessSurface.this.mRenderTime = 1000 / ProcessSurface.this.mRenderFRate;
                        }
                        this.count = 0L;
                        this.oldnow = 0L;
                        this.now = 0L;
                        this.t = 0;
                        this.i = 0;
                    }
                    this.oldnow = this.now;
                }
            } while (!ProcessSurface.this.mRenderShouldExit);
            if (ProcessSurface.this.mFilterWrap != null) {
                ProcessSurface.this.mFilterWrap.destroy();
                ProcessSurface.this.mFilterWrap = null;
            }
            if (ProcessSurface.this.mStickersFilter != null) {
                ProcessSurface.this.mStickersFilter.destroy();
                ProcessSurface.this.mStickersFilter = null;
            }
            if (ProcessSurface.this.mTextureRender != null) {
                ProcessSurface.this.mTextureRender.release();
                ProcessSurface.this.mTextureRender = null;
            }
            if (ProcessSurface.this.mEGL != null) {
                ProcessSurface.this.mEGL.eglDestroySurface(ProcessSurface.this.mEGLDisplay, ProcessSurface.this.mEGLSurface);
                ProcessSurface.this.mEGL.eglDestroySurface(ProcessSurface.this.mEGLDisplay, ProcessSurface.this.mEGLDumpSurface);
                if (ProcessSurface.this.mEGL.eglGetCurrentContext().equals(ProcessSurface.this.mEGLContext)) {
                    ProcessSurface.this.mEGL.eglMakeCurrent(ProcessSurface.this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                }
                ProcessSurface.this.mEGL.eglDestroyContext(ProcessSurface.this.mEGLDisplay, ProcessSurface.this.mEGLContext);
                ProcessSurface.this.mEGL.eglTerminate(ProcessSurface.this.mEGLDisplay);
                ProcessSurface.this.mEGL = null;
            }
            ProcessSurface.this.mScreenSurface = null;
            object = ProcessSurface.this.mActiviteSyncObject;
            synchronized (object) {
                ProcessSurface.this.mActiviteSyncObject.notifyAll();
            }
        }
    }

    public static interface FrameRefreshSoonListener {
        public void frameRefresh();
    }
}

