/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.videoencoder;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.opengl.GLES20;
import android.view.Surface;
import com.momo.mcamera.videoencoder.ProcessParam;
import com.momo.mcamera.videoencoder.ProcessSurface;
import com.momo.mcamera.videoprocess.VideoProcessListener;
import com.momo.mcamera.videoprocess.VideoResourceProcessInput;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.ext.GLProcessingPipeline;
import project.android.imageprocessing.ext.GLScreenEndpoint;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.output.GLTextureInputRenderer;

class ProcessRender {
    private static final String TAG = "TextureRender";
    GLProcessingPipeline pipeline;
    VideoResourceProcessInput textureResourceInput;
    private SurfaceTexture mSurfaceTexture;
    private BasicFilter selectFilter;
    private GLScreenEndpoint screenEndpoint;
    private int previewWidth = 352;
    private int previewHeight = 640;
    private ProcessSurface processSurface;
    private VideoProcessListener processListener;
    private ProcessParam processParam;

    public void setProcessListener(VideoProcessListener processListener) {
        this.processListener = processListener;
    }

    public ProcessRender(BasicFilter filter, ProcessSurface processSurface, ProcessParam processParam) {
        this.processSurface = processSurface;
        this.processParam = processParam;
        this.previewWidth = processParam.getOutPutWidth();
        this.previewHeight = processParam.getOutPutHeight();
        this.initPipline(filter);
    }

    public void setFrameRate(int frameRate) {
        this.textureResourceInput.setFrameRate(frameRate);
    }

    public void startRender() {
        this.pipeline.startRendering();
        this.textureResourceInput.startVideoDecode();
        this.pipeline.onDrawFrame();
    }

    private void initPipline(BasicFilter glRenderer) {
        this.selectFilter = glRenderer;
        this.textureResourceInput = new VideoResourceProcessInput(this.processParam, this.processSurface);
        GLProcessingPipeline processingPipeline = new GLProcessingPipeline();
        processingPipeline.changeSize(this.previewWidth, this.previewHeight);
        this.textureResourceInput.setRenderSize(this.previewWidth, this.previewHeight);
        this.textureResourceInput.addTarget((GLTextureInputRenderer)this.selectFilter);
        this.screenEndpoint = new GLScreenEndpoint();
        this.selectFilter.addTarget((GLTextureInputRenderer)this.screenEndpoint);
        processingPipeline.addRootRenderer((GLRenderer)this.textureResourceInput);
        this.pipeline = processingPipeline;
        this.textureResourceInput.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                if (null != ProcessRender.this.processSurface) {
                    ProcessRender.this.processSurface.onFrameAvailable(surfaceTexture);
                }
            }
        });
        this.textureResourceInput.setProcessListener(new VideoProcessListener(){

            @Override
            public void onProcessProgress(float progress) {
                if (null != ProcessRender.this.processListener) {
                    ProcessRender.this.processListener.onProcessProgress(progress);
                }
            }

            @Override
            public void onProcessFinish(String videoPath) {
                if (null != ProcessRender.this.processListener) {
                    ProcessRender.this.processListener.onProcessFinish(null);
                }
            }

            @Override
            public void onStart() {
                if (null != ProcessRender.this.processListener) {
                    ProcessRender.this.processListener.onStart();
                }
            }

            @Override
            public void onFail(Exception ex) {
                if (null != ProcessRender.this.processListener) {
                    ProcessRender.this.processListener.onFail(ex);
                }
            }
        });
    }

    public void addFilterToDestory(BasicFilter basicFilter) {
        if (null != this.pipeline) {
            this.pipeline.addFilterToDestroy((GLRenderer)basicFilter);
        }
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    public void selectFilter(BasicFilter filter) {
        if (null != this.selectFilter) {
            this.textureResourceInput.removeTarget((GLTextureInputRenderer)this.selectFilter);
            this.pipeline.addFilterToDestroy((GLRenderer)this.selectFilter);
        }
        this.selectFilter = filter;
        this.textureResourceInput.addTarget((GLTextureInputRenderer)this.selectFilter);
        this.selectFilter.addTarget((GLTextureInputRenderer)this.screenEndpoint);
    }

    public void drawScreenFrame() {
        if (null != this.screenEndpoint) {
            this.screenEndpoint.onDrawFrame();
        }
    }

    public void drawFrame(int FrameBufferID) {
        if (null != this.pipeline) {
            this.pipeline.onDrawFrame();
        }
    }

    public SurfaceTexture createTexture() {
        if (null != this.textureResourceInput) {
            return this.textureResourceInput.getSurfaceTexture();
        }
        return null;
    }

    public void surfaceCreated() {
        this.mSurfaceTexture = this.createTexture();
    }

    public Surface getSurface() {
        if (null != this.textureResourceInput) {
            return this.textureResourceInput.getSurface();
        }
        return null;
    }

    public void release() {
        this.mSurfaceTexture = null;
        if (null != this.textureResourceInput) {
            this.textureResourceInput.stop();
        }
        if (null != this.pipeline) {
            this.pipeline.pauseRendering();
            this.pipeline.destroy();
            this.pipeline = null;
        }
        if (null != this.textureResourceInput) {
            this.textureResourceInput.destroy();
        }
        if (null != this.screenEndpoint) {
            this.screenEndpoint.destroy();
        }
        if (null != this.processListener) {
            this.processListener = null;
        }
        this.processSurface = null;
    }

    public void checkGlError(String op) {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
        }
    }

    public MediaCodec.BufferInfo getCurrentBuffer() {
        if (null != this.textureResourceInput) {
            return this.textureResourceInput.getCurrentBuffer();
        }
        return null;
    }
}

