/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.videoencoder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.view.Surface;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.videoencoder.MediaEncoder;
import com.momo.mcamera.videoencoder.MediaMuxerWrapper;
import com.momo.mcamera.videoencoder.ProcessSurface;
import java.io.IOException;

public class MediaVideoEncoder
extends MediaEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaVideoEncoder";
    private static final String MIME_TYPE = "video/avc";
    private static final int FRAME_RATE = 10;
    private static final float BPP = 0.25f;
    private int mWidth;
    private int mHeight;
    private Surface mSurface;
    private long mBitRate;
    protected static int[] recognizedFormats = new int[]{2130708361};

    public MediaVideoEncoder(MediaMuxerWrapper muxer, MediaEncoder.MediaEncoderListener listener, int width, int height, long bitRate) {
        super(muxer, listener);
        this.mWidth = width;
        this.mHeight = height;
        this.mBitRate = bitRate;
    }

    @Override
    @TargetApi(value=18)
    protected void prepare(ProcessSurface surface, MediaFormat format) throws IOException {
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mMuxerStarted = false;
        this.processSurface = surface;
        MediaCodecInfo videoCodecInfo = MediaVideoEncoder.selectVideoCodec(MIME_TYPE);
        if (videoCodecInfo == null) {
            return;
        }
        boolean hasFormat = format != null;
        format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", (int)this.mBitRate);
        format.setInteger("frame-rate", 10);
        format.setInteger("i-frame-interval", 10);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mMediaCodec.configure(format, null, null, 1);
        this.mSurface = this.mMediaCodec.createInputSurface();
        if (null != this.processSurface) {
            this.processSurface.addMediaCodecSurface(this.mSurface);
        }
        this.mMediaCodec.start();
        if (this.mListener != null) {
            try {
                this.mListener.onPrepared(this);
            }
            catch (Exception e) {
                MDLog.i((String)"MediaEncoder", (String)"MediaVideoEncoder prepare:", (Object[])new Object[]{e});
            }
        }
    }

    @Override
    protected void release() {
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        super.release();
    }

    private int calcBitRate() {
        int bitrate = (int)(2.5f * (float)this.mWidth * (float)this.mHeight);
        return bitrate;
    }

    @TargetApi(value=16)
    protected static final MediaCodecInfo selectVideoCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                int format;
                if (!types[j].equalsIgnoreCase(mimeType) || (format = MediaVideoEncoder.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                return codecInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    protected static final int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities caps;
        int result = 0;
        try {
            Thread.currentThread().setPriority(10);
            caps = codecInfo.getCapabilitiesForType(mimeType);
        }
        finally {
            Thread.currentThread().setPriority(5);
        }
        for (int i = 0; i < caps.colorFormats.length; ++i) {
            int colorFormat = caps.colorFormats[i];
            if (!MediaVideoEncoder.isRecognizedViewoFormat(colorFormat)) continue;
            if (result != 0) break;
            result = colorFormat;
            break;
        }
        if (result == 0) {
            MDLog.i((String)"MediaEncoder", (String)("MediaVideoEncoder couldn't find a good color format for " + codecInfo.getName() + " / " + mimeType));
        }
        return result;
    }

    private static final boolean isRecognizedViewoFormat(int colorFormat) {
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }

    @Override
    @TargetApi(value=18)
    protected void signalEndOfInputStream() {
        this.mMediaCodec.signalEndOfInputStream();
        this.mIsEOS = true;
    }
}

