/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.videoencoder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.videoencoder.MediaMuxerWrapper;
import com.momo.mcamera.videoencoder.ProcessSurface;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public abstract class MediaEncoder
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaEncoder";
    public ProcessSurface processSurface;
    protected static final int TIMEOUT_USEC = 10000;
    protected static final int MSG_FRAME_AVAILABLE = 1;
    protected static final int MSG_STOP_RECORDING = 9;
    int recordNumber;
    protected final Object mSync = new Object();
    protected volatile boolean mIsCapturing;
    private int mRequestDrain;
    protected volatile boolean mRequestStop;
    protected boolean mIsEOS;
    protected boolean mMuxerStarted;
    protected int mTrackIndex;
    public MediaCodec mMediaCodec;
    protected final WeakReference<MediaMuxerWrapper> mWeakMuxer;
    private MediaCodec.BufferInfo mBufferInfo;
    protected final MediaEncoderListener mListener;
    private long prevOutputPTSUs = 0L;
    private long startTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public MediaEncoder(MediaMuxerWrapper muxer, MediaEncoderListener listener) {
        if (listener == null) {
            throw new NullPointerException("MediaEncoderListener is null");
        }
        if (muxer == null) {
            throw new NullPointerException("MediaMuxerWrapper is null");
        }
        this.mWeakMuxer = new WeakReference<MediaMuxerWrapper>(muxer);
        muxer.addEncoder(this);
        this.mListener = listener;
        Object object = this.mSync;
        synchronized (object) {
            this.mBufferInfo = new MediaCodec.BufferInfo();
            new Thread((Runnable)this, this.getClass().getSimpleName()).start();
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getOutputPath() {
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        return muxer != null ? muxer.getOutputPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return false;
            }
            ++this.mRequestDrain;
            this.mSync.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Object object2 = this.mSync;
        synchronized (object2) {
            this.mRequestStop = false;
            this.mRequestDrain = 0;
            this.mSync.notify();
        }
        boolean isRunning = true;
        while (true) {
            boolean localRequestDrain;
            boolean localRequestStop;
            object = this.mSync;
            synchronized (object) {
                localRequestStop = this.mRequestStop;
                boolean bl = localRequestDrain = this.mRequestDrain > 0;
                if (localRequestDrain) {
                    --this.mRequestDrain;
                }
            }
            if (localRequestStop) {
                this.signalEndOfInputStream();
                this.release();
                break;
            }
            if (localRequestDrain) {
                this.drain();
                continue;
            }
            object = this.mSync;
            synchronized (object) {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
            this.mRequestStop = true;
            this.mIsCapturing = false;
        }
    }

    abstract void prepare(ProcessSurface var1, MediaFormat var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startRecording() {
        Object object = this.mSync;
        synchronized (object) {
            this.mIsCapturing = true;
            this.mRequestStop = false;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopRecording() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            this.mRequestStop = true;
            this.mSync.notifyAll();
        }
    }

    @TargetApi(value=16)
    protected void release() {
        this.mIsCapturing = false;
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mMuxerStarted) {
            MediaMuxerWrapper muxer;
            MediaMuxerWrapper mediaMuxerWrapper = muxer = this.mWeakMuxer != null ? (MediaMuxerWrapper)this.mWeakMuxer.get() : null;
            if (muxer != null) {
                try {
                    muxer.stop();
                    this.mListener.onStopped(this);
                }
                catch (Exception e) {
                    this.mListener.onStopped(this);
                }
            }
        }
        this.mBufferInfo = null;
    }

    protected void signalEndOfInputStream() {
        this.encode(null, 0, this.getPTSUs(this.processSurface.getCurrentBuffer()));
    }

    @TargetApi(value=16)
    protected void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        if (!this.mIsCapturing) {
            return;
        }
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                if (buffer != null) {
                    inputBuffer.put(buffer);
                }
                if (length <= 0) {
                    this.mIsEOS = true;
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, length, presentationTimeUs, 0);
                break;
            }
            if (inputBufferIndex != -1) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    protected void drain() {
        if (this.mMediaCodec == null) {
            return;
        }
        ByteBuffer[] encoderOutputBuffers = null;
        int count = 0;
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        if (muxer == null) {
            return;
        }
        block5: while (this.mIsCapturing) {
            int encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
            if (encoderStatus == -1) {
                if (this.mIsEOS || ++count <= 5) continue;
                break;
            }
            if (encoderStatus == -3) {
                encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
                continue;
            }
            if (encoderStatus == -2) {
                if (this.mMuxerStarted) {
                    throw new RuntimeException("format changed twice");
                }
                MediaFormat format = this.mMediaCodec.getOutputFormat();
                this.mTrackIndex = muxer.addTrack(format);
                this.mMuxerStarted = true;
                if (muxer.start()) continue;
                MediaMuxerWrapper mediaMuxerWrapper = muxer;
                synchronized (mediaMuxerWrapper) {
                    while (!muxer.isStarted()) {
                        try {
                            muxer.wait(100L);
                        }
                        catch (InterruptedException e) {
                            break block5;
                        }
                    }
                    continue;
                }
            }
            if (encoderStatus < 0) continue;
            encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
            ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
            if (encodedData == null) {
                this.processSurface.isRenderDrawing.set(false);
                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
            }
            if ((this.mBufferInfo.flags & 2) != 0) {
                this.mBufferInfo.size = 0;
            }
            if (this.mBufferInfo.size != 0) {
                boolean hasTempBuffer;
                count = 0;
                if (!this.mMuxerStarted) {
                    throw new RuntimeException("drain:muxer hasn't started");
                }
                boolean bl = hasTempBuffer = null != this.processSurface.getCurrentBuffer();
                if (!hasTempBuffer) {
                    if (null == this.processSurface) continue;
                    this.processSurface.isRenderDrawing.set(false);
                    MDLog.d((String)TAG, (String)("MediaEncoder drain:recorder isDrawing" + this.processSurface.isRenderDrawing));
                    continue;
                }
                this.mBufferInfo.presentationTimeUs = this.getPTSUs(this.processSurface.getCurrentBuffer());
                muxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                ++this.recordNumber;
                if (null != this.processSurface) {
                    this.processSurface.isRenderDrawing.set(false);
                }
                this.prevOutputPTSUs = this.mBufferInfo.presentationTimeUs;
            }
            this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
            if ((this.mBufferInfo.flags & 4) == 0) continue;
            this.mIsCapturing = false;
            break;
        }
    }

    @TargetApi(value=16)
    protected long getPTSUs(MediaCodec.BufferInfo bufferInfo) {
        if (null == bufferInfo) {
            long result = System.nanoTime() / 1000L;
            if (result < this.prevOutputPTSUs) {
                result = this.prevOutputPTSUs - result + result;
            }
            return result;
        }
        long result = this.prevOutputPTSUs == 0L ? (this.startTime = System.nanoTime() / 1000L) : this.startTime + this.processSurface.getCurrentBuffer().presentationTimeUs;
        return result;
    }

    public static interface MediaEncoderListener {
        public void onPrepared(MediaEncoder var1);

        public void onStopped(MediaEncoder var1);

        public void onFail(Exception var1);
    }
}

