/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import com.core.glcore.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CopyAssetsToSDCard
extends IntentService {
    private static final String KEY_FILTER_VERSION = "KEY_FILTER_VERSION";
    int Filter_Version = 9;
    int Sticker_Version = 1;

    public CopyAssetsToSDCard() {
        super("CopyAssetsToSDCard");
    }

    protected void onHandleIntent(Intent intent) {
        boolean shouldUpdate = false;
        String filterPath = FileUtil.getCacheDirectory((Context)this) + "/stickers.zip." + this.Filter_Version;
        String filterFolderPath = FileUtil.getCacheDirectory((Context)this) + "/stickers";
        File zipFile = new File(filterPath);
        if (!new File(filterFolderPath).exists() || shouldUpdate) {
            FileUtil.deleteFile((String)filterFolderPath);
            this.copyAssertFileToSDcard("stickers.zip", filterPath);
            try {
                FileUtil.ZipUtil.decompress((String)filterPath);
                if (zipFile.exists()) {
                    zipFile.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void copyRawFileToSDcard(int resid, String relativePath, String subFfix) {
        try {
            String filename = this.getResources().getResourceEntryName(resid) + subFfix;
            File file = new File(relativePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            file = new File(file, filename);
            InputStream in = this.getResources().openRawResource(resid);
            CopyAssetsToSDCard.copyAndCloseStream(in, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyAssertFileToSDcard(String fromFile, String toFile) {
        try {
            AssetManager assetsManager = this.getResources().getAssets();
            InputStream inputStream = assetsManager.open(fromFile);
            File file = new File(toFile).getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            CopyAssetsToSDCard.copyAndCloseStream(inputStream, new File(toFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndCloseStream(InputStream fromStream, File file) {
        FileOutputStream toStream = null;
        try {
            toStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while (fromStream.read(buffer) > 0) {
                toStream.write(buffer);
            }
            toStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fromStream != null) {
                    fromStream.close();
                }
                if (toStream != null) {
                    toStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyAssertFileToSDcard(Context context, String fromFile, String toFile) {
        try {
            AssetManager assetsManager = context.getResources().getAssets();
            InputStream inputStream = assetsManager.open(fromFile);
            File file = new File(toFile).getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            CopyAssetsToSDCard.copyAndCloseStream(inputStream, new File(toFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

