/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util;

import android.opengl.GLES20;
import com.momo.gl.utils.GpuUtils;
import com.momo.gl.utils.MatrixUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class BlendFilter {
    public static final String ATTRIBUTE_POSITION = "aVertexCo";
    public static final String ATTRIBUTE_TEXCOORD = "aTextureCo";
    public static final String VARYING_TEXCOORD = "vTextureCo";
    protected static final String UNIFORM_TEXTURE1 = "inputImageTexture1";
    public static final String UNIFORM_TEXTURE0 = "inputImageTexture10";
    private static final String SHADER_VETEX = "attribute vec4 aVertexCo;\nattribute vec2 aTextureCo;\n \nvarying vec2 vTextureCo;\n\nvoid main(){\n    gl_Position = aVertexCo;\n    vTextureCo = aTextureCo;\n}";
    private static final String SHADER_FRAGMENT = "precision mediump float;\nuniform sampler2D inputImageTexture10;\nuniform sampler2D inputImageTexture1;\nvarying vec2 vTextureCo;\nvoid main(){\n   vec4 color1 = texture2D(inputImageTexture10,vTextureCo);\n   vec4 color2 = texture2D(inputImageTexture1,vTextureCo);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.rgb = color1.rgb*(1.0 - color2.a) + color2.rgb*color2.a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n}\n";
    private int mGLProgram;
    private int textHandle;
    private int text1Handle;
    private int mGLVertexCo;
    private int mGLTextureCo;
    private FloatBuffer mVertexBuffer;
    private FloatBuffer mTextureBuffer;

    public BlendFilter() {
        this.initBuffer();
        this.createProgram();
        this.initHandles();
    }

    protected void initBuffer() {
        ByteBuffer vertex = ByteBuffer.allocateDirect(32);
        vertex.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = vertex.asFloatBuffer();
        this.mVertexBuffer.put(MatrixUtils.getOriginalVertexCo());
        this.mVertexBuffer.position(0);
        ByteBuffer texture = ByteBuffer.allocateDirect(32);
        texture.order(ByteOrder.nativeOrder());
        this.mTextureBuffer = texture.asFloatBuffer();
        this.mTextureBuffer.put(MatrixUtils.getOriginalTextureCo());
        this.mTextureBuffer.position(0);
    }

    public void createProgram() {
        this.mGLProgram = this.createGLProgram(SHADER_VETEX, SHADER_FRAGMENT);
    }

    private void initHandles() {
        this.mGLVertexCo = GLES20.glGetAttribLocation((int)this.mGLProgram, (String)ATTRIBUTE_POSITION);
        this.mGLTextureCo = GLES20.glGetAttribLocation((int)this.mGLProgram, (String)ATTRIBUTE_TEXCOORD);
        this.textHandle = GLES20.glGetUniformLocation((int)this.mGLProgram, (String)UNIFORM_TEXTURE0);
        this.text1Handle = GLES20.glGetUniformLocation((int)this.mGLProgram, (String)UNIFORM_TEXTURE1);
    }

    public void blend(int id1, int id2) {
        GLES20.glUseProgram((int)this.mGLProgram);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)id1);
        GLES20.glUniform1i((int)this.textHandle, (int)0);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)id2);
        GLES20.glUniform1i((int)this.text1Handle, (int)1);
        GLES20.glEnableVertexAttribArray((int)this.mGLVertexCo);
        GLES20.glVertexAttribPointer((int)this.mGLVertexCo, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLTextureCo);
        GLES20.glVertexAttribPointer((int)this.mGLTextureCo, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mTextureBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mGLVertexCo);
        GLES20.glDisableVertexAttribArray((int)this.mGLTextureCo);
    }

    private int createGLProgram(String vertexSource, String fragmentSource) {
        int vertex = GpuUtils.loadShader((int)35633, (String)vertexSource);
        if (vertex == 0) {
            return 0;
        }
        int fragment = GpuUtils.loadShader((int)35632, (String)fragmentSource);
        if (fragment == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)vertex);
            GLES20.glAttachShader((int)program, (int)fragment);
            this.bindShaderAttributes(program);
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    private void bindShaderAttributes(int program) {
        GLES20.glBindAttribLocation((int)program, (int)0, (String)ATTRIBUTE_POSITION);
        GLES20.glBindAttribLocation((int)program, (int)1, (String)ATTRIBUTE_TEXCOORD);
    }
}

