/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.skin;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import project.android.imageprocessing.filter.TwoPassMultiPixelFilter;
import project.android.imageprocessing.filter.processing.GaussianBlurFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class AISkinBlurFilter
extends TwoPassMultiPixelFilter
implements FaceDetectInterface {
    private MMCVInfo mMmcvInfo;
    private float mBlurSize = 0.0f;
    private int textureId = -1;
    private int textureInId = -1;
    private int textureBeforeId = -1;
    private boolean isDiscard = false;

    public AISkinBlurFilter(float _blurRadiusInPixels) {
        if (_blurRadiusInPixels >= 0.0f) {
            float minimumWeightToFindEdgeOfSamplingArea = 0.00390625f;
            this.mBlurSize = (float)Math.floor(Math.sqrt(-2.0 * Math.pow(_blurRadiusInPixels, 2.0) * Math.log((double)minimumWeightToFindEdgeOfSamplingArea * Math.sqrt(Math.PI * 2 * Math.pow(_blurRadiusInPixels, 2.0)))));
            this.mBlurSize += this.mBlurSize % 2.0f;
        }
    }

    public void drawSub() {
        super.drawSub();
        if (this.isDiscard) {
            return;
        }
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.programHandle);
        if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
            ArrayList<float[]> landmarks = new ArrayList<float[]>();
            for (int i = 0; i < this.mMmcvInfo.getMaxFaceCnt(); ++i) {
                landmarks.add(this.mMmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104());
            }
            float[][] array = AIFaceTriangulation.getFaceTriangulationBoundingBox((float[][])landmarks.toArray((T[])new float[this.mMmcvInfo.getMaxFaceCnt()][]), this.getWidth(), this.getHeight());
            float[] vertexCoord = array[0];
            float[] textureCoord = array[1];
            this.passShaderValues();
            ByteBuffer byteBuf_ver = ByteBuffer.allocateDirect(vertexCoord.length * 4);
            byteBuf_ver.order(ByteOrder.nativeOrder());
            FloatBuffer buffer_ver = byteBuf_ver.asFloatBuffer();
            buffer_ver.put(vertexCoord);
            buffer_ver.position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)buffer_ver);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            ByteBuffer byteBuf_tex = ByteBuffer.allocateDirect(textureCoord.length * 4);
            byteBuf_tex.order(ByteOrder.nativeOrder());
            FloatBuffer buffer_tex = byteBuf_tex.asFloatBuffer();
            buffer_tex.put(textureCoord);
            buffer_tex.position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)buffer_tex);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
        if (this.getCurrentPass() == 2) {
            this.disableDrawArray();
        }
    }

    public String getVertexShader() {
        return GaussianBlurFilter.getVertexShader((float)this.mBlurSize, (float)this.mBlurSize);
    }

    public String getFragmentShader() {
        return GaussianBlurFilter.getFragmentShader((float)this.mBlurSize, (float)this.mBlurSize);
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        this.mMmcvInfo = mmcvInfo;
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.textureInId != -1 && this.textureId != -1 && this.textureBeforeId != -1 && (texture != this.textureId || this.textureBeforeId != texture)) {
            this.isDiscard = true;
        }
        this.textureBeforeId = this.textureId;
        this.textureId = texture;
        this.textureInId = this.texture_in;
        super.newTextureReady(texture, source, newData);
    }
}

