/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.skin;

import android.graphics.PointF;
import android.graphics.RectF;
import com.core.glcore.util.JsonUtil;
import com.momo.mcamera.mask.LandMarksEntity;
import java.util.ArrayList;
import java.util.Arrays;

public class AIFaceTriangulation {
    private static LandMarksEntity sourceLandMark = null;
    public static int[] CXFaceTriangulationIndexes = new int[]{1, 0, 39, 1, 39, 50, 1, 50, 2, 0, 96, 19, 0, 19, 39, 2, 50, 49, 2, 49, 66, 2, 66, 3, 3, 66, 67, 3, 67, 4, 96, 97, 20, 96, 20, 19, 4, 67, 76, 4, 76, 5, 19, 20, 28, 19, 28, 39, 5, 76, 6, 20, 97, 21, 20, 21, 27, 20, 27, 28, 28, 27, 40, 28, 40, 39, 97, 98, 22, 97, 22, 21, 39, 40, 50, 40, 27, 41, 40, 41, 49, 40, 49, 50, 6, 76, 87, 6, 87, 7, 21, 22, 27, 27, 22, 26, 27, 26, 41, 41, 48, 49, 41, 26, 42, 41, 42, 48, 49, 48, 66, 48, 42, 47, 48, 47, 66, 42, 26, 43, 42, 43, 47, 26, 22, 23, 26, 23, 25, 26, 25, 43, 22, 98, 23, 7, 87, 86, 7, 86, 8, 98, 99, 23, 47, 43, 44, 47, 44, 46, 47, 46, 64, 47, 64, 65, 47, 65, 66, 43, 25, 44, 76, 67, 77, 76, 77, 88, 76, 88, 87, 46, 44, 45, 46, 45, 64, 25, 23, 24, 25, 24, 44, 44, 24, 63, 44, 63, 45, 23, 99, 24, 88, 77, 89, 88, 89, 95, 88, 95, 87, 45, 63, 64, 66, 65, 75, 66, 75, 67, 87, 95, 86, 77, 67, 78, 77, 78, 89, 67, 75, 68, 67, 68, 78, 8, 86, 85, 8, 85, 9, 24, 99, 100, 24, 100, 29, 24, 29, 74, 24, 74, 63, 65, 64, 72, 65, 72, 75, 86, 95, 94, 86, 94, 85, 95, 89, 90, 95, 90, 94, 89, 78, 90, 78, 68, 79, 78, 79, 90, 64, 63, 74, 64, 74, 73, 64, 73, 72, 68, 75, 69, 68, 69, 79, 75, 72, 71, 75, 71, 70, 75, 70, 69, 79, 69, 80, 79, 80, 90, 90, 80, 91, 90, 91, 93, 90, 93, 94, 94, 93, 84, 94, 84, 85, 85, 84, 10, 85, 10, 9, 69, 70, 80, 74, 29, 52, 74, 52, 51, 74, 51, 73, 73, 51, 62, 73, 62, 61, 73, 61, 72, 80, 70, 81, 80, 81, 91, 100, 101, 30, 100, 30, 29, 91, 81, 92, 91, 92, 93, 93, 92, 83, 93, 83, 84, 84, 83, 11, 84, 11, 10, 72, 61, 71, 29, 30, 38, 29, 38, 52, 70, 71, 15, 70, 15, 14, 70, 14, 82, 70, 82, 81, 81, 82, 92, 83, 92, 82, 83, 82, 12, 83, 12, 11, 51, 52, 62, 71, 61, 60, 71, 60, 59, 71, 59, 16, 71, 16, 15, 30, 101, 31, 30, 31, 37, 30, 37, 38, 52, 38, 53, 52, 53, 61, 52, 61, 62, 38, 37, 53, 82, 14, 13, 82, 13, 12, 53, 37, 54, 53, 54, 61, 61, 54, 60, 101, 102, 31, 31, 102, 32, 31, 32, 36, 31, 36, 37, 37, 36, 55, 37, 55, 54, 54, 55, 60, 60, 55, 59, 59, 55, 56, 59, 56, 58, 59, 58, 16, 55, 36, 56, 36, 32, 33, 36, 33, 35, 36, 35, 56, 32, 102, 33, 58, 56, 57, 58, 57, 17, 58, 17, 16, 56, 35, 57, 57, 35, 34, 57, 34, 18, 57, 18, 17, 102, 103, 33, 35, 33, 34, 33, 103, 34, 34, 103, 18};
    public static int[] CXFaceTriangulationIndexesWithCornerPoint = new int[]{0, 1, 96, 1, 2, 96, 22, 21, 96, 21, 20, 96, 20, 19, 96, 19, 0, 96, 24, 23, 29, 32, 33, 36, 33, 35, 36, 29, 30, 38, 30, 31, 38, 31, 37, 38, 31, 32, 37, 32, 36, 37, 33, 34, 35, 17, 18, 97, 18, 34, 97, 34, 33, 97, 33, 32, 97, 32, 31, 97, 31, 22, 97, 22, 96, 97, 30, 23, 31, 23, 22, 31, 29, 23, 30, 19, 20, 28, 20, 21, 28, 21, 27, 28, 21, 22, 27, 22, 26, 27, 22, 23, 26, 23, 25, 26, 1, 0, 39, 0, 19, 39, 19, 28, 39, 17, 16, 57, 51, 52, 62, 52, 61, 62, 52, 53, 61, 53, 60, 61, 53, 54, 60, 54, 55, 60, 55, 59, 60, 55, 58, 59, 58, 16, 59, 16, 15, 59, 55, 56, 58, 56, 57, 58, 57, 16, 58, 56, 35, 57, 35, 34, 57, 34, 18, 57, 18, 17, 57, 55, 36, 56, 36, 35, 56, 54, 36, 55, 53, 37, 54, 37, 36, 54, 52, 38, 53, 38, 37, 53, 51, 29, 52, 29, 38, 52, 45, 24, 63, 24, 29, 63, 29, 51, 74, 51, 73, 74, 73, 63, 74, 63, 29, 74, 4, 3, 66, 3, 2, 66, 2, 48, 66, 48, 65, 66, 6, 5, 76, 5, 4, 76, 4, 66, 76, 13, 12, 82, 6, 76, 87, 76, 77, 88, 77, 88, 89, 95, 88, 89, 87, 76, 88, 77, 78, 89, 86, 7, 87, 7, 6, 87, 85, 8, 86, 8, 7, 86, 79, 80, 90, 86, 87, 95, 87, 88, 95, 89, 90, 95, 79, 90, 89, 89, 79, 78, 90, 94, 95, 94, 85, 95, 85, 86, 95, 84, 10, 85, 10, 9, 85, 9, 8, 85, 80, 81, 91, 90, 91, 94, 91, 93, 94, 93, 84, 94, 84, 85, 94, 91, 92, 93, 93, 83, 92, 92, 91, 81, 83, 84, 93, 90, 80, 91, 83, 11, 84, 11, 10, 84, 81, 82, 92, 82, 83, 92, 82, 12, 83, 12, 11, 83, 81, 71, 82, 71, 14, 82, 14, 13, 82, 80, 70, 81, 70, 71, 81, 79, 69, 80, 69, 70, 80, 78, 68, 79, 68, 69, 79, 77, 67, 78, 67, 68, 78, 76, 66, 77, 66, 67, 77, 66, 65, 67, 60, 59, 71, 59, 15, 71, 15, 14, 71, 64, 63, 73, 51, 62, 73, 62, 61, 73, 61, 72, 73, 61, 60, 72, 60, 71, 72, 71, 70, 72, 68, 67, 75, 67, 65, 75, 65, 64, 75, 64, 73, 75, 73, 72, 75, 72, 70, 75, 70, 69, 75, 69, 68, 75, 48, 47, 65, 47, 64, 65, 47, 46, 64, 46, 45, 64, 45, 63, 64, 1, 39, 50, 39, 40, 50, 40, 49, 50, 49, 1, 50, 40, 41, 49, 41, 42, 49, 42, 48, 49, 48, 2, 49, 2, 1, 49, 42, 43, 48, 43, 47, 48, 43, 44, 47, 44, 46, 47, 44, 45, 46, 44, 24, 45, 43, 25, 44, 25, 24, 44, 42, 26, 43, 26, 25, 43, 41, 27, 42, 27, 26, 42, 40, 28, 41, 28, 27, 41, 39, 28, 40, 23, 24, 25, 9, 10, 98, 10, 11, 98, 11, 12, 98, 12, 13, 98, 13, 14, 98, 14, 15, 98, 15, 16, 98, 16, 17, 98, 17, 97, 98, 96, 2, 99, 2, 3, 99, 3, 4, 99, 4, 5, 99, 5, 6, 99, 6, 7, 99, 7, 8, 99, 8, 9, 99, 9, 98, 99};
    int[] CXFaceLipsTrianglesIndices = new int[]{55, 56, 64, 66, 72, 70, 87, 83, 89, 99, 100, 103, 104, 115, 118, 120, 121, 131, 132, 84};
    int[] CXFaceInsideMouthTrianglesIndices = new int[]{65, 86, 85, 102, 101, 119};
    int[] CXFaceEyeTrianglesIndices = new int[]{24, 26, 27, 33, 35, 37, 40, 48, 49, 57, 135, 145, 144, 150, 151, 158, 159, 160, 161, 168};
    int[] CXFaceLipsSamplePointsIndices = new int[]{76, 88, 77, 88, 77, 89, 78, 89, 78, 90, 79, 91, 79, 90, 80, 91, 80, 90, 80, 92, 81, 91, 81, 92, 82, 92, 83, 93, 83, 92, 84, 94, 84, 93, 85, 93, 85, 94, 85, 95, 86, 95, 86, 94, 86, 88, 87, 95, 87, 88};
    int[] CXFaceEyesSampleLeftPointsIndices = new int[]{39, 45, 40, 50, 41, 49, 42, 48, 43, 47, 44, 46};
    int[] CXFaceEyesSampleRightPointsIndices = new int[]{51, 57, 52, 62, 53, 61, 54, 60, 55, 59, 56, 58};
    static int[] CXForeheadForSkinSmoothing = new int[]{3, 11, 10, 17, 23, 22, 44, 47, 63, 77, 78, 117, 116, 140, 152, 153, 167, 175, 177, 178, 14, 19, 18, 30, 31, 41, 42, 59, 61, 80, 79, 108, 125, 142, 141, 155, 154, 164, 165, 176, 15, 21, 20, 25, 32, 34, 39, 43, 53, 60, 126, 143, 146, 149, 157, 156, 163, 166, 171, 172, 109, 62};
    private static String ResourceIndices = "{\"landmarks\":[0.17381913959980011,0.36590975522994995,0.17343476414680481,0.45132774114608765,0.17952266335487366,0.53483086824417114,0.19504062831401825,0.61835271120071411,0.22000625729560852,0.69837069511413574,0.25672107934951782,0.77097654342651367,0.30425351858139038,0.83225393295288086,0.35966679453849792,0.88374727964401245,0.42392188310623169,0.92303907871246338,0.5,0.93746602535247803,0.57607811689376831,0.92303907871246338,0.64033317565917969,0.88374727964401245,0.69574648141860962,0.83225393295288086,0.74327892065048218,0.77097654342651367,0.7799949049949646,0.69837069511413574,0.80495935678482056,0.61835271120071411,0.82047736644744873,0.53483086824417114,0.8265652060508728,0.45132774114608765,0.82618087530136108,0.36590975522994995,0.24124883115291595,0.30859804153442383,0.27332773804664612,0.27773436903953552,0.31262305378913879,0.26756834983825684,0.35610780119895935,0.26917734742164612,0.3964601457118988,0.27981209754943848,0.42941209673881531,0.30895546078681946,0.39010274410247803,0.30991172790527344,0.35250547528266907,0.30544686317443848,0.31406915187835693,0.30341249704360962,0.27819451689720154,0.30576211214065552,0.5705878734588623,0.30895546078681946,0.60353982448577881,0.27981209754943848,0.64389216899871826,0.26917734742164612,0.68737697601318359,0.26756834983825684,0.72667229175567627,0.27773436903953552,0.75875115394592285,0.30859804153442383,0.72180545330047607,0.30576211214065552,0.68593084812164307,0.30341249704360962,0.64749455451965332,0.30544686317443848,0.60989725589752197,0.30991172790527344,0.28534296154975891,0.39112147688865662,0.30294102430343628,0.37785467505455017,0.32349219918251038,0.37033006548881531,0.34780508279800415,0.36749881505966187,0.37202772498130798,0.37081524729728699,0.39217227697372437,0.37998515367507935,0.40819764137268066,0.39611953496932983,0.38928008079528809,0.40417501330375671,0.36902889609336853,0.40866446495056152,0.34640586376190186,0.41022539138793945,0.32359415292739868,0.40777969360351562,0.30373907089233398,0.40177264809608459,0.59180235862731934,0.39611953496932983,0.60782772302627563,0.37998515367507935,0.62797224521636963,0.37081524729728699,0.65219491720199585,0.36749881505966187,0.67650783061981201,0.37033006548881531,0.69705897569656372,0.37785467505455017,0.7146570086479187,0.39112147688865662,0.69626092910766602,0.40177264809608459,0.67640584707260132,0.40777969360351562,0.65359413623809814,0.41022539138793945,0.63097107410430908,0.40866446495056152,0.61071991920471191,0.40417501330375671,0.45767068862915039,0.38329803943634033,0.4549601674079895,0.45272812247276306,0.44386601448059082,0.5192297101020813,0.40819764137268066,0.55948829650878906,0.41915586590766907,0.60649454593658447,0.47767460346221924,0.6165691614151001,0.52232539653778076,0.6165691614151001,0.58084416389465332,0.60649454593658447,0.59180235862731934,0.55948829650878906,0.55613398551940918,0.5192297101020813,0.5450398325920105,0.45272812247276306,0.54232931137084961,0.38329803943634033,0.5,0.56499141454696655,0.37769374251365662,0.72207772731781006,0.41271290183067322,0.69964921474456787,0.45415157079696655,0.685555100440979,0.5,0.68645507097244263,0.54584842920303345,0.685555100440979,0.58728712797164917,0.69964921474456787,0.622306227684021,0.72207772731781006,0.59076994657516479,0.76110583543777466,0.55109494924545288,0.78622734546661377,0.5,0.79547578096389771,0.44890508055686951,0.78622734546661377,0.40923008322715759,0.76110583543777466,0.40211796760559082,0.7258874773979187,0.4501953125,0.71846014261245728,0.5,0.71899807453155518,0.5498046875,0.71846014261245728,0.59788203239440918,0.7258874773979187,0.55061328411102295,0.73992770910263062,0.5,0.74535119533538818,0.44938671588897705,0.73992770910263062,0.20532616972923279,0.19155703485012054,0.27824842929840088,0.14062969386577606,0.36244061589241028,0.10667707026004791,0.45339569449424744,0.089701056480407715,0.54660427570343018,0.089701056480407715,0.63755935430526733,0.10667707026004791,0.72175157070159912,0.14062969386577606,0.79467380046844482,0.19155703485012054]}";

    public RectF[] getFaceLocalBoundingBox(float[] pointlandmarks104, int[] localArray) {
        float[][] faceLocal = this.getFaceLocalTriangulation(pointlandmarks104, localArray);
        RectF[] boundingBox = new RectF[faceLocal.length];
        for (int i = 0; i < faceLocal.length; ++i) {
            float minX = 1.0f;
            float minY = 1.0f;
            float maxX = -1.0f;
            float maxY = -1.0f;
            for (int n = 0; n < faceLocal[i].length / 2; ++n) {
                minX = Math.min(faceLocal[i][n * 2], minX);
                minY = Math.min(faceLocal[i][n * 2 + 1], minY);
                maxX = Math.max(faceLocal[i][n * 2], maxX);
                maxY = Math.max(faceLocal[i][n * 2 + 1], maxY);
            }
            boundingBox[i].set(minX, minY, maxX, maxY);
        }
        return boundingBox;
    }

    float[][] getFaceLocalTriangulation(float[] pointlandmarks104, int[] targetArray) {
        int pointSize = 3;
        float[][] resultArray = new float[2][targetArray.length * pointSize * 2];
        float[] vertex = new float[targetArray.length * pointSize * 2];
        float[] texture = new float[targetArray.length * pointSize * 2];
        int offset = pointlandmarks104.length / 2;
        int dimension = pointSize * 2;
        for (int i = 0; i < targetArray.length; ++i) {
            int it = targetArray[i];
            int point1 = CXFaceTriangulationIndexes[it * pointSize];
            int point2 = CXFaceTriangulationIndexes[it * pointSize + 1];
            int point3 = CXFaceTriangulationIndexes[it * pointSize + 2];
            float ax = pointlandmarks104[point1];
            float ay = pointlandmarks104[point1 + offset];
            float bx = pointlandmarks104[point2];
            float by = pointlandmarks104[point2 + offset];
            float cx = pointlandmarks104[point3];
            float cy = pointlandmarks104[point3 + offset];
            texture[i * dimension] = ax;
            texture[i * dimension + 1] = 1.0f - ay;
            texture[i * dimension + 2] = bx;
            texture[i * dimension + 3] = 1.0f - by;
            texture[i * dimension + 4] = cx;
            texture[i * dimension + 5] = 1.0f - cy;
            vertex[i * dimension] = ax * 2.0f - 1.0f;
            vertex[i * dimension + 1] = -(ay * 2.0f - 1.0f);
            vertex[i * dimension + 2] = bx * 2.0f - 1.0f;
            vertex[i * dimension + 3] = -(by * 2.0f - 1.0f);
            vertex[i * dimension + 4] = cx * 2.0f - 1.0f;
            vertex[i * dimension + 5] = -(cy * 2.0f - 1.0f);
        }
        resultArray[0] = vertex;
        resultArray[1] = texture;
        return resultArray;
    }

    public static float[][] getFaceLocalTriangulation(float[] pointlandmarks104, int[] targetArray, boolean filterNot) {
        int i;
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        if (filterNot) {
            for (i = 0; i < CXFaceTriangulationIndexes.length; ++i) {
                if (Arrays.asList(new int[][]{targetArray}).contains(i / 3)) continue;
                indexs.add(CXFaceTriangulationIndexes[i]);
            }
        } else {
            for (i = 0; i < CXFaceTriangulationIndexes.length; ++i) {
                if (!Arrays.asList(new int[][]{targetArray}).contains(i / 3)) continue;
                indexs.add(CXFaceTriangulationIndexes[i]);
            }
        }
        int dimension = 2;
        float[][] resultArray = new float[3][indexs.size() * dimension];
        float[] vertex = new float[indexs.size() * dimension];
        float[] texture = new float[indexs.size() * dimension];
        float[] source = new float[indexs.size() * dimension];
        int offset = 104;
        if (sourceLandMark == null) {
            sourceLandMark = (LandMarksEntity)JsonUtil.getInstance().fromJson(ResourceIndices, LandMarksEntity.class);
        }
        for (int i2 = 0; i2 < indexs.size(); ++i2) {
            float x = pointlandmarks104[(Integer)indexs.get(i2)];
            float y = pointlandmarks104[(Integer)indexs.get(i2) + offset];
            vertex[i2 * dimension] = x * 2.0f - 1.0f;
            vertex[i2 * dimension + 1] = -(y * 2.0f - 1.0f);
            texture[i2 * dimension] = x;
            texture[i2 * dimension + 1] = 1.0f - y;
            source[i2 * dimension] = sourceLandMark.getLandmarks()[(Integer)indexs.get(i2) * 2];
            source[i2 * dimension + 1] = sourceLandMark.getLandmarks()[(Integer)indexs.get(i2) * 2 + 1];
        }
        resultArray[0] = vertex;
        resultArray[1] = texture;
        resultArray[2] = source;
        return resultArray;
    }

    public static float[][] getFaceSkinHead(float[] pointlandmarks104, boolean isbelow) {
        if (pointlandmarks104 == null) {
            return null;
        }
        return AIFaceTriangulation.getFaceLocalTriangulation(pointlandmarks104, CXForeheadForSkinSmoothing, false);
    }

    public static float[][] getfaceSkinBelowHead(float[] pointlandmarks104, boolean isbelow) {
        if (pointlandmarks104 == null) {
            return null;
        }
        return AIFaceTriangulation.getFaceLocalTriangulation(pointlandmarks104, CXForeheadForSkinSmoothing, true);
    }

    public static float[][] getFaceTriangulation(float[] pointlandmarks104) {
        float[][] resultArray = new float[3][CXFaceTriangulationIndexes.length * 2];
        float[] vertex = new float[CXFaceTriangulationIndexes.length * 2];
        float[] texture = new float[CXFaceTriangulationIndexes.length * 2];
        float[] source = new float[CXFaceTriangulationIndexes.length * 2];
        int offset = pointlandmarks104.length / 2;
        if (sourceLandMark == null) {
            sourceLandMark = (LandMarksEntity)JsonUtil.getInstance().fromJson(ResourceIndices, LandMarksEntity.class);
        }
        for (int i = 0; i < CXFaceTriangulationIndexes.length; ++i) {
            int index = CXFaceTriangulationIndexes[i];
            float x = pointlandmarks104[index];
            float y = pointlandmarks104[index + 104];
            texture[i * 2] = x;
            texture[i * 2 + 1] = 1.0f - y;
            vertex[i * 2] = x * 2.0f - 1.0f;
            vertex[i * 2 + 1] = -(y * 2.0f - 1.0f);
            source[i * 2] = sourceLandMark.getLandmarks()[index * 2];
            source[i * 2 + 1] = sourceLandMark.getLandmarks()[index * 2 + 1];
        }
        resultArray[0] = vertex;
        resultArray[1] = texture;
        resultArray[2] = source;
        return resultArray;
    }

    public static float[][] getFaceTriangulation(float[] pointlandmarks104, int width, int height, float[] landmarks) {
        if (landmarks == null) {
            if (sourceLandMark == null) {
                sourceLandMark = (LandMarksEntity)JsonUtil.getInstance().fromJson(ResourceIndices, LandMarksEntity.class);
            }
            landmarks = sourceLandMark.getLandmarks();
        }
        if (landmarks.length == 192) {
            landmarks = Util.landmark96To104(landmarks);
        }
        float[][] resultArray = new float[3][CXFaceTriangulationIndexes.length * 2];
        float[] vertex = new float[CXFaceTriangulationIndexes.length * 2];
        float[] texture = new float[CXFaceTriangulationIndexes.length * 2];
        float[] source = new float[CXFaceTriangulationIndexes.length * 2];
        int offset = pointlandmarks104.length / 2;
        for (int i = 0; i < CXFaceTriangulationIndexes.length; ++i) {
            int index = CXFaceTriangulationIndexes[i];
            float x = pointlandmarks104[index] / (float)width;
            float y = pointlandmarks104[index + 104] / (float)height;
            texture[i * 2] = x;
            texture[i * 2 + 1] = 1.0f - y;
            vertex[i * 2] = x * 2.0f - 1.0f;
            vertex[i * 2 + 1] = -(y * 2.0f - 1.0f);
            source[i * 2] = landmarks[index * 2];
            source[i * 2 + 1] = landmarks[index * 2 + 1];
        }
        resultArray[0] = vertex;
        resultArray[1] = texture;
        resultArray[2] = source;
        return resultArray;
    }

    public static float[][] getFaceTriangulationWithCornerPoint(float[] pointlandmarks, float[] landmarks) {
        float[][] resultArray = new float[3][CXFaceTriangulationIndexesWithCornerPoint.length * 2];
        float[] vertex = new float[CXFaceTriangulationIndexesWithCornerPoint.length * 2];
        float[] texture = new float[CXFaceTriangulationIndexesWithCornerPoint.length * 2];
        float[] source = new float[CXFaceTriangulationIndexesWithCornerPoint.length * 2];
        for (int i = 0; i < CXFaceTriangulationIndexesWithCornerPoint.length; ++i) {
            int index = CXFaceTriangulationIndexesWithCornerPoint[i];
            float x = pointlandmarks[index * 2];
            float y = pointlandmarks[index * 2 + 1];
            texture[i * 2] = x;
            texture[i * 2 + 1] = 1.0f - y;
            vertex[i * 2] = x * 2.0f - 1.0f;
            vertex[i * 2 + 1] = -(y * 2.0f - 1.0f);
            source[i * 2] = landmarks[index * 2];
            source[i * 2 + 1] = landmarks[index * 2 + 1];
        }
        resultArray[0] = vertex;
        resultArray[1] = texture;
        resultArray[2] = source;
        return resultArray;
    }

    public static float getFaceTriangulationWidth(float[] landmarks104) {
        if (landmarks104 == null || landmarks104.length == 0) {
            throw new IllegalArgumentException("104\u70b9\u4e3a\u7a7a");
        }
        float faceWidth1 = Math.abs(landmarks104[0] - landmarks104[18]);
        return faceWidth1;
    }

    public static float getFaceTriangulationWidth(float[] landmarks104, float ratio) {
        if (landmarks104 == null || landmarks104.length == 0) {
            throw new IllegalArgumentException("104\u70b9\u4e3a\u7a7a");
        }
        float x1 = landmarks104[0];
        float y1 = landmarks104[104];
        float x2 = landmarks104[18];
        float y2 = landmarks104[122];
        double width = Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0)) * (double)ratio;
        return (float)width;
    }

    static float[][] getFaceTriangulationBoundingBox(float[][] landmarks104, int width, int height) {
        float[][] resultArray = new float[2][8];
        float minX = width;
        float minY = height;
        float maxX = -1.0f;
        float maxY = -1.0f;
        float[] vertex = new float[8];
        float[] fragment = new float[8];
        if (landmarks104 == null || landmarks104.length <= 0) {
            throw new IllegalArgumentException("104\u70b9\u4e3a\u7a7a");
        }
        int offset = landmarks104[0].length / 2;
        for (int i = 0; i < landmarks104.length; ++i) {
            float[] it = landmarks104[i];
            for (int j = 0; j < it.length / 2; ++j) {
                minX = Math.min(it[j], minX);
                minY = Math.min(it[j + offset], minY);
                maxX = Math.max(it[j], maxX);
                maxY = Math.max(it[j + offset], maxY);
            }
        }
        fragment[0] = minX / (float)width;
        fragment[1] = 1.0f - minY / (float)height;
        fragment[2] = minX / (float)width;
        fragment[3] = 1.0f - maxY / (float)height;
        fragment[4] = maxX / (float)width;
        fragment[5] = 1.0f - minY / (float)height;
        fragment[6] = maxX / (float)width;
        fragment[7] = 1.0f - maxY / (float)height;
        vertex[0] = minX / (float)width * 2.0f - 1.0f;
        vertex[1] = -(minY / (float)height * 2.0f - 1.0f);
        vertex[2] = minX / (float)width * 2.0f - 1.0f;
        vertex[3] = -(maxY / (float)height * 2.0f - 1.0f);
        vertex[4] = maxX / (float)width * 2.0f - 1.0f;
        vertex[5] = -(minY / (float)height * 2.0f - 1.0f);
        vertex[6] = maxX / (float)width * 2.0f - 1.0f;
        vertex[7] = -(maxY / (float)height * 2.0f - 1.0f);
        resultArray[0] = vertex;
        resultArray[1] = fragment;
        return resultArray;
    }

    public float[][] getFaceTriangulationBoundingBox(float[][] pointlandmarks104s) {
        float[][] resultArray = new float[2][8];
        float minX = 1.0f;
        float minY = 1.0f;
        float maxX = -1.0f;
        float maxY = -1.0f;
        float[] vertex = new float[8];
        float[] fragment = new float[8];
        int offset = pointlandmarks104s.length / 2;
        if (pointlandmarks104s == null || pointlandmarks104s.length == 0) {
            throw new IllegalArgumentException("104\u70b9\u4e3a\u7a7a");
        }
        for (int i = 0; i < pointlandmarks104s.length; ++i) {
            float[] it = pointlandmarks104s[i];
            for (int j = 0; j < it.length / 2; ++j) {
                minX = Math.min(it[i], minX);
                minY = Math.min(it[i + offset], minY);
                maxX = Math.max(it[i], maxX);
                maxY = Math.max(it[i + offset], maxY);
            }
        }
        fragment[0] = minX;
        fragment[1] = 1.0f - minY;
        fragment[2] = minX;
        fragment[3] = 1.0f - maxY;
        fragment[4] = maxX;
        fragment[5] = 1.0f - minY;
        fragment[6] = maxX;
        fragment[7] = 1.0f - maxY;
        vertex[0] = minX * 2.0f - 1.0f;
        vertex[1] = -(minY * 2.0f - 1.0f);
        vertex[2] = minX * 2.0f - 1.0f;
        vertex[3] = -(maxY * 2.0f - 1.0f);
        vertex[4] = maxX * 2.0f - 1.0f;
        vertex[5] = -(minY * 2.0f - 1.0f);
        vertex[6] = maxX * 2.0f - 1.0f;
        vertex[7] = -(maxY * 2.0f - 1.0f);
        resultArray[0] = vertex;
        resultArray[1] = fragment;
        return resultArray;
    }

    float[] landMark104ToPoint(float[] landmarks104, int width, int height) {
        float[] resultArray = new float[landmarks104.length];
        int size = landmarks104.length;
        for (int i = 0; i < size / 2; ++i) {
            resultArray[i] = landmarks104[i] / (float)width;
            resultArray[i + size / 2] = landmarks104[i + size / 2] / (float)height;
        }
        return resultArray;
    }

    public float[] sampleTextureCoordinatesBetweenVertexIndices(int[] indices, float[] pointLandMark) {
        int count = indices.length / 2;
        int offset = pointLandMark.length / 2;
        float[] result = new float[count * 2];
        for (int i = 0; i < count; ++i) {
            int from = indices[i * 2];
            int to = indices[i * 2 + 1];
            PointF pointFrom = new PointF(pointLandMark[from], pointLandMark[from + offset]);
            PointF pointTo = new PointF(pointLandMark[to], pointLandMark[to + offset]);
            PointF pointMid = new PointF((pointFrom.x + pointTo.x) * 0.5f, (pointFrom.y + pointTo.y) * 0.5f);
            result[i * 2] = pointMid.x;
            result[i * 2 + 1] = 1.0f - pointMid.y;
        }
        return result;
    }

    public static void setSourceLandMark(float[] landMark) {
        if (sourceLandMark == null) {
            sourceLandMark = new LandMarksEntity();
        }
        sourceLandMark.setLandmarks(landMark);
    }

    private static class Util {
        private Util() {
        }

        private static float[] landmark96To104(float[] landmarks) {
            if (landmarks.length != 192) {
                return new float[0];
            }
            float[] appendPoint = new float[]{0.15690625f, 0.21404395f, 0.255417f, 0.15401465f, 0.35002735f, 0.112371095f, 0.44257325f, 0.08943467f, 0.5348916f, 0.08552559f, 0.6288174f, 0.10096582f, 0.72618943f, 0.1360752f, 0.8288418f, 0.19117676f};
            float[] landMark104 = new float[208];
            System.arraycopy(landmarks, 0, landMark104, 0, 192);
            System.arraycopy(appendPoint, 0, landMark104, 192, 16);
            return landMark104;
        }

        private static float[] extend96Points(float[] pts) {
            float[] ext_pts = new float[200];
            System.arraycopy(pts, 0, ext_pts, 0, 96);
            float[] extXs = new float[4];
            float[] extYs = new float[4];
            Util.interuptPoints(pts, extXs, extYs, 66, 49, 2.4f, 0);
            Util.interuptPoints(pts, extXs, extYs, 66, 45, 3.46f, 1);
            Util.interuptPoints(pts, extXs, extYs, 71, 51, 3.46f, 2);
            Util.interuptPoints(pts, extXs, extYs, 71, 59, 2.4f, 3);
            System.arraycopy(extXs, 0, ext_pts, 96, extXs.length);
            System.arraycopy(pts, 96, ext_pts, 100, 96);
            System.arraycopy(extYs, 0, ext_pts, 196, extYs.length);
            return ext_pts;
        }

        private static void interuptPoints(float[] srcPoints, float[] containerX, float[] containerY, int start, int end, float offsetRatio, int index) {
            float vec_x = srcPoints[end] - srcPoints[start];
            float vec_y = srcPoints[end + 96] - srcPoints[start + 96];
            containerX[index] = srcPoints[start] + offsetRatio * vec_x;
            containerY[index] = srcPoints[start + 96] + offsetRatio * vec_y;
        }

        private static void curve4(PointF[] p, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
            PointF tmp2;
            PointF tmp0;
            int NUM_STEPS = 6;
            p[0] = tmp0 = new PointF(x1, y1);
            float subdiv_step = 1.0f / (float)(NUM_STEPS + 1);
            float subdiv_step2 = subdiv_step * subdiv_step;
            float subdiv_step3 = subdiv_step * subdiv_step * subdiv_step;
            float pre1 = 3.0f * subdiv_step;
            float pre2 = 3.0f * subdiv_step2;
            float pre4 = 6.0f * subdiv_step2;
            float pre5 = 6.0f * subdiv_step3;
            float tmp1x = x1 - x2 * 2.0f + x3;
            float tmp1y = y1 - y2 * 2.0f + y3;
            float tmp2x = (x2 - x3) * 3.0f - x1 + x4;
            float tmp2y = (y2 - y3) * 3.0f - y1 + y4;
            float fx = x1;
            float fy = y1;
            float dfx = (x2 - x1) * pre1 + tmp1x * pre2 + tmp2x * subdiv_step3;
            float dfy = (y2 - y1) * pre1 + tmp1y * pre2 + tmp2y * subdiv_step3;
            float ddfx = tmp1x * pre4 + tmp2x * pre5;
            float ddfy = tmp1y * pre4 + tmp2y * pre5;
            float dddfx = tmp2x * pre5;
            float dddfy = tmp2y * pre5;
            int step = 0;
            while (step++ < NUM_STEPS) {
                PointF tmp;
                dfx += ddfx;
                ddfx += dddfx;
                ddfy += dddfy;
                p[step] = tmp = new PointF(fx += dfx, fy += (dfy += ddfy));
            }
            p[NUM_STEPS + 1] = tmp2 = new PointF(x4, y4);
        }
    }
}

