/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.lightskin;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class LightSkinSmoothFilter
extends MultiInputFilter
implements FaceDetectInterface {
    private int sharpenHandle;
    private int blurAlphaHandle;
    private int widthOffsetHandle;
    private int heightOffsetHandle;
    private int freqRangeValueHandle;
    private int freqRangeBlurHandle;
    private float bgBlur;
    private float smoothLevel;
    private float widthOffset;
    private float heightOffset;
    private float sharpen = 0.5f;
    private MMCVInfo mmcvInfo;
    private FloatBuffer verticesBuffer;
    private FloatBuffer texCoordBuffer;

    public LightSkinSmoothFilter() {
        super(3);
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.blurAlphaHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"blurAlpha");
        this.widthOffsetHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"widthOffset");
        this.heightOffsetHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"heightOffset");
        this.sharpenHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"sharpen");
        this.freqRangeValueHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"frequencyRangeValue");
        this.freqRangeBlurHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"frequencyRangeBlur");
    }

    protected void passShaderValues() {
        super.passShaderValues();
        this.widthOffset = 1.0f / (float)this.getWidth();
        this.heightOffset = 1.0f / (float)this.getHeight();
        float bgBlur = this.mmcvInfo != null && this.mmcvInfo.getMaxFaceCnt() > 0 ? this.bgBlur : this.smoothLevel;
        GLES20.glUniform3f((int)this.blurAlphaHandle, (float)bgBlur, (float)0.0f, (float)0.0f);
        GLES20.glUniform1f((int)this.widthOffsetHandle, (float)this.widthOffset);
        GLES20.glUniform1f((int)this.heightOffsetHandle, (float)this.heightOffset);
        GLES20.glUniform1f((int)this.sharpenHandle, (float)0.2f);
        GLES20.glUniform4f((int)this.freqRangeValueHandle, (float)0.2f, (float)0.5f, (float)0.9f, (float)0.9f);
        GLES20.glUniform4f((int)this.freqRangeBlurHandle, (float)1.0f, (float)0.9f, (float)0.5f, (float)0.08f);
    }

    protected void facePassShaderValues() {
        this.passTextureValues();
        GLES20.glUniform3f((int)this.blurAlphaHandle, (float)this.smoothLevel, (float)0.0f, (float)0.0f);
        GLES20.glUniform1f((int)this.widthOffsetHandle, (float)this.widthOffset);
        GLES20.glUniform1f((int)this.heightOffsetHandle, (float)this.heightOffset);
        GLES20.glUniform1f((int)this.sharpenHandle, (float)this.sharpen);
        GLES20.glUniform4f((int)this.freqRangeValueHandle, (float)0.2f, (float)0.5f, (float)0.9f, (float)0.9f);
        GLES20.glUniform4f((int)this.freqRangeBlurHandle, (float)1.0f, (float)0.9f, (float)0.5f, (float)0.08f);
    }

    public void drawSub() {
        super.drawSub();
        if (this.mmcvInfo == null || this.mmcvInfo.getMaxFaceCnt() == 0) {
            return;
        }
        GLES20.glUseProgram((int)this.programHandle);
        for (int i = 0; i < this.mmcvInfo.getMaxFaceCnt(); ++i) {
            this.facePassShaderValues();
            float[][] array = AIFaceTriangulation.getFaceTriangulation(this.mmcvInfo.getFaceAttributeInfo(i).getOriglandmarks_104(), this.getWidth(), this.getHeight(), null);
            float[] vertexCoord = array[0];
            float[] textureCoord = array[1];
            if (this.verticesBuffer == null) {
                this.verticesBuffer = ByteBuffer.allocateDirect(vertexCoord.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            }
            this.verticesBuffer.rewind();
            this.verticesBuffer.put(vertexCoord);
            this.verticesBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.verticesBuffer);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            if (this.texCoordBuffer == null) {
                this.texCoordBuffer = ByteBuffer.allocateDirect(textureCoord.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            }
            this.texCoordBuffer.rewind();
            this.texCoordBuffer.put(textureCoord);
            this.texCoordBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.texCoordBuffer);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
            GLES20.glDrawArrays((int)4, (int)0, (int)(textureCoord.length / 2));
        }
        this.disableDrawArray();
    }

    public synchronized void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        this.setWidth(this.getWidth());
        this.setHeight(this.getHeight());
        super.newTextureReady(texture, source, newData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmoothLevel(float level) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.smoothLevel = level;
            this.bgBlur = Math.min(level, 0.3f);
        }
    }

    public float getSmoothLevel() {
        return this.smoothLevel;
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        this.mmcvInfo = mmcvInfo;
    }

    protected String getFragmentShader() {
        return "precision highp float;\nvarying highp vec2 textureCoordinate; \nuniform sampler2D inputImageTexture0; //\u539f\u56fe\nuniform sampler2D inputImageTexture1;  \nuniform sampler2D inputImageTexture2;  \nuniform lowp vec3 blurAlpha; //0.59   1.0\nuniform highp float widthOffset; //0.0018519 \u5373 1/w\nuniform highp float heightOffset; //0.0010417 \u53731/h\nuniform highp float sharpen;//0.05\n\nuniform  vec4 frequencyRangeValue; \nuniform  vec4 frequencyRangeBlur;\n\nvoid main() \n{ \n    lowp vec4 iColor = texture2D(inputImageTexture0, textureCoordinate); \n    lowp vec4 meanColor = texture2D(inputImageTexture1, textureCoordinate); \n    lowp vec4 varColor = texture2D(inputImageTexture2, textureCoordinate); \n    lowp float theta = 0.1; \n    mediump float p = clamp((min(iColor.r, meanColor.r - 0.1) - 0.2) * 4.0, 0.0, 1.0); \n    mediump float meanVar = (varColor.r + varColor.g + varColor.b) / 3.0; \n    mediump float kMin; \n    lowp vec3 resultColor; \n    lowp float intensity = blurAlpha.r; \n    kMin = (1.0 - meanVar / (meanVar + theta)) * p * intensity; \n\n    ////////////////////////////////////////////////////////\n    //\u5206\u9891\n    if(kMin > 1.0 - frequencyRangeValue.x)\n    {\n        kMin = kMin * frequencyRangeBlur.x ; //\u4f4e\u9891\n    }\n    else if(kMin > 1.0 - frequencyRangeValue.y)\n    {\n        kMin = kMin * frequencyRangeBlur.y; //\u4f4e\u4e2d\u9891\n    }\n    else if(kMin > 1.0 - frequencyRangeValue.z)\n    {\n        kMin = kMin * frequencyRangeBlur.z; //\u4e2d\u9891\n    }\n    else\n    {\n        kMin = kMin * frequencyRangeBlur.w; //\u9ad8\u9891        \n    }    \n\n    ////////////////////////////////////////////////////////\n\n    resultColor = mix(iColor.rgb, meanColor.rgb, kMin); \n     \n    highp float sum = 0.25*iColor.g;\n    sum += 0.125*texture2D(inputImageTexture0,textureCoordinate+vec2(-widthOffset,0.0)).g;\n    sum += 0.125*texture2D(inputImageTexture0,textureCoordinate+vec2(widthOffset,0.0)).g;\n    sum += 0.125*texture2D(inputImageTexture0,textureCoordinate+vec2(0.0,-heightOffset)).g;\n    sum += 0.125*texture2D(inputImageTexture0,textureCoordinate+vec2(0.0,heightOffset)).g;\n    sum += 0.0625*texture2D(inputImageTexture0,textureCoordinate+vec2(widthOffset,heightOffset)).g;\n    sum += 0.0625*texture2D(inputImageTexture0,textureCoordinate+vec2(-widthOffset,-heightOffset)).g;\n    sum += 0.0625*texture2D(inputImageTexture0,textureCoordinate+vec2(-widthOffset,heightOffset)).g;\n    sum += 0.0625*texture2D(inputImageTexture0,textureCoordinate+vec2(widthOffset,-heightOffset)).g;\n\n\n    float hPass = iColor.g-sum+0.5;\n    float flag = step(0.5, hPass);\n    highp vec3 color = mix(max(vec3(0.0), (2.0*hPass + resultColor - 1.0)), min(vec3(1.0), (resultColor + 2.0*hPass - 1.0)), flag);\n    color = mix(resultColor.rgb, color.rgb, sharpen);\n\n    gl_FragColor = vec4(color, 1.0);\n}";
    }
}

