/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.facewarp;

import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.facewarp.BaseFaceWarpFilter;
import com.momocv.SingleFaceInfo;
import com.momocv.beauty.BeautyWarpParams;

public class MultiFaceWarpFilter
extends BaseFaceWarpFilter {
    private float warpLevel1;
    private float warpLevel2;
    private float[] warpLevel1Array;
    private float[] warpLevel2Array;
    private float[][] landmarks;
    private float[][] eulerAngles;

    @Override
    protected int getDefaultWarpType() {
        return 9;
    }

    @Override
    public void changeFaceBeautyValue(String id, float level) {
        if ("thin_face".equals(id)) {
            this.warpLevel1 = level;
        } else if ("big_eye".equals(id)) {
            this.warpLevel2 = level;
        }
    }

    @Override
    protected boolean notWarp() {
        return this.warpType == 0 || this.mmcvInfo == null || this.mmcvInfo.getMaxFaceCnt() == 0;
    }

    @Override
    protected BeautyWarpParams buildParams(MMCVInfo mmcvInfo, SingleFaceInfo faceInfo) {
        BeautyWarpParams params = this.warpParams;
        params.image_width_ = mmcvInfo.width;
        params.image_height_ = mmcvInfo.height;
        if (params.scale_factor_ > 0.0f) {
            params.image_width_ = (int)((float)mmcvInfo.width * params.scale_factor_);
            params.image_height_ = (int)((float)mmcvInfo.height * params.scale_factor_);
        }
        params.is_stable_ = true;
        params.multifaces_switch_ = true;
        params.fliped_show_ = mmcvInfo.isFrontCamera;
        params.restore_degree_ = mmcvInfo.restoreDegree;
        params.rotate_degree_ = mmcvInfo.cameraDegree;
        params.face_warp_gradual_switch_ = true;
        params.warp_type_ = this.warpType;
        if (this.warpLevel1Array == null) {
            this.warpLevel1Array = new float[1];
        }
        if (this.warpLevel2Array == null) {
            this.warpLevel2Array = new float[1];
        }
        if (this.landmarks == null) {
            this.landmarks = new float[1][faceInfo.orig_landmarks_104_.length];
        }
        if (this.eulerAngles == null) {
            this.eulerAngles = new float[1][faceInfo.euler_angles_.length];
        }
        this.warpLevel1Array[0] = this.warpLevel1;
        this.warpLevel2Array[0] = this.warpLevel2;
        this.landmarks[0] = faceInfo.orig_landmarks_104_;
        this.eulerAngles[0] = faceInfo.euler_angles_;
        params.warp_level1_ = this.warpLevel1Array;
        params.warp_level2_ = this.warpLevel2Array;
        params.landmarks104_ = this.landmarks;
        params.euler_angle_ = this.eulerAngles;
        return params;
    }
}

