/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.facewarp;

import android.text.TextUtils;
import com.core.glcore.cv.MMCVInfo;
import com.immomo.moment.util.ImageProcessUtil;
import com.momo.mcamera.mask.facewarp.BaseFaceWarpFilter;
import com.momocv.SingleFaceInfo;
import com.momocv.beauty.BeautyWarpParams;
import com.momocv.beauty.XCameraWarpLevelParams;

public class CXFaceWarpFilter
extends BaseFaceWarpFilter {
    private XCameraWarpLevelParams[] xCameraWarpParams;
    private float[][] landmarks;
    private float[][] eulerAngles;
    private XCameraWarpLevelParams warpLevelParams = new XCameraWarpLevelParams();

    @Override
    public void changeFaceBeautyValue(String id, float level) {
        if (TextUtils.isEmpty((CharSequence)id)) {
            return;
        }
        switch (id) {
            case "big_eye": {
                this.warpLevelParams.eye_size_ = level;
                break;
            }
            case "thin_face": {
                this.warpLevelParams.mm_thin_face_ = level;
                break;
            }
            case "face_width": {
                this.warpLevelParams.face_width_ = level;
                break;
            }
            case "jaw_shape": {
                this.warpLevelParams.chin_width_ = level;
                break;
            }
            case "shorten_face": {
                this.warpLevelParams.short_face_ = level;
                break;
            }
            case "chin_length": {
                this.warpLevelParams.chin_length_ = level;
                break;
            }
            case "forehead": {
                this.warpLevelParams.forehead_ud_ = level;
                break;
            }
            case "eye_tilt": {
                this.warpLevelParams.eye_tilt_ratio_ = level;
                break;
            }
            case "eye_distance": {
                this.warpLevelParams.eye_distance_ = level;
                break;
            }
            case "nose_lift": {
                this.warpLevelParams.nose_lift_ = level;
                break;
            }
            case "nose_size": {
                this.warpLevelParams.nose_size_ = level;
                break;
            }
            case "nose_width": {
                this.warpLevelParams.nose_width_ = level;
                break;
            }
            case "nose_ridge_width": {
                this.warpLevelParams.nose_ridge_width_ = level;
                break;
            }
            case "nose_tip_size": {
                this.warpLevelParams.nose_tip_size_ = level;
                break;
            }
            case "lip_thickness": {
                this.warpLevelParams.lip_thickness_ = level;
                break;
            }
            case "mouth_size": {
                this.warpLevelParams.lip_size_ = level;
            }
        }
    }

    @Override
    protected int getDefaultWarpType() {
        return 10;
    }

    @Override
    protected boolean notWarp() {
        return this.mmcvInfo == null || this.mmcvInfo.getMaxFaceCnt() == 0;
    }

    @Override
    protected BeautyWarpParams buildParams(MMCVInfo mmcvInfo, SingleFaceInfo faceInfo) {
        BeautyWarpParams params = this.warpParams;
        params.image_width_ = mmcvInfo.width;
        params.image_height_ = mmcvInfo.height;
        if (params.scale_factor_ > 0.0f) {
            params.image_width_ = (int)((float)mmcvInfo.width * params.scale_factor_);
            params.image_height_ = (int)((float)mmcvInfo.height * params.scale_factor_);
        }
        params.is_stable_ = true;
        params.multifaces_switch_ = true;
        params.fliped_show_ = mmcvInfo.isFrontCamera;
        params.restore_degree_ = mmcvInfo.restoreDegree;
        params.rotate_degree_ = mmcvInfo.cameraDegree;
        params.face_warp_gradual_switch_ = true;
        params.warp_type_ = this.warpType;
        if (this.xCameraWarpParams == null) {
            this.xCameraWarpParams = new XCameraWarpLevelParams[1];
        }
        if (this.landmarks == null) {
            this.landmarks = new float[1][faceInfo.orig_landmarks_104_.length];
        }
        if (this.eulerAngles == null) {
            this.eulerAngles = new float[1][faceInfo.euler_angles_.length];
        }
        this.xCameraWarpParams[0] = this.warpLevelParams;
        this.landmarks[0] = ImageProcessUtil.transformLandMark104Points((float[])faceInfo.orig_landmarks_104_);
        this.eulerAngles[0] = faceInfo.euler_angles_;
        params.warp_level_group_ = this.xCameraWarpParams;
        params.landmarks104_ = this.landmarks;
        params.euler_angle_ = this.eulerAngles;
        return params;
    }
}

