/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.facewarp;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.FaceDetector;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.facewarp.IFaceWarp;
import com.momocv.SingleFaceInfo;
import com.momocv.beauty.BeautyWarpInfo;
import com.momocv.beauty.BeautyWarpParams;
import com.momocv.videoprocessor.FaceAttribute;
import com.momocv.videoprocessor.VideoInfo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.filter.BasicFilter;

public abstract class BaseFaceWarpFilter
extends BasicFilter
implements FaceDetectInterface,
IFaceWarp {
    private FloatBuffer vertexBuffer;
    private FloatBuffer texCoordBuffer;
    private GLFrameBuffer warpFrameBuffer;
    private int maxFaces = Integer.MAX_VALUE;
    protected BeautyWarpParams warpParams = new BeautyWarpParams();
    protected BeautyWarpInfo warpInfo = new BeautyWarpInfo();
    protected MMCVInfo mmcvInfo;
    protected WarpPoint warpPoint = new WarpPoint();
    protected int warpType = this.getDefaultWarpType();

    public void setMaxFaces(int maxCount) {
        this.maxFaces = maxCount;
    }

    public void setWarpType(int warpType) {
        this.warpType = warpType;
    }

    public void setScaleFactor(float scaleFactor) {
        this.warpParams.scale_factor_ = scaleFactor;
    }

    protected void clearPoints() {
        this.warpPoint.srcPoints = null;
        this.warpPoint.dstPoints = null;
    }

    public void destroy() {
        super.destroy();
        FaceDetector.getInstance().releaseBeautyProcessor();
    }

    public void drawSub() {
        if (this.notWarp()) {
            super.drawSub();
            return;
        }
        if (this.maxFaces > 1) {
            this.drawMultiFace();
        } else {
            this.drawSingleFace();
        }
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.warpFrameBuffer != null) {
            this.warpFrameBuffer.destoryBuffer();
            this.warpFrameBuffer = null;
        }
    }

    private void drawSingleFace() {
        SingleFaceInfo faceInfo = this.mmcvInfo.getVideoInfo().facesinfo_[0];
        FaceAttribute faceAttribute = this.mmcvInfo.getVideoInfo().faces_attributes_[0];
        WarpPoint warpPoint = this.processSingleWarpPoint(faceInfo);
        if (warpPoint != null && warpPoint.srcPoints != null && warpPoint.dstPoints != null) {
            this.drawWarpSub(this.texture_in, warpPoint);
            this.clearPoints();
            this.setLandmarks(faceInfo, faceAttribute);
        } else {
            super.drawSub();
        }
    }

    private void setLandmarks(SingleFaceInfo faceInfo, FaceAttribute faceAttribute) {
        if (this.warpInfo.warped_landmarks68_ != null && this.warpInfo.warped_landmarks96_ != null && this.warpInfo.warped_landmarks104_ != null) {
            faceInfo.landmarks_68_ = this.warpInfo.warped_landmarks68_[0];
            faceInfo.landmarks_96_ = this.warpInfo.warped_landmarks96_[0];
            faceInfo.landmarks_104_ = this.warpInfo.warped_landmarks104_[0];
            faceAttribute.warped_landmarks68_ = this.warpInfo.warped_landmarks68_[0];
            faceAttribute.warped_landmarks96_ = this.warpInfo.warped_landmarks96_[0];
            faceAttribute.warped_landmarks104_ = this.warpInfo.warped_landmarks104_[0];
        }
    }

    private void drawMultiFace() {
        int count = 0;
        int maxFaceCnt = this.mmcvInfo.getMaxFaceCnt();
        VideoInfo videoInfo = this.mmcvInfo.getVideoInfo();
        for (int i = 0; i < maxFaceCnt; ++i) {
            SingleFaceInfo singleFaceInfo = videoInfo.facesinfo_[i];
            FaceAttribute faceAttribute = videoInfo.faces_attributes_[i];
            WarpPoint warpPoint = this.processSingleWarpPoint(singleFaceInfo);
            if (warpPoint == null || warpPoint.srcPoints == null || warpPoint.dstPoints == null) continue;
            int textureIn = count == 0 ? this.texture_in : this.getTextOutID();
            this.drawWarpFrame(textureIn, warpPoint);
            this.copyToFrameBuffer(this.warpFrameBuffer.getTexture_out()[0]);
            ++count;
            this.clearPoints();
            this.setLandmarks(singleFaceInfo, faceAttribute);
        }
        if (count == 0) {
            super.drawSub();
        }
    }

    private void initWarpFBO() {
        if (this.warpFrameBuffer != null) {
            this.warpFrameBuffer.destoryBuffer();
        }
        this.warpFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
        this.warpFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException(this.toString() + ": Failed to set up render buffer with status " + status + " and error " + GLES20.glGetError());
        }
    }

    private void drawWarpFrame(int textureIn, WarpPoint warpPoint) {
        if (this.warpFrameBuffer == null || this.warpFrameBuffer.getFrameBuffer() == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initWarpFBO();
            } else {
                return;
            }
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.warpFrameBuffer.getFrameBuffer()[0]);
        this.drawWarpSub(textureIn, warpPoint);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    private void drawWarpSub(int textureIn, WarpPoint warpPoint) {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glUseProgram((int)this.programHandle);
        float[] texCoord = warpPoint.srcPoints;
        float[] vertexCoord = warpPoint.dstPoints;
        int triangleSize = vertexCoord.length / 2;
        if (this.vertexBuffer == null || this.vertexBuffer.capacity() != vertexCoord.length * 4) {
            this.vertexBuffer = ByteBuffer.allocateDirect(vertexCoord.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(vertexCoord);
        }
        this.vertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        if (this.texCoordBuffer == null || this.texCoordBuffer.capacity() != texCoord.length * 4) {
            this.texCoordBuffer = ByteBuffer.allocateDirect(texCoord.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(texCoord);
        }
        this.texCoordBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.texCoordBuffer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureIn);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glDrawArrays((int)4, (int)0, (int)triangleSize);
        this.disableDrawArray();
    }

    private void copyToFrameBuffer(int textureIn) {
        GLES20.glBindFramebuffer((int)36160, (int)this.glFrameBuffer.getFrameBuffer()[0]);
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glUseProgram((int)this.programHandle);
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureIn);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.disableDrawArray();
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        this.mmcvInfo = mmcvInfo;
    }

    protected abstract int getDefaultWarpType();

    protected abstract boolean notWarp();

    protected abstract BeautyWarpParams buildParams(MMCVInfo var1, SingleFaceInfo var2);

    protected WarpPoint processSingleWarpPoint(SingleFaceInfo faceInfo) {
        BeautyWarpParams params = this.buildParams(this.mmcvInfo, faceInfo);
        boolean isFaceFeature = FaceDetector.getInstance().getWarpKeyPoints(params, this.warpInfo);
        if (isFaceFeature) {
            this.warpPoint.srcPoints = this.warpInfo.src_warp_points_;
            this.warpPoint.dstPoints = this.warpInfo.dst_warp_points_;
        }
        return this.warpPoint;
    }

    static class WarpPoint {
        float[] srcPoints;
        float[] dstPoints;

        WarpPoint() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WarpPoint warpPoint = (WarpPoint)o;
            return Arrays.equals(this.srcPoints, warpPoint.srcPoints) && Arrays.equals(this.dstPoints, warpPoint.dstPoints);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.srcPoints);
            result = 31 * result + Arrays.hashCode(this.dstPoints);
            return result;
        }
    }
}

