/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.express;

import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.immomo.baseutil.MediaStatisticModel;
import com.momo.mcamera.mask.detect.IPatternDetect;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.bean.CVExpressInfo;
import com.momo.xeengine.cv.CVExpression;
import com.momocv.express.Express;
import com.momocv.express.ExpressInfo;
import com.momocv.express.SingleExpressInfo;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExpressDetector
implements IPatternDetect {
    private String expressModelPath;
    private ByteBuffer curByteBuffer;
    private Object waitSignal;
    private Object startSync;
    private boolean running;
    private AtomicBoolean isDetecting;
    private ExpressThread detectThread;
    private MMFrameInfo mmFrame = new MMFrameInfo();
    private MMParamsInfo paramsInfo = new MMParamsInfo(6);
    private ExpressInfo expressInfo = new ExpressInfo();
    private Express express;

    public ExpressDetector() {
        this.waitSignal = new Object();
        this.startSync = new Object();
        this.isDetecting = new AtomicBoolean(false);
    }

    @Override
    public void setModelPath(String path) {
        this.expressModelPath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDetect() {
        Object object = this.startSync;
        synchronized (object) {
            if (this.detectThread == null) {
                this.running = true;
                this.detectThread = new ExpressThread("ExpressDetect");
                this.detectThread.start();
            }
        }
    }

    @Override
    public void detect() {
        this.isDetecting.set(true);
        long start = SystemClock.elapsedRealtime();
        if (this.express == null && !TextUtils.isEmpty((CharSequence)this.expressModelPath)) {
            this.express = new Express();
            boolean bl = this.express.LoadModel(this.expressModelPath);
        }
        if (this.express != null) {
            byte[] data = this.curByteBuffer.array();
            this.mmFrame.setDataPtr(data);
            this.mmFrame.setDataLen(data.length);
            this.express.ProcessFrame(this.mmFrame.getFrame(), this.paramsInfo.getExpressParams(), this.expressInfo);
            if (this.expressInfo.express_infos_ != null && this.expressInfo.express_infos_.length > 0 && MediaModuleGlobalConfig.hasXE()) {
                SingleExpressInfo[] express_infos_;
                ArrayList<CVExpressInfo> cvExpressInfos = new ArrayList<CVExpressInfo>();
                for (SingleExpressInfo anExpress_infos_ : express_infos_ = this.expressInfo.express_infos_) {
                    CVExpressInfo info = new CVExpressInfo();
                    info.setHead(anExpress_infos_.head_);
                    info.setLeftEye(anExpress_infos_.lefteye_);
                    info.setRightEye(anExpress_infos_.righteye_);
                    info.setMouth(anExpress_infos_.mouth_);
                    info.setNeck(anExpress_infos_.neck_);
                    cvExpressInfos.add(info);
                }
                if (XE3DEngine.getInstance().isRunning()) {
                    CVExpression.setExpressionInfos(cvExpressInfos);
                }
            }
        }
        long detectUse = SystemClock.elapsedRealtime() - start;
        MediaStatisticModel.getInstance().setExpressDetect(detectUse);
        SystemClock.sleep((long)200L);
        this.isDetecting.set(false);
    }

    @Override
    public void stopDetect() {
        this.running = false;
        if (this.curByteBuffer != null) {
            this.curByteBuffer.clear();
        }
        if (this.detectThread != null) {
            try {
                this.detectThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.detectThread = null;
        }
        if (this.express != null) {
            this.express.Release();
            this.express = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (this.isDetecting.get()) {
            return;
        }
        this.mmFrame.setFormat(17);
        this.mmFrame.setWidth(mmcvInfo.width);
        this.mmFrame.setHeight(mmcvInfo.height);
        this.mmFrame.setStep_(mmcvInfo.width);
        this.curByteBuffer = ByteBuffer.wrap(mmcvInfo.frameData);
        this.paramsInfo.setFlipedShow(mmcvInfo.isFrontCamera);
        this.paramsInfo.setRotateDegree(mmcvInfo.cameraDegree);
        this.paramsInfo.setRestoreDegree(mmcvInfo.restoreDegree);
        this.paramsInfo.setOriginFaceRects(mmcvInfo.getOriginFaceRects());
        this.paramsInfo.setOriginLandmarks96(mmcvInfo.getOriginLandmarks96());
        Object object = this.waitSignal;
        synchronized (object) {
            this.waitSignal.notify();
        }
    }

    private class ExpressThread
    extends Thread {
        public ExpressThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            ExpressDetector.this.running = true;
            try {
                Object object = ExpressDetector.this.waitSignal;
                synchronized (object) {
                    while (ExpressDetector.this.running) {
                        ExpressDetector.this.waitSignal.wait();
                        ExpressDetector.this.detect();
                    }
                }
                ExpressDetector.this.curByteBuffer.clear();
                ExpressDetector.this.curByteBuffer = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

