/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.beauty;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.cosmos.mdlog.MDLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.filter.BasicFilter;

public class DrawFaceFilter
extends BasicFilter
implements FaceDetectInterface {
    float[] faceRec = null;
    float[][] facePos96 = null;
    float[][] facePos68 = null;
    float[][] facePos104 = null;
    float[][] facePos137 = null;
    public static final int FACE_TYPE_68 = 0;
    public static final int FACE_TYPE_96 = 1;
    public static final int FACE_TYPE_104 = 2;
    public static final int FACE_TYPE_137 = 3;
    private int faceType = 0;
    FloatBuffer floatBuffer;
    FloatBuffer floatBufFace68;
    FloatBuffer floatBufFace96;
    FloatBuffer floatBufFace104;
    FloatBuffer floatBufFace137;
    private int colorHandle = 0;

    public void setFaceType(int faceType) {
        this.faceType = faceType;
    }

    private void updateFaceInfo(MMCVInfo info) {
        int faceCount = info.getMaxFaceCnt();
        if (faceCount <= 0) {
            MDLog.d((String)"mediaRender", (String)"No face");
            return;
        }
        if (this.facePos68 == null || faceCount != this.facePos68.length) {
            this.facePos68 = new float[faceCount][136];
            this.facePos96 = new float[faceCount][192];
            this.facePos104 = new float[faceCount][208];
            this.facePos137 = new float[faceCount][274];
        }
        for (int i = 0; i < faceCount; ++i) {
            float[] src137;
            float[] src104;
            float[] src96;
            FaceAttributeInfo attributeInfo = info.getFaceAttributeInfo(i);
            if (attributeInfo == null) continue;
            float[] src68 = attributeInfo.getLandmarks68();
            if (src68 != null) {
                this.adjustCoordnate(this.facePos68[i], src68);
            }
            if ((src96 = info.getFaceAttributeInfo(i).getLandmarks96()) != null) {
                this.adjustCoordnate(this.facePos96[i], src96);
            }
            if ((src104 = info.getFaceAttributeInfo(i).getLandmarks104()) != null) {
                this.adjustCoordnate(this.facePos104[i], src104);
            }
            if ((src137 = info.getFaceAttributeInfo(i).getLandmarks137()) == null) continue;
            this.adjustCoordnate(this.facePos137[i], src137);
        }
    }

    private void adjustCoordnate(float[] coord, float[] src) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (coord != null && coord.length > 0 && src != null && src.length > 0) {
            for (int i = 0; i < coord.length / 2; ++i) {
                coord[i * 2] = 2.0f * (src[i] / (float)width - 0.5f);
                coord[i * 2 + 1] = -2.0f * (src[i + coord.length / 2] / (float)height - 0.5f);
            }
        } else {
            MDLog.d((String)"mediaRender", (String)"No face Info or buffer is empty");
        }
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo != null) {
            float[][] rect = mmcvInfo.getFaceRects();
            if (rect != null && rect.length > 0 && rect[0] != null) {
                this.faceRec = rect[0];
            }
            this.updateFaceInfo(mmcvInfo);
        }
    }

    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1i((int)this.colorHandle, (int)1);
    }

    public void drawSub() {
        super.drawSub();
        try {
            GLES20.glUniform1i((int)this.colorHandle, (int)0);
            if (this.faceRec == null || this.faceRec.length <= 0) {
                MDLog.e((String)"mediaRender", (String)"Render no face!");
                return;
            }
            GLES20.glClearColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float topleftx = 2.0f * (this.faceRec[0] / (float)this.getWidth() - 0.5f);
            float toplefty = -2.0f * (this.faceRec[1] / (float)this.getHeight() - 0.5f);
            float bottomx = 2.0f * (this.faceRec[2] / (float)this.getWidth() - 0.5f);
            float bottomy = -2.0f * (this.faceRec[3] / (float)this.getHeight() - 0.5f);
            float[] lines = new float[]{topleftx, toplefty, topleftx, bottomy, topleftx, bottomy, bottomx, bottomy, bottomx, bottomy, bottomx, toplefty, topleftx, toplefty, bottomx, toplefty};
            if (this.floatBuffer == null || this.floatBuffer.capacity() != lines.length) {
                this.floatBuffer = ByteBuffer.allocateDirect(lines.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            }
            this.floatBuffer.put(lines);
            this.floatBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.floatBuffer);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            GLES20.glLineWidth((float)2.0f);
            GLES20.glDrawArrays((int)1, (int)0, (int)8);
            this.floatBufFace68 = this.putDataToFloatBuffer(this.floatBufFace68, this.facePos68);
            this.floatBufFace96 = this.putDataToFloatBuffer(this.floatBufFace96, this.facePos96);
            this.floatBufFace104 = this.putDataToFloatBuffer(this.floatBufFace104, this.facePos104);
            this.floatBufFace137 = this.putDataToFloatBuffer(this.floatBufFace137, this.facePos137);
            FloatBuffer fb = null;
            switch (this.faceType) {
                case 0: {
                    fb = this.floatBufFace68;
                    break;
                }
                case 1: {
                    fb = this.floatBufFace96;
                    break;
                }
                case 2: {
                    fb = this.floatBufFace104;
                    break;
                }
                case 3: {
                    fb = this.floatBufFace137;
                }
            }
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)fb);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            GLES20.glDrawArrays((int)0, (int)0, (int)(fb.capacity() / 2));
            this.disableDrawArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FloatBuffer putDataToFloatBuffer(FloatBuffer floatBuffer, float[][] faceInfo) {
        if (faceInfo.length <= 0) {
            floatBuffer.position(0);
            return floatBuffer;
        }
        if (floatBuffer == null) {
            floatBuffer = ByteBuffer.allocateDirect(faceInfo.length * 4 * faceInfo[0].length).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        for (int i = 0; i < faceInfo.length; ++i) {
            if (faceInfo[i] == null || faceInfo[i].length <= 0) continue;
            floatBuffer.put(faceInfo[i], i * faceInfo[i].length, faceInfo[i].length);
        }
        floatBuffer.position(0);
        return floatBuffer;
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.colorHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"color");
    }

    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform int color;\nvarying vec2 textureCoordinate;\nvoid main(){\n if(color == 1){   gl_FragColor = texture2D(inputImageTexture0,textureCoordinate);\n }else{   gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);\n }}\n";
    }

    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvoid main() {\n  textureCoordinate = inputTextureCoordinate;\n gl_PointSize = 3.0;   gl_Position = position;\n}\n";
    }
}

