/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.text.TextUtils;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.helper.BlendShaderHelper;

public class TriggerBlendFilter
extends MultiInputFilter
implements FaceDetectInterface {
    private static final String UNIFORM_BLEND = "blend";
    protected static final String UNIFORM_TEXTURE_ALPHA = "inputImageTexture2";
    private int blendHandler;
    private int texelWidthHandler;
    private int texelHeightHandler;
    private int strokeRadiusHandler;
    private int strokeColorHandler;
    private int strokeEnabledHandler;
    private boolean isBlend = true;
    protected boolean isSegmentBody = false;
    protected boolean isStroke = false;
    protected float[] strokeRgbaColor;
    protected int strokeRadius = 5;
    private MMCVInfo mmcvInfo;
    private int alphaTexture = 0;
    private String blendType;
    private int strokeEnabled = 1;

    public void setStrokeEnabled(boolean isStrokeEnalbed) {
        this.strokeEnabled = isStrokeEnalbed ? 1 : 0;
    }

    public void setBlendType(String blendType) {
        this.blendType = blendType;
    }

    public void setSegmentBody(boolean segmentBody) {
        this.isSegmentBody = segmentBody;
    }

    public void setSegmentStrokeColor(float[] strokeRgbaColor) {
        if (strokeRgbaColor != null && strokeRgbaColor.length >= 3) {
            this.isStroke = true;
            this.strokeRgbaColor = strokeRgbaColor.length == 3 ? new float[]{strokeRgbaColor[0], strokeRgbaColor[1], strokeRgbaColor[2], 1.0f} : strokeRgbaColor;
        } else {
            this.isStroke = false;
        }
    }

    public void setSegmentStrokeRadius(int strokeRadius) {
        if (strokeRadius > 0) {
            this.strokeRadius = strokeRadius;
        }
    }

    public TriggerBlendFilter() {
        super(2);
    }

    public TriggerBlendFilter(int numOfInputs) {
        super(numOfInputs);
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo == null) {
            return;
        }
        this.mmcvInfo = mmcvInfo;
        FaceAttributeInfo info = mmcvInfo.getFaceAttributeInfo(0);
        if (info != null && info.getModelviewMatrix() != null && info.getRotationVector() != null) {
            this.setStrokeEnabled(true);
        } else {
            this.setStrokeEnabled(false);
        }
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.blendHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BLEND);
        if (this.isSegmentBody && this.isStroke) {
            this.texelWidthHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"texelWidth");
            this.texelHeightHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"texelHeight");
            this.strokeRadiusHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"strokeRadius");
            this.strokeColorHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"strokeColor");
            this.strokeEnabledHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"strokeEnabled");
        }
    }

    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.blendHandler, (float)(this.isBlend ? 1.0f : 0.0f));
        if (this.isSegmentBody && this.isStroke) {
            GLES20.glUniform1f((int)this.texelWidthHandler, (float)(1.0f / (float)this.getWidth()));
            GLES20.glUniform1f((int)this.texelHeightHandler, (float)(1.0f / (float)this.getHeight()));
            GLES20.glUniform1i((int)this.strokeRadiusHandler, (int)this.strokeRadius);
            GLES20.glUniform4f((int)this.strokeColorHandler, (float)this.strokeRgbaColor[0], (float)this.strokeRgbaColor[1], (float)this.strokeRgbaColor[2], (float)this.strokeRgbaColor[3]);
            GLES20.glUniform1i((int)this.strokeEnabledHandler, (int)this.strokeEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlend(boolean blend) {
        Object object = this.listLock;
        synchronized (object) {
            this.isBlend = blend;
        }
    }

    protected String getFragmentShader() {
        String blendShader;
        if (this.isSegmentBody) {
            if (this.isStroke) {
                return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nuniform sampler2D inputImageTexture3;\nuniform float blend;\nvarying vec2 textureCoordinate;\n\nuniform float texelWidth;\nuniform float texelHeight;\n\nuniform int strokeRadius;\nuniform vec4 strokeColor;\nuniform int strokeEnabled;\nfloat stepWidth = 1.0;\n\nfloat intensityForEdge(vec2 center, vec2 step1) {\n    //bool isIntensity = false;\n    vec4 centerTex = texture2D(inputImageTexture3, center);\n    float intensity = centerTex.r;\n    for (int i = 0; i < strokeRadius; i++) {\n        vec2 left = center + vec2(step1.x * float(i), 0.0);\n        vec2 right = center + vec2(step1.x * -float(i), 0.0);\n        vec2 top = center + vec2(0.0, -step1.y * float(i));\n        vec2 bottom = center + vec2(0.0, +step1.y * float(i));\n        vec4 leftTex = texture2D( inputImageTexture3, left);\n        vec4 rightTex = texture2D( inputImageTexture3, right);\n        vec4 topTex = texture2D( inputImageTexture3, top);\n        vec4 bottomTex = texture2D( inputImageTexture3, bottom);\n        intensity = (intensity+(leftTex.r+rightTex.r+ topTex.r+ bottomTex.r)*(1.0-float(i)/float(strokeRadius)));\n    }\n    return intensity*float(strokeRadius);\n}\n\nvoid main(){\n vec4 color2 = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {\n   gl_FragColor = color2;\n} else {   \n   vec2 step1 = vec2(stepWidth*texelWidth, stepWidth*texelHeight);\n   vec4 picture = texture2D(inputImageTexture1, textureCoordinate);\n\n   vec4 color1;\n   float intensity = intensityForEdge(textureCoordinate, step1);\n   //if (intensity > 0.0) {\n   //   color1 = strokeColor;\n   //} else {\n   //   color1 = picture;\n   //}\n   color1 = mix(strokeColor, picture , step(0.0, -intensity));\n   color1 = mix(picture, color1, float(strokeEnabled));\n   //vec4 colorSobel = texture2D(inputImageTexture3,textureCoordinate);\n   //float c1AlphaDivisor = color1.a + step(color1.a, 0.0);\n   //color1.rgb = color1.rgb/c1AlphaDivisor;\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   vec4 colorAlpha = texture2D(inputImageTexture2, textureCoordinate);\n   color1 = vec4(color1.rgb, color1.a * (colorAlpha.r > 0.9 ? 0.0 : (1.0 - colorAlpha.r * colorAlpha.r* colorAlpha.r)));\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n   }\n }";
            }
            return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nuniform float blend;\nvarying vec2 textureCoordinate;\nvoid main(){\n vec4 color2 = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {     gl_FragColor = color2; }  else{   vec4 color1 = texture2D(inputImageTexture1,textureCoordinate);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   vec4 colorAlpha = texture2D(inputImageTexture2, textureCoordinate);\n   color1 = vec4(color1.rgb, color1.a * (colorAlpha.r > 0.9 ? 0.0 : (1.0 - colorAlpha.r * colorAlpha.r* colorAlpha.r)));\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n }}\n";
        }
        if (!TextUtils.isEmpty((CharSequence)this.blendType) && !TextUtils.isEmpty((CharSequence)(blendShader = BlendShaderHelper.getBlendShader((String)this.blendType)))) {
            return blendShader;
        }
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform float blend;\nvarying vec2 textureCoordinate;\nvoid main(){\n vec4 color2 = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {     gl_FragColor = color2; }  else{   vec4 color1 = texture2D(inputImageTexture1,textureCoordinate);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n }}\n";
    }

    public void destroy() {
        super.destroy();
        if (this.alphaTexture != 0) {
            int[] tex = new int[]{this.alphaTexture};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
        }
    }
}

