/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.MmcvImageCacheLoader;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.delegate.ImageDelegateProvider;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class StickerMaskFilter
extends FaceDetectFilter
implements IVideoTrackTime {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    static final int COORDS_PER_VERTEX = 2;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   gl_FragColor = color1;\n}";
    protected final float[] mProjectionMatrix = new float[16];
    protected final float[] mViewMatrix = new float[16];
    private final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final int vertexStride = 8;
    protected Object maskListLock = new Object();
    float[] color = new float[]{0.2f, 0.70980394f, 0.8980392f, 1.0f};
    float[] color2 = new float[]{0.0f, 0.20980392f, 0.19803922f, 1.0f};
    int textId;
    float stickerScale;
    float[] mvpMatrix;
    float[] texData0;
    List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    protected Sticker sticker;
    private MmcvImageCacheLoader mmcvImageLoader;
    private Context context;
    private FloatBuffer vertexBuffer;
    private FloatBuffer fvertexBuffer;
    private ShortBuffer drawListBuffer;
    private int decorateHandler;
    private int mVPMatrixHandler;
    protected int positionHandle2;
    private boolean isDraw;
    private boolean lockTexture = false;
    private boolean isPlaying;
    private String imagePath;

    public StickerMaskFilter(Context context, Sticker sticker, ImageDelegateProvider imageDelegateProvider) {
        this.sticker = sticker;
        float realWidth = 0.5f;
        this.context = context;
        this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
        float[] squareCoords = new float[]{-realWidth, realWidth * this.stickerScale, -realWidth, -realWidth * this.stickerScale, realWidth, -realWidth * this.stickerScale, realWidth, realWidth * this.stickerScale};
        this.mmcvImageLoader = new MmcvImageCacheLoader(sticker, context);
        this.isPlaying = true;
        ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = bb.asFloatBuffer();
        this.vertexBuffer.put(squareCoords);
        this.vertexBuffer.position(0);
        this.texData0 = new float[]{-realWidth, realWidth * this.stickerScale, 0.0f, 1.0f, -realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, realWidth * this.stickerScale, 0.0f, 1.0f};
        ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        this.drawListBuffer = dlb.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
    }

    public void setTextId(int textId) {
        this.textId = textId;
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   gl_FragColor = color1;\n}";
    }

    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.mVPMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_MVP_MATRIX);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_MVP_MATRIX);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void passShaderValues(float[] mvpMatrix) {
        this.renderVertices.position(0);
        ByteBuffer bb = ByteBuffer.allocateDirect(mvpMatrix.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.fvertexBuffer = bb.asFloatBuffer();
        this.fvertexBuffer.put(mvpMatrix);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            for (float[] mvpMatrix : this.mvpLists) {
                this.passShaderValues(mvpMatrix);
                this.draw();
            }
        }
    }

    public void draw() {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)((float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth()));
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        if (this.lockTexture && this.texture_in > 0 && this.mvpLists != null && this.mvpLists.size() > 0) {
            this.isDraw = true;
        } else if (this.mvpLists != null && this.mvpLists.size() > 0) {
            if (!this.isDraw) {
                this.clearPoints();
            } else if (this.isPlaying) {
                MMFrameInfo mmcvImage = this.mmcvImageLoader.getMmcvImage(this.context);
                this.imagePath = this.mmcvImageLoader.imagePath;
                if (mmcvImage != null && mmcvImage.getDataPtr() != null) {
                    this.texture_in = this.texture_in == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)mmcvImage) : TextureHelper.loadDataToTexture((int)this.texture_in, (MMFrameInfo)mmcvImage);
                } else {
                    Bitmap bitmap = this.mmcvImageLoader.getDelegateBitmap();
                    if (bitmap != null) {
                        this.deleteTexture();
                        this.texture_in = TextureHelper.bitmapToTexture((Bitmap)bitmap);
                    } else {
                        this.clearPoints();
                    }
                }
            } else {
                this.deleteTexture();
                this.clearPoints();
            }
            if (this.texture_in == 0) {
                this.clearPoints();
            }
            this.isDraw = true;
        } else {
            this.isDraw = false;
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        float ratio = (float)this.getWidth() / (float)this.getHeight();
        Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / ratio), (float)(1.0f / ratio), (float)3.0f, (float)7.0f);
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    protected void deleteTexture() {
        if (this.texture_in != 0) {
            int[] tex = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.texture_in = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, float[] points, float[] points96, float[] points104, FilterTriggerManager filterTrigerManager) {
        Object object = this.maskListLock;
        synchronized (object) {
            if (centerPoint == null) {
                return;
            }
            float sX = w;
            float sY = h;
            float tX = -(centerPoint.x * 2.0f - 1.0f);
            float tY = -centerPoint.y * 2.0f + 1.0f;
            float tAngle = angle;
            centerPoint.x = tX;
            centerPoint.y = tY;
            float[] mvpMatrix = new float[16];
            float[] newResult = new float[16];
            Matrix.setIdentityM((float[])newResult, (int)0);
            Matrix.translateM((float[])newResult, (int)0, (float)(-tX), (float)tY, (float)0.0f);
            Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
            Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])newResult, (int)0, (float[])mvpMatrix, (int)0);
            Matrix.rotateM((float[])mvpMatrix, (int)0, (float)tAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])mvpMatrix, (int)0, (float)(sX * 1.0f), (float)(sY * 1.0f), (float)1.0f);
            Matrix.multiplyMM((float[])newResult, (int)0, (float[])mvpMatrix, (int)0, (float[])this.texData0, (int)0);
            float scaleY = 0.0f;
            if (this.sticker.isComic()) {
                scaleY = angle == 0.0f ? (this.getHeight() <= 960 && (float)this.getHeight() / (float)this.getWidth() != 1.0f ? 0.75f * sY * ((float)this.sticker.getImageHeight() / (float)this.getHeight()) / 2.0f : sY * ((float)this.sticker.getImageHeight() / (float)this.getHeight()) / 2.0f) : (this.getHeight() <= 960 && (float)this.getHeight() / (float)this.getWidth() != 1.0f ? -0.75f * sY * ((float)this.sticker.getImageHeight() / (float)this.getHeight()) / 2.0f : -sY * ((float)this.sticker.getImageHeight() / (float)this.getHeight()) / 2.0f);
            }
            float[] finalResult = new float[]{newResult[0], newResult[1] - scaleY, newResult[4], newResult[5] - scaleY, newResult[8], newResult[9] - scaleY, newResult[12], newResult[13] - scaleY};
            this.mvpLists.add(finalResult);
        }
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
    }

    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        this.setParamForMatrix(detectParam.scaleW, detectParam.scaleH, detectParam.centerPoint, detectParam.angle, detectParam.points68, detectParam.points96, detectParam.points104, detectParam.filterTrigerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPoints() {
        Object object = this.maskListLock;
        synchronized (object) {
            this.mvpLists.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDraw() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.isDraw = false;
            this.isPlaying = false;
            this.mmcvImageLoader.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockTexture() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.lockTexture = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockTexture() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.lockTexture = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseBitmapCache() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.isPlaying = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeBitmapCache() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.isPlaying = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSticker(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            float realWidth = 0.5f;
            this.sticker = sticker;
            this.cancelDraw();
            this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
            float[] squareCoords = new float[]{-realWidth, realWidth * this.stickerScale, -realWidth, -realWidth * this.stickerScale, realWidth, -realWidth * this.stickerScale, realWidth, realWidth * this.stickerScale};
            this.texData0 = new float[]{-realWidth, realWidth * this.stickerScale, 0.0f, 1.0f, -realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, realWidth * this.stickerScale, 0.0f, 1.0f};
            if (null != this.vertexBuffer) {
                this.vertexBuffer.clear();
                this.drawListBuffer.clear();
            }
            ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
            bb.order(ByteOrder.nativeOrder());
            this.vertexBuffer = bb.asFloatBuffer();
            this.vertexBuffer.put(squareCoords);
            this.vertexBuffer.position(0);
            ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
            dlb.order(ByteOrder.nativeOrder());
            this.drawListBuffer = dlb.asShortBuffer();
            this.drawListBuffer.put(this.drawOrder);
            this.drawListBuffer.position(0);
            this.mmcvImageLoader = new MmcvImageCacheLoader(sticker, this.context);
        }
    }

    public void destroy() {
        super.destroy();
        this.deleteTexture();
    }

    public void setTimeStamp(long ms) {
        if (this.mmcvImageLoader != null) {
            this.mmcvImageLoader.setRenderTime(ms);
        }
    }

    public String getImagePathName() {
        return this.imagePath;
    }
}

