/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import project.android.imageprocessing.helper.ImageHelper;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class StickerLookUpFilter
extends FaceDetectFilter {
    private int lookup_texture;
    Sticker sticker;
    private int numOfInputs = 2;
    private int[] textureHandle;
    protected int[] texture;
    private Bitmap lookUpBitmap;

    public StickerLookUpFilter(Sticker sticker) {
        this.sticker = sticker;
        this.textureHandle = new int[this.numOfInputs - 1];
        this.texture = new int[this.numOfInputs - 1];
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        this.lookUpBitmap = BitmapFactory.decodeFile((String)sticker.getLookUpModel().getLookupPath(), (BitmapFactory.Options)options);
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }

    protected void passShaderValues() {
        super.passShaderValues();
        int tex = 0;
        for (int i = 0; i < 1; ++i) {
            switch (i) {
                case 0: {
                    tex = 33985;
                }
            }
            GLES20.glActiveTexture((int)tex);
            GLES20.glBindTexture((int)3553, (int)this.texture[i]);
            GLES20.glUniform1i((int)this.textureHandle[i], (int)(i + 1));
        }
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        for (int i = 0; i < this.numOfInputs - 1; ++i) {
            this.textureHandle[i] = GLES20.glGetUniformLocation((int)this.programHandle, (String)("inputImageTexture" + (i + 1)));
        }
    }

    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nvoid main(){\n  vec4 texColour = texture2D(inputImageTexture0,textureCoordinate);\n  float blueColor = texColour.b * 63.0;\n  vec2 quad1;\n  quad1.y = floor(floor(blueColor) / 8.0);\n  quad1.x = floor(blueColor) - (quad1.y * 8.0);\n  vec2 quad2;\n  quad2.y = floor(ceil(blueColor) / 8.0);\n  quad2.x = ceil(blueColor) - (quad2.y * 8.0);\n  vec2 texPos1;\n  texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * texColour.r);\n  texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * texColour.g);\n  vec2 texPos2;\n  texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * texColour.r);\n  texPos2.y = (quad2.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * texColour.g);\n  vec4 newColor1 = texture2D(inputImageTexture1, texPos1);\n  vec4 newColor2 = texture2D(inputImageTexture1, texPos2);\n  vec4 newColor = mix(newColor1, newColor2, fract(blueColor));\n  gl_FragColor = vec4(newColor.rgb, texColour.a);\n}\n";
    }

    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        if (this.lookup_texture == 0) {
            this.lookup_texture = ImageHelper.bitmapToTexture((Bitmap)this.lookUpBitmap);
        }
        this.texture_in = texture;
        this.texture[0] = this.lookup_texture;
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    public void destroy() {
        super.destroy();
        if (null != this.lookUpBitmap) {
            this.lookUpBitmap.recycle();
            this.lookUpBitmap = null;
        }
        if (this.lookup_texture != 0) {
            int[] tex = new int[]{this.lookup_texture};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.lookup_texture = 0;
        }
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.lookup_texture != 0) {
            int[] tex = new int[]{this.lookup_texture};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.lookup_texture = 0;
        }
    }
}

