/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.opengl.Matrix;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerMaskFilter;
import com.momo.mcamera.mask.bean.ObjectRegion;
import com.momocv.MMRect;
import com.momocv.objecttracker.ObjectTracker;
import com.momocv.objecttracker.ObjectTrackerInfo;
import com.momocv.objecttracker.ObjectTrackerParams;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class StickerGestureTrackingFilter
extends StickerMaskFilter {
    private static final int DETECT_MISS_COUNT = 3;
    private static final float DEFAULT_GESTURE_WIDTH = 180.0f;
    private boolean hasGestureRect = false;
    private RectF currentRect = null;
    private PointF currentCenter = null;
    private volatile boolean startTracking;
    private volatile boolean trackingInit;
    private int gestureMiss;
    private MMRect mmcvRect;
    private MMCVInfo mmcvInfo;
    private ObjectTracker mTracker = new ObjectTracker();
    private MMFrameInfo mmFrame = new MMFrameInfo();
    private ObjectTrackerParams trackerParams = new ObjectTrackerParams();
    private ObjectTrackerInfo trackerInfo = new ObjectTrackerInfo();

    public StickerGestureTrackingFilter(Context context, Sticker sticker) {
        super(context, sticker, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        if (detectParam.gestureRect != null) {
            this.currentRect = detectParam.gestureRect;
        }
        if (this.currentRect == null) {
            return;
        }
        Object object = this.maskListLock;
        synchronized (object) {
            float width = this.currentRect.right - this.currentRect.left;
            float height = this.currentRect.bottom - this.currentRect.top;
            float scale = width / 180.0f;
            scale /= this.getAdjustWidthScale();
            PointF centerPoint = null;
            detectParam.points8 = new float[8];
            detectParam.points8[0] = this.currentRect.left;
            detectParam.points8[1] = this.currentRect.right;
            detectParam.points8[2] = this.currentRect.left;
            detectParam.points8[3] = this.currentRect.right;
            detectParam.points8[4] = this.currentRect.top;
            detectParam.points8[5] = this.currentRect.top;
            detectParam.points8[6] = this.currentRect.bottom;
            detectParam.points8[7] = this.currentRect.bottom;
            if (null != detectParam.points8 && null != this.sticker.getPointIndexes() && this.sticker.getPointIndexes().length > 1) {
                int pointIndex1 = this.sticker.getPointIndexes()[0];
                int pointIndex2 = this.sticker.getPointIndexes()[1];
                float pX1 = detectParam.points8[pointIndex1];
                float pY1 = detectParam.points8[pointIndex1 + 4];
                float pX2 = detectParam.points8[pointIndex2];
                float pY2 = detectParam.points8[pointIndex2 + 4];
                centerPoint = this.getCenterPoint(new PointF(pX1, pY1), new PointF(pX2, pY2));
                centerPoint.x += (float)this.sticker.getOffsetX() * scale / 2.0f;
                centerPoint.y += (float)this.sticker.getOffsetY() * scale / 2.0f;
                centerPoint = new PointF(centerPoint.x / (float)this.getWidth(), centerPoint.y / (float)this.getHeight());
            } else {
                scale = width / 180.0f / this.getAdjustWidthScale();
                float centerX = this.currentRect.left + width / 2.0f + (float)this.sticker.getOffsetX() * scale;
                float centerY = this.currentRect.top + height / 2.0f + (float)this.sticker.getOffsetY() * scale;
                centerPoint = new PointF(centerX / (float)this.getWidth(), centerY / (float)this.getHeight());
            }
            this.setParamForMatrix(scale, scale, centerPoint, 0.0f, detectParam.filterTrigerManager);
        }
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        this.mmcvInfo = mmcvInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.trackingUpdate();
        }
        super.newTextureReady(texture, source, newData);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mTracker != null) {
            this.mTracker.Release();
        }
    }

    private void trackingUpdate() {
        if (this.startTracking && this.mmcvRect != null && this.mmcvInfo != null) {
            this.mmFrame.setFormat(17);
            this.mmFrame.setStep_(this.width);
            this.mmFrame.setWidth(this.width);
            this.mmFrame.setHeight(this.height);
            this.trackerParams.rect_ = this.mmcvRect;
            this.trackerInfo.rect_ = this.mmcvRect;
            if (!this.trackingInit) {
                this.mTracker.ReInit(this.mmFrame.getFrame(), this.trackerParams);
                this.trackingInit = true;
            } else {
                this.mTracker.Update(this.mmFrame.getFrame(), this.trackerParams, this.trackerInfo);
            }
            FaceDetectFilter.FaceDetectParam param = new FaceDetectFilter.FaceDetectParam();
            param.centerPoint = new PointF(0.0f, 0.0f);
            RectF rectF = new RectF();
            rectF.left = this.trackerInfo.rect_.x_;
            rectF.top = this.trackerInfo.rect_.y_;
            rectF.right = this.trackerInfo.rect_.x_ + this.trackerInfo.rect_.width_;
            rectF.bottom = this.trackerInfo.rect_.y_ + this.trackerInfo.rect_.height_;
            if (this.sticker.getTrackingRegion() != null) {
                this.adjustRectF(rectF);
            }
            param.gestureRect = rectF;
            this.setDetectParam(param);
        } else {
            this.trackingInit = false;
        }
    }

    private void adjustRectF(RectF rectF) {
        ObjectRegion region = this.sticker.getTrackingRegion();
        float width = rectF.width() / region.w;
        float height = rectF.height() / region.h;
        rectF.left -= width * region.x;
        rectF.top -= height * region.y;
        rectF.right = rectF.left + width;
        rectF.bottom = rectF.top + height;
    }

    public boolean isTrackingInit() {
        return this.trackingInit;
    }

    private void log(String info, MMRect mmcvRect) {
        if (mmcvRect != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(mmcvRect.x_).append(",").append(mmcvRect.y_).append(",").append(mmcvRect.x_ + mmcvRect.width_).append(",").append(mmcvRect.y_ + mmcvRect.height_).append("]");
            sb.append("   ").append(mmcvRect.y_ + mmcvRect.width_ / 2).append(" , ").append(mmcvRect.y_ + mmcvRect.height_ / 2);
        }
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return 1.5f;
    }

    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, FilterTriggerManager filterTrigerManager) {
        float sX = w;
        float sY = h;
        float tX = -(centerPoint.x * 2.0f - 1.0f);
        float tY = -centerPoint.y * 2.0f + 1.0f;
        float tAngle = angle;
        centerPoint.x = tX;
        centerPoint.y = tY;
        float[] mvpMatrix = new float[16];
        float[] newResult = new float[16];
        Matrix.setIdentityM((float[])newResult, (int)0);
        Matrix.translateM((float[])newResult, (int)0, (float)(-tX), (float)tY, (float)0.0f);
        Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])newResult, (int)0, (float[])mvpMatrix, (int)0);
        Matrix.rotateM((float[])mvpMatrix, (int)0, (float)tAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])mvpMatrix, (int)0, (float)(sX * 1.0f), (float)(sY * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])newResult, (int)0, (float[])mvpMatrix, (int)0, (float[])this.texData0, (int)0);
        float[] finalResult = new float[]{newResult[0], newResult[1], newResult[4], newResult[5], newResult[8], newResult[9], newResult[12], newResult[13]};
        this.mvpLists.add(finalResult);
    }

    public PointF getCenterPoint(PointF pointA, PointF pointB) {
        float deltalx = pointA.x + (pointB.x - pointA.x) / 2.0f;
        float deltaly = pointA.y + (pointB.y - pointA.y) / 2.0f;
        return new PointF(deltalx, deltaly);
    }

    @Override
    public void pauseBitmapCache() {
        super.pauseBitmapCache();
        if (null != this.sticker) {
            this.sticker.curIndex = 0;
            this.hasGestureRect = false;
            this.currentRect = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMMCVRect(MMRect mmcvRect) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mmcvRect = mmcvRect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.startTracking = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gestureMiss() {
        Object object = this.getLockObject();
        synchronized (object) {
            ++this.gestureMiss;
            if (this.gestureMiss >= 3) {
                this.gestureMiss = 0;
                this.startTracking = false;
                this.trackingInit = false;
                this.mmcvRect = null;
                this.pauseBitmapCache();
            }
        }
    }
}

