/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.opengl.ETC1Util;
import android.opengl.GLES20;
import com.core.glcore.util.FileUtil;
import com.momo.mcamera.mask.Etc1Batch;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.mask.batchbean.BatchFrame;
import com.momo.mcamera.mask.batchbean.BatchSize;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class StickerETC1Item
extends StickerItem {
    private String texturePath;
    public ETC1Util.ETC1Texture texture = this.getETC1Texture();
    private Etc1Batch etc1Batch;
    private long lastFrameTime = -1L;
    private int curIndex = 0;
    public int etc1_texture_sticker = 0;

    public StickerETC1Item(Sticker inSticker, Context context) {
        super(inSticker, context);
    }

    @Override
    public void initCoordinate() {
        float realWidth = 0.5f;
        String configJson = null;
        String jasonPath = this.sticker.getETC1JsonPath();
        try {
            configJson = FileUtil.readString((File)new File(jasonPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (configJson == null) {
            return;
        }
        this.etc1Batch = Etc1Batch.getEffectModel(configJson);
        this.updateETC1Coordinate();
        this.texData0 = new float[]{-realWidth, realWidth * this.stickerScale, 0.0f, 1.0f, -realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, -realWidth * this.stickerScale, 0.0f, 1.0f, realWidth, realWidth * this.stickerScale, 0.0f, 1.0f};
    }

    public void updateETC1Coordinate() {
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = System.currentTimeMillis();
            this.curIndex = this.sticker.getETC1ImageIndex();
        }
        if (System.currentTimeMillis() - this.lastFrameTime > 50L) {
            this.curIndex = this.sticker.getETC1ImageIndex();
            this.lastFrameTime = System.currentTimeMillis();
        }
        BatchFrame batchFrame = this.etc1Batch.getBatchStickers().get(this.curIndex).getFrame();
        BatchSize batchSize = this.etc1Batch.getBatchMeta().getSize();
        float topLeftX = (float)batchFrame.getImageX() / (float)batchSize.getImageBatchWidth();
        float topLeftY = (float)batchFrame.getImageY() / (float)(2 * batchSize.getImageBatchHeight());
        float bottomLeftX = (float)batchFrame.getImageX() / (float)batchSize.getImageBatchWidth();
        float bottomLeftY = (float)(batchFrame.getImageY() + batchFrame.getImageHeight()) / (float)(2 * batchSize.getImageBatchHeight());
        float bottomRightX = (float)(batchFrame.getImageX() + batchFrame.getImageWidth()) / (float)batchSize.getImageBatchWidth();
        float bottomRightY = (float)(batchFrame.getImageY() + batchFrame.getImageHeight()) / (float)(2 * batchSize.getImageBatchHeight());
        float topRightX = (float)(batchFrame.getImageX() + batchFrame.getImageWidth()) / (float)batchSize.getImageBatchWidth();
        float topRightY = (float)batchFrame.getImageY() / (float)(2 * batchSize.getImageBatchHeight());
        this.stickerScale = (float)batchFrame.getImageHeight() / (float)batchFrame.getImageWidth();
        float[] squareCoords = new float[]{-0.5f + topLeftX, 0.5f - topLeftY, -0.5f + bottomLeftX, 0.5f - bottomLeftY, -0.5f + bottomRightX, 0.5f - bottomRightY, -0.5f + topRightX, 0.5f - topRightY};
        float[] squareCoords2 = new float[]{-0.5f + topLeftX, -topLeftY, -0.5f + bottomLeftX, -bottomLeftY, -0.5f + bottomRightX, -bottomRightY, -0.5f + topRightX, -topRightY};
        ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = bb.asFloatBuffer();
        this.vertexBuffer.put(squareCoords);
        this.vertexBuffer.position(0);
        ByteBuffer bb2 = ByteBuffer.allocateDirect(squareCoords2.length * 4);
        bb2.order(ByteOrder.nativeOrder());
        this.vertexBuffer2 = bb2.asFloatBuffer();
        this.vertexBuffer2.put(squareCoords2);
        this.vertexBuffer2.position(0);
    }

    private ETC1Util.ETC1Texture loadPkmFile(String path) {
        ETC1Util.ETC1Texture textureEtc1 = null;
        try {
            File file = new File(path);
            FileInputStream inputStream = new FileInputStream(file);
            textureEtc1 = ETC1Util.createTexture((InputStream)inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return textureEtc1;
    }

    private ETC1Util.ETC1Texture getETC1Texture() {
        if (this.texturePath == null) {
            this.texturePath = this.sticker.getETC1Path();
            this.texture = this.loadPkmFile(this.texturePath);
        }
        return this.texture;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.etc1_texture_sticker != 0) {
            int[] tex = new int[]{this.etc1_texture_sticker};
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
            this.etc1_texture_sticker = 0;
        }
    }
}

